package ext.tree.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.tree.events.TreePanel_node_refNodeEvent")]
public class TreePanel_node_refNodeEvent extends FlExtEvent {
  /**
   * Fires before a new child is inserted, return false to cancel the insert.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-beforeiteminsert Original Ext JS documentation of 'beforeiteminsert'
   * @see ext.tree.TreePanel
   * @eventType onBeforeItemInsert
   */
  public static const BEFORE_ITEM_INSERT:String = "onBeforeItemInsert";
  /**
   * Fires when a new child node is inserted.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-iteminsert Original Ext JS documentation of 'iteminsert'
   * @see ext.tree.TreePanel
   * @eventType onItemInsert
   */
  public static const ITEM_INSERT:String = "onItemInsert";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "node", "refNode", "eOpts"];

  public function TreePanel_node_refNodeEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The child node to be inserted
   */
  public native function get node():NodeInterface;

  /**
   * The child node the node is being
   * inserted before
   */
  public native function get refNode():NodeInterface;

  /**
   * This node
   */
  public native function get source():NodeInterface;
}
}