package ext.tree.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.tree.events.TreePanel_oldParent_newParent_indexEvent")]
public class TreePanel_oldParent_newParent_indexEvent extends FlExtEvent {
  /**
   * Fires before this node is moved to a new location in the tree. Return false
   * to cancel the move.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-beforeitemmove Original Ext JS documentation of 'beforeitemmove'
   * @see ext.tree.TreePanel
   * @eventType onBeforeItemMove
   */
  public static const BEFORE_ITEM_MOVE:String = "onBeforeItemMove";
  /**
   * Fires when this node is moved to a new location in the tree
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-itemmove Original Ext JS documentation of 'itemmove'
   * @see ext.tree.TreePanel
   * @eventType onItemMove
   */
  public static const ITEM_MOVE:String = "onItemMove";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "oldParent", "newParent", "index", "eOpts"];

  public function TreePanel_oldParent_newParent_indexEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The index it is being moved to
   */
  public native function get index():Number;

  /**
   * The new parent this node is moving
   * to
   */
  public native function get newParent():NodeInterface;

  /**
   * The parent of this node
   */
  public native function get oldParent():NodeInterface;

  /**
   * This node
   */
  public native function get source():NodeInterface;
}
}