package ext.tree.events {
import ext.data.NodeInterface;
import ext.event.Event;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.tree.events.TreeView_targetNode_position_dragData_eEvent")]
public class TreeView_targetNode_position_dragData_eEvent extends FlExtEvent {
  /**
   * Fires when a tree node is being targeted for a drag drop, return false to signal
   * drop not allowed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#event-nodedragover Original Ext JS documentation of 'nodedragover'
   * @see ext.tree.TreeView
   * @eventType onNodeDragOver
   */
  public static const NODE_DRAG_OVER:String = "onNodeDragOver";
  public static const __PARAMETER_SEQUENCE__:Array = ["targetNode", "position", "dragData", "e", "eOpts"];

  public function TreeView_targetNode_position_dragData_eEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * Data relating to the drag operation
   */
  public native function get dragData():Object;

  /**
   * The event object for the drag
   */
  public native function get e():Event;

  /**
   * The drop position, "before", "after" or "append",
   */
  public native function get position():String;

  /**
   * The target node
   */
  public native function get targetNode():NodeInterface;
}
}