package ext.tree.plugin {
import ext.grid.ViewDropZone;
import ext.plugin.AbstractPlugin;
import ext.view.ViewDragZone;

[Native("Ext.tree.plugin.TreeViewDragDrop", require)]
/**
 * @see ext.tree.plugin.events.TreeViewDragDropPlugin_node_data_overModel_dropPosition_dropHandlersEvent.BEFORE_DROP
 * @eventType ext.tree.plugin.events.TreeViewDragDropPlugin_node_data_overModel_dropPosition_dropHandlersEvent.BEFORE_DROP
 */
[Event(name='onBeforeDrop', type='ext.tree.plugin.events.TreeViewDragDropPlugin_node_data_overModel_dropPosition_dropHandlersEvent')]
/**
 * @see ext.tree.plugin.events.TreeViewDragDropPlugin_node_data_overModel_dropPositionEvent.DROP
 * @eventType ext.tree.plugin.events.TreeViewDragDropPlugin_node_data_overModel_dropPositionEvent.DROP
 */
[Event(name='onDrop', type='ext.tree.plugin.events.TreeViewDragDropPlugin_node_data_overModel_dropPositionEvent')]
/**
 * This plugin provides drag and drop functionality for a →<code>ext.tree.TreeView</code>.
 * <p>A specialized instance of →<code>ext.dd.DragZone</code> and →<code>ext.dd.DropZone</code> are attached to the tree view. The DropZone will participate in drops
 * from DragZones having the same →<code>ddGroup</code> including drops from within the same
 * tree.</p>
 * <p>During the drop operation a data object is passed to a participating DropZone's drop
 * handlers. The drag data object has the following properties:</p>
 * <ul>
 * <li>
 * <p><b>copy:</b> →<code>Boolean</code> <br> The value of →<code>copy</code>. Or <code>true</code> if →<code>allowCopy</code>
 * is true <b>and</b> the control key was pressed as the drag operation began.</p>
 * </li>
 * <li>
 * <p><b>view:</b> →<code>ext.tree.TreeView</code> <br> The source tree view from which the
 * drag originated</p>
 * </li>
 * <li>
 * <p><b>ddel:</b> HTMLElement <br> The drag proxy element which moves with the cursor</p>
 * </li>
 * <li>
 * <p><b>item:</b> HTMLElement <br> The tree view node upon which the mousedown event was
 * registered</p>
 * </li>
 * <li>
 * <p><b>records:</b> →<code>Array</code> <br> An Array of →<code>ext.data.Model</code>s
 * representing the selected data being dragged from the source tree view.</p>
 * </li>
 * </ul>
 * <p>By adding this plugin to a view, two new events will be fired from the client
 * tree view as well as its owning Tree: <code>→event:onBeforeDrop</code> and <code>→event:onDrop</code>.</p>
 * <pre>
 * var store = Ext.create('Ext.data.TreeStore', {
 *     root: {
 *         expanded: true,
 *         children: [{
 *             text: "detention",
 *             leaf: true
 *         }, {
 *             text: "homework",
 *             expanded: true,
 *             children: [{
 *                 text: "book report",
 *                 leaf: true
 *             }, {
 *                 text: "algebra",
 *                 leaf: true
 *             }]
 *         }, {
 *             text: "buy lottery tickets",
 *             leaf: true
 *         }]
 *     }
 * });
 *
 * Ext.create('Ext.tree.Panel', {
 *     title: 'Simple Tree',
 *     width: 200,
 *     height: 200,
 *     store: store,
 *     rootVisible: false,
 *     renderTo: document.body,
 *     viewConfig: {
 *         plugins: {
 *             treeviewdragdrop: {
 *                 dragText: 'Drag and drop to reorganize'
 *             }
 *         }
 *     }
 * });
 * </pre>
 * @see ext.tree.TreeView
 * @see ext.dd.DragZone
 * @see ext.dd.DropZone
 * @see #ddGroup
 * @see Boolean
 * @see #copy
 * @see #allowCopy
 * @see Array
 * @see ext.data.Model
 * @see #event:onBeforeDrop
 * @see #event:onDrop
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html Original Ext JS documentation of 'Ext.tree.plugin.TreeViewDragDrop'
 */
public class TreeViewDragDropPlugin extends AbstractPlugin {
  /**
   * @param config @inheritDoc
   */
  public function TreeViewDragDropPlugin(config:TreeViewDragDropPlugin = null) {
    super();
  }

  [ExtConfig]
  /**
   * True if drops on the tree container (outside of a specific tree node) are allowed.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-allowContainerDrops Original Ext JS documentation of 'allowContainerDrops'
   */
  public native function get allowContainerDrops():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowContainerDrops(value:Boolean):void;

  [ExtConfig]
  /**
   * Set as <code>true</code> to allow the user to hold down the control key at the start of the
   * drag operation and copy the dragged records between grids. Otherwise, dragged
   * records will be moved.
   * <p><b>Note:</b> This only applies to records dragged between two different grids with
   * unique stores.</p>
   * <p>See →<code>copy</code> to enable the copying of all dragged records.</p>
   * @default false
   * @see #copy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-allowCopy Original Ext JS documentation of 'allowCopy'
   */
  public native function get allowCopy():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowCopy(value:Boolean):void;

  [ExtConfig]
  /**
   * Allow inserting a dragged node between an expanded parent node and its first child
   * that will become a sibling of the parent when dropped.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-allowParentInserts Original Ext JS documentation of 'allowParentInserts'
   */
  public native function get allowParentInserts():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowParentInserts(value:Boolean):void;

  [ExtConfig]
  /**
   * True if the tree should only allow append drops (use for trees which are sorted).
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-appendOnly Original Ext JS documentation of 'appendOnly'
   */
  public native function get appendOnly():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set appendOnly(value:Boolean):void;

  [ExtConfig]
  /**
   * True to register this container with the Scrollmanager for auto scrolling during
   * drag operations. A →<code>ext.dd.ScrollManager</code> configuration may also be passed.
   * @default false
   * @see ext.dd.#ScrollManager ext.dd.ScrollManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-containerScroll Original Ext JS documentation of 'containerScroll'
   */
  public native function get containerScroll():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set containerScroll(value:*):void;

  [ExtConfig]
  /**
   * Set as <code>true</code> to copy the records from the source grid to the destination drop
   * grid. Otherwise, dragged records will be moved.
   * <p><b>Note:</b> This only applies to records dragged between two different grids with
   * unique stores.</p>
   * <p>See →<code>allowCopy</code> to allow only control-drag operations to copy records.</p>
   * @default false
   * @see #allowCopy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-copy Original Ext JS documentation of 'copy'
   */
  public native function get copy():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set copy(value:Boolean):void;

  [ExtConfig]
  /**
   * A named drag drop group to which this object belongs. If a group is specified, then both
   * the DragZones and DropZone used by this plugin will only interact with other drag drop
   * objects in the same group.
   * @default TreeDD
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-ddGroup Original Ext JS documentation of 'ddGroup'
   */
  public native function get ddGroup():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ddGroup(value:String):void;

  [ExtConfig]
  /**
   * The name of the model field that is used to display the text for the nodes
   * @default text
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-displayField Original Ext JS documentation of 'displayField'
   */
  public native function get displayField():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set displayField(value:String):void;

  [ExtConfig]
  /**
   * The ddGroup to which the <i>DragZone</i> (→<code>dragZone</code>) will belong.
   * <p>This defines which other DropZones the DragZone will interact with. Drag/DropZones
   * only interact with other Drag/DropZones which are members of the same ddGroup.</p>
   * @see #dragZone
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-dragGroup Original Ext JS documentation of 'dragGroup'
   */
  public native function get dragGroup():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dragGroup(value:String):void;

  [ExtConfig]
  /**
   * The text to show while dragging.
   * <p>Two placeholders can be used in the text:</p>
   * <ul>
   * <li><code>{0}</code> The number of selected items.</li>
   * <li><code>{1}</code> 's' when more than 1 items (only useful for English).</li>
   * </ul>
   * <p><b>NOTE:</b> The node's <i>text</i> (→<code>ext.tree.TreePanel.displayField</code>) will be shown
   * when a single node is dragged unless <code>→dragText</code> is a simple text string.</p>
   * @default '{0} selected node{1}'
   * @see ext.tree.TreePanel#displayField
   * @see #dragText
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-dragText Original Ext JS documentation of 'dragText'
   */
  public native function get dragText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dragText(value:String):void;

  [ExtConfig]
  /**
   * An →<code>ext.view.ViewDragZone</code> which handles mousedown and dragging of records
   * from the grid.
   * @see ext.view.ViewDragZone
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#property-dragZone Original Ext JS documentation of 'dragZone'
   */
  public native function get dragZone():ViewDragZone;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dragZone(value:ViewDragZone):void;

  [ExtConfig]
  /**
   * The ddGroup to which the <i>DropZone</i> (→<code>dropZone</code>) will belong.
   * <p>This defines which other DragZones the DropZone will interact with. Drag/DropZones
   * only interact with other Drag/DropZones which are members of the same →<code>ddGroup</code>.</p>
   * @see #dropZone
   * @see #ddGroup
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-dropGroup Original Ext JS documentation of 'dropGroup'
   */
  public native function get dropGroup():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dropGroup(value:String):void;

  [ExtConfig]
  /**
   * An <i>DropZone</i> (→<code>ext.grid.ViewDropZone</code>) which handles mouseover and dropping records
   * in any grid which shares the same →<code>dropGroup</code>.
   * @see ext.grid.ViewDropZone
   * @see #dropGroup
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#property-dropZone Original Ext JS documentation of 'dropZone'
   */
  public native function get dropZone():ViewDropZone;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dropZone(value:ViewDropZone):void;

  [ExtConfig]
  /**
   * Set to <code>false</code> to disallow dragging items from the View.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-enableDrag Original Ext JS documentation of 'enableDrag'
   */
  public native function get enableDrag():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableDrag(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to <code>false</code> to disallow the View from accepting drop gestures.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-enableDrop Original Ext JS documentation of 'enableDrop'
   */
  public native function get enableDrop():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableDrop(value:Boolean):void;

  [ExtConfig]
  /**
   * The delay in milliseconds to wait before expanding a target tree node while dragging
   * a droppable node over the target.
   * @default 1000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-expandDelay Original Ext JS documentation of 'expandDelay'
   */
  public native function get expandDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set expandDelay(value:Number):void;

  [ExtConfig]
  /**
   * The color to use when visually highlighting the dragged or dropped node (default value
   * is light blue). The color must be a 6 digit hex value, without a preceding '#'.
   * See also →<code>nodeHighlightOnDrop</code> and
   * →<code>nodeHighlightOnRepair</code>.
   * @default c3daf9
   * @see #nodeHighlightOnDrop
   * @see #nodeHighlightOnRepair
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-nodeHighlightColor Original Ext JS documentation of 'nodeHighlightColor'
   */
  public native function get nodeHighlightColor():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nodeHighlightColor(value:String):void;

  [ExtConfig]
  /**
   * Whether or not to highlight any nodes after they are
   * successfully dropped on their target. Defaults to the value of <code>Ext.enableFx</code>.
   * See also →<code>nodeHighlightColor</code> and →<code>nodeHighlightOnRepair</code>.
   * @default Ext.enableFx
   * @see #nodeHighlightColor
   * @see #nodeHighlightOnRepair
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-nodeHighlightOnDrop Original Ext JS documentation of 'nodeHighlightOnDrop'
   */
  public native function get nodeHighlightOnDrop():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nodeHighlightOnDrop(value:Boolean):void;

  [ExtConfig]
  /**
   * Whether or not to highlight any nodes after they are
   * repaired from an unsuccessful drag/drop. Defaults to the value of <code>Ext.enableFx</code>.
   * See also →<code>nodeHighlightColor</code> and →<code>nodeHighlightOnDrop</code>.
   * @see #nodeHighlightColor
   * @see #nodeHighlightOnDrop
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-nodeHighlightOnRepair Original Ext JS documentation of 'nodeHighlightOnRepair'
   */
  public native function get nodeHighlightOnRepair():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nodeHighlightOnRepair(value:Boolean):void;

  [ExtConfig]
  /**
   * Configure as <code>true</code> to sort the target node into the current tree sort order after
   * the dropped node is added.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.plugin.TreeViewDragDrop.html#cfg-sortOnDrop Original Ext JS documentation of 'sortOnDrop'
   */
  public native function get sortOnDrop():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set sortOnDrop(value:Boolean):void;
}
}