package ext.util {
import ext.mixin.Observable;

[Native("Ext.util.AbstractMixedCollection", require)]
/**
 * @see ext.util.events.AbstractMixedCollection_index_o_keyEvent.ADD
 * @eventType ext.util.events.AbstractMixedCollection_index_o_keyEvent.ADD
 */
[Event(name='onAdd', type='ext.util.events.AbstractMixedCollection_index_o_keyEvent')]
/**
 * @see ext.util.events.AbstractMixedCollectionEvent.CLEAR
 * @eventType ext.util.events.AbstractMixedCollectionEvent.CLEAR
 */
[Event(name='onClear', type='ext.util.events.AbstractMixedCollectionEvent')]
/**
 * @see ext.util.events.AbstractMixedCollection_o_keyEvent.REMOVE
 * @eventType ext.util.events.AbstractMixedCollection_o_keyEvent.REMOVE
 */
[Event(name='onRemove', type='ext.util.events.AbstractMixedCollection_o_keyEvent')]
/**
 * @see ext.util.events.AbstractMixedCollection_key_old_newEvent.REPLACE
 * @eventType ext.util.events.AbstractMixedCollection_key_old_newEvent.REPLACE
 */
[Event(name='onReplace', type='ext.util.events.AbstractMixedCollection_key_old_newEvent')]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html Original Ext JS documentation of 'Ext.util.AbstractMixedCollection'
 */
public class AbstractMixedCollection extends ext.mixin.Observable {
  /**
   * @param config @inheritDoc
   */
  public function AbstractMixedCollection(config:AbstractMixedCollection = null) {
    super();
  }

  [ExtConfig]
  /**
   * Specify <code>true</code> if the →<code>addAll()</code>
   * function should add function references to the collection. Defaults to
   * <code>false</code>.
   * @default false
   * @since 3.4.0
   * @see #addAll()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#cfg-allowFunctions Original Ext JS documentation of 'allowFunctions'
   */
  public native function get allowFunctions():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowFunctions(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated MixedCollection,
   * or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#property-isMixedCollection Original Ext JS documentation of 'isMixedCollection'
   */
  public native function get isMixedCollection():Boolean;

  /**
   * @private
   */
  public native function set isMixedCollection(value:Boolean):void;

  /**
   * Returns the number of items in the collection.
   * Better use <code>getCount()</code>.
   * @see #getCount()
   */
  [Deprecated(replacement="getCount()")]
  public native function get length():uint;

  /**
   * Adds an item to the collection. Fires the →<code>event:onAdd</code> event when complete.
   * @since 1.1.0
   * @param key The key to associate with the item, or the new item.
   * <p>If a →<code>getKey()</code> implementation was specified for this MixedCollection,
   * or if the key of the stored items is in a property called <code>id</code>,
   * the MixedCollection will be able to <i>derive</i> the key for the new item.
   * In this case just pass the new item in this parameter.</p>
   * @param obj The item to add.
   * <p>Note that when adding a value that is iterable, it must be wrapped in brackets, i.e.:</p>
   * <pre>
   * c.add([[1, 2]]);
   * </pre>
   * <p>This will be needed for any value that is iterable, i.e., an array, arguments object,
   * HTML collections, etc.</p>
   * @return The item added.
   * @see #event:onAdd
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-add Original Ext JS documentation of 'add'
   * @see #getKey()
   */
  public native function add(key:*, obj:Object = null):Object;

  /**
   * Adds all elements of an Array or an Object to the collection.
   * @since 1.1.0
   * @param objs An Object containing properties which will be added
   * to the collection, or an Array of values, each of which are added to the collection.
   * Functions references will be added to the collection if <code>→allowFunctions</code>
   * has been set to <code>true</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-addAll Original Ext JS documentation of 'addAll'
   * @see #allowFunctions
   */
  public native function addAll(objs:*):void;

  /**
   * Removes all items from the collection. Fires the →<code>event:onClear</code> event when complete.
   * @since 1.1.0
   * @see #event:onClear
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear():void;

  /**
   * Creates a shallow copy of this collection
   * @since 1.1.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone():MixedCollection;

  /**
   * Collects unique values of a particular property in this MixedCollection
   * @param property The property to collect on
   * @param root 'root' property to extract the first argument from. This is
   * used mainly when summing fields in records, where the fields are all stored inside the 'data'
   * object
   * @param allowNull Pass true to allow null, undefined or empty string
   * values
   * @return The unique values
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-collect Original Ext JS documentation of 'collect'
   */
  public native function collect(property:String, root:String = null, allowNull:Boolean = false):Array;

  /**
   * Returns true if the collection contains the passed Object as an item.
   * @since 1.1.0
   * @param o The Object to look for in the collection.
   * @return True if the collection contains the Object as an item.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(o:Object):Boolean;

  /**
   * Returns true if the collection contains the passed Object as a key.
   * @since 1.1.0
   * @param key The key to look for in the collection.
   * @return True if the collection contains the Object as a key.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-containsKey Original Ext JS documentation of 'containsKey'
   */
  public native function containsKey(key:String):Boolean;

  /**
   * Executes the specified function once for every item in the collection.
   * The function should return a boolean value.
   * Returning false from the function will stop the iteration.
   * @since 1.1.0
   * @param fn The function to execute for each item.
   * <ul>
   * <li><code>item</code> (optional) —
   * The collection item.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The index of item.
   * </li>
   * <li><code>len:Number</code> (optional) —
   * Total length of collection.
   * </li>
   * </ul>
   * @param scope The scope (<code>this</code> reference)
   * in which the function is executed. Defaults to the current item in the iteration.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(fn:Function, scope:Object = null):void;

  /**
   * Executes the specified function once for every key in the collection, passing each
   * key, and its associated item as the first two parameters.
   * @since 1.1.0
   * @param fn The function to execute for each item.
   * <ul>
   * <li><code>key:String</code> (optional) —
   * The key of collection item.
   * </li>
   * <li><code>item</code> (optional) —
   * The collection item.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The index of item.
   * </li>
   * <li><code>len:Number</code> (optional) —
   * Total length of collection.
   * </li>
   * </ul>
   * @param scope The scope (<code>this</code> reference) in which the
   * function is executed. Defaults to the browser window.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-eachKey Original Ext JS documentation of 'eachKey'
   */
  public native function eachKey(fn:Function, scope:Object = null):void;

  /**
   * Filters the objects in this collection by a set of →<code>ext.util.Filter</code>s, or by
   * a single property/value pair with optional parameters for substring matching and
   * case sensitivity. See →<code>ext.util.Filter</code> for an example of using Filter objects
   * (preferred). Alternatively, MixedCollection can be easily filtered by property like this:
   * <pre>
   * // create a simple store with a few people defined
   * var people = new Ext.util.MixedCollection();
   * people.addAll([
   *     {id: 1, age: 25, name: 'Ed'},
   *     {id: 2, age: 24, name: 'Tommy'},
   *     {id: 3, age: 24, name: 'Arne'},
   *     {id: 4, age: 26, name: 'Aaron'}
   * ]);
   *
   * // a new MixedCollection containing only the items where age == 24
   * var middleAged = people.filter('age', 24);
   * </pre>
   * @since 1.1.0
   * @param property A property on your objects, or an array
   * of →<code>ext.util.Filter</code> objects
   * @param value Either string that the property values
   * should start with or a RegExp to test against the property
   * @param anyMatch True to match any part of the string,
   * not just the beginning
   * @default false
   * @param caseSensitive True for case sensitive comparison.
   * @default false
   * @return The new filtered collection
   * @see ext.util.Filter
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-filter Original Ext JS documentation of 'filter'
   */
  public native function filter(property:String, value:*, anyMatch:Boolean = false, caseSensitive:Boolean = false):MixedCollection;

  /**
   * Filter by a function. Returns a <i>new</i> collection that has been filtered.
   * The passed function will be called with each object in the collection.
   * If the function returns true, the value is included otherwise it is filtered.
   * @since 1.1.0
   * @param fn The function to be called.
   * <ul>
   * <li><code>item</code> (optional) —
   * The collection item.
   * </li>
   * <li><code>key:String</code> (optional) —
   * The key of collection item.
   * </li>
   * </ul>
   * @param scope The scope (<code>this</code> reference) in
   * which the function is executed. Defaults to this MixedCollection.
   * @return The new filtered collection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-filterBy Original Ext JS documentation of 'filterBy'
   */
  public native function filterBy(fn:Function, scope:Object = null):MixedCollection;

  [Deprecated(replacement="findBy", since="4.0")]
  /**
   * Returns the first item in the collection which elicits a true return value from the
   * passed selection function.
   * @param fn The selection function to execute for each item.
   * @param scope The scope (<code>this</code> reference) in which the
   * function is executed. Defaults to the browser window.
   * @return The first item in the collection which returned true from the selection
   * function, or null if none was found.
   * @since 1.1.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-find Original Ext JS documentation of 'find'
   */
  public native function find(fn:Function, scope:Object = null):Object;

  /**
   * Returns the first item in the collection which elicits a true return value from the
   * passed selection function.
   * @param fn The selection function to execute for each item.
   * <ul>
   * <li><code>item</code> (optional) —
   * The collection item.
   * </li>
   * <li><code>key:String</code> (optional) —
   * The key of collection item.
   * </li>
   * </ul>
   * @param scope The scope (<code>this</code> reference) in which the
   * function is executed. Defaults to the browser window.
   * @return The first item in the collection which returned true from the selection
   * function, or null if none was found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-findBy Original Ext JS documentation of 'findBy'
   */
  public native function findBy(fn:Function, scope:Object = null):Object;

  /**
   * Finds the index of the first matching object in this collection by a specific property/value.
   * @since 2.3.0
   * @param property The name of a property on your objects.
   * @param value A string that the property values
   * should start with or a RegExp to test against the property.
   * @param start The index to start searching at.
   * @default 0
   * @param anyMatch True to match any part of the string,
   * not just the beginning.
   * @default false
   * @param caseSensitive True for case sensitive comparison.
   * @default false
   * @return The matched index or -1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-findIndex Original Ext JS documentation of 'findIndex'
   */
  public native function findIndex(property:String, value:*, start:Number = 0, anyMatch:Boolean = false, caseSensitive:Boolean = false):Number;

  /**
   * Find the index of the first matching object in this collection by a function.
   * If the function returns <i>true</i> it is considered a match.
   * @since 2.3.0
   * @param fn The function to be called.
   * <ul>
   * <li><code>item</code> (optional) —
   * The collection item.
   * </li>
   * <li><code>key:String</code> (optional) —
   * The key of collection item.
   * </li>
   * </ul>
   * @param scope The scope (<code>this</code> reference) in which the function
   * is executed. Defaults to this MixedCollection.
   * @param start The index to start searching at.
   * @default 0
   * @return The matched index or -1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-findIndexBy Original Ext JS documentation of 'findIndexBy'
   */
  public native function findIndexBy(fn:Function, scope:Object = null, start:Number = 0):Number;

  /**
   * Returns the first item in the collection.
   * @since 1.1.0
   * @return the first item in the collection..
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-first Original Ext JS documentation of 'first'
   */
  public native function first():Object;

  /**
   * Returns the item associated with the passed key OR index.
   * Key has priority over index. This is the equivalent
   * of calling →<code>getByKey()</code> first, then if nothing matched calling →<code>getAt()</code>.
   * @since 1.1.0
   * @param key The key or index of the item.
   * @return If the item is found, returns the item. If the item was not found,
   * returns <code>undefined</code>. If an item was found, but is a Class, returns <code>null</code>.
   * @see #getByKey()
   * @see #getAt()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-get Original Ext JS documentation of 'get'
   */
  public native function get(key:*):Object;

  /**
   * Returns the item at the specified index.
   * @param index The index of the item.
   * @return The item at the specified index.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-getAt Original Ext JS documentation of 'getAt'
   */
  public native function getAt(index:Number):Object;

  /**
   * Returns the item associated with the passed key.
   * @param key The key of the item.
   * @return The item associated with the passed key.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-getByKey Original Ext JS documentation of 'getByKey'
   */
  public native function getByKey(key:*):Object;

  /**
   * Returns the number of items in the collection.
   * @since 1.1.0
   * @return the number of items in the collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-getCount Original Ext JS documentation of 'getCount'
   */
  public native function getCount():Number;

  /**
   * A function which will be called, passing a newly added object
   * when the object is added without a separate id. The function
   * should yield the key by which that object will be indexed.
   * <p>If no key is yielded, then the object will be added, but it
   * cannot be accessed or removed quickly. Finding it in this
   * collection for interrogation or removal will require a linear
   * scan of this collection's items.</p>
   * <p>The default implementation simply returns <code>item.id</code> but you can
   * provide your own implementation to return a different value as
   * in the following examples:</p>
   * <pre>
   * // normal way
   * var mc = new Ext.util.MixedCollection();
   * mc.add(someEl.dom.id, someEl);
   * mc.add(otherEl.dom.id, otherEl);
   * //and so on
   *
   * // using getKey
   * var mc = new Ext.util.MixedCollection({
   *     getKey: function(el){
   *         return el.dom.id;
   *     }
   * });
   * mc.add(someEl);
   * mc.add(otherEl);
   * </pre>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @since 1.1.0
   * @param item The item for which to find the key.
   * @return The key for the passed item.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-getKey Original Ext JS documentation of 'getKey'
   */
  public native function getKey(item:Object):Object;

  /**
   * Returns a range of items in this collection
   * @since 1.1.0
   * @param start The starting index. Defaults to 0.
   * @param end The ending index. Defaults to the last item.
   * @return An array of items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-getRange Original Ext JS documentation of 'getRange'
   */
  public native function getRange(start:Number = 0, end:Number = NaN):Array;

  /**
   * Returns index within the collection of the passed Object.
   * @since 1.1.0
   * @param o The item to find the index of.
   * @return index of the item. Returns -1 if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-indexOf Original Ext JS documentation of 'indexOf'
   */
  public native function indexOf(o:Object):Number;

  /**
   * Returns index within the collection of the passed key.
   * @since 1.1.0
   * @param key The key to find the index of.
   * @return index of the key.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-indexOfKey Original Ext JS documentation of 'indexOfKey'
   */
  public native function indexOfKey(key:String):Number;

  /**
   * Inserts an item at the specified index in the collection. Fires the →<code>event:onAdd</code>
   * event when complete.
   * @since 1.1.0
   * @param index The index to insert the item at.
   * @param key The key to associate with the new item,
   * or the item itself. May also be an array of either to insert multiple items at once.
   * @param obj If the second parameter was a key, the new item.
   * May also be an array to insert multiple items at once.
   * @return The item inserted or an array of items inserted.
   * @see #event:onAdd
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-insert Original Ext JS documentation of 'insert'
   */
  public native function insert(index:Number, key:String, obj:Object = undefined):Object;

  /**
   * Returns the last item in the collection.
   * @since 1.1.0
   * @return the last item in the collection..
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-last Original Ext JS documentation of 'last'
   */
  public native function last():Object;

  /**
   * Remove an item from the collection.
   * @since 1.1.0
   * @param o The item to remove.
   * @return The item removed or false if no item was removed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-remove Original Ext JS documentation of 'remove'
   */
  public native function remove(o:Object):Object;

  /**
   * Remove all items in the collection. Can also be used
   * to remove only the items in the passed array.
   * @param items An array of items to be removed.
   * @return this object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-removeAll Original Ext JS documentation of 'removeAll'
   */
  public native function removeAll(items:Array = null):MixedCollection;

  /**
   * Remove an item from a specified index in the collection. Fires the →<code>event:onRemove</code>
   * event when complete.
   * @since 1.1.0
   * @param index The index within the collection of the item to remove.
   * @return The item removed or false if no item was removed.
   * @see #event:onRemove
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-removeAt Original Ext JS documentation of 'removeAt'
   */
  public native function removeAt(index:Number):Object;

  /**
   * Removes an item associated with the passed key fom the collection.
   * @param key The key of the item to remove. If <code>null</code> is passed,
   * all objects which yielded no key from the configured →<code>getKey()</code> function are removed.
   * @return Only returned if removing at a specified key. The item removed or false
   * if no item was removed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-removeAtKey Original Ext JS documentation of 'removeAtKey'
   * @see #getKey()
   */
  public native function removeAtKey(key:String):Object;

  /**
   * Remove a range of items starting at a specified index in the collection.
   * Does not fire the remove event.
   * @param index The index within the collection of the item to remove.
   * @param removeCount The nuber of items to remove beginning at the
   * specified index.
   * @default 1
   * @return The last item removed or false if no item was removed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-removeRange Original Ext JS documentation of 'removeRange'
   */
  public native function removeRange(index:Number, removeCount:Number = 1):Object;

  /**
   * Reorders each of the items based on a mapping from old index to new index. Internally this
   * just translates into a sort. The 'sort' event is fired whenever reordering has
   * occurred.
   * @param mapping Mapping from old item index to new item index
   * <pre>
   * // example of moving the last of 4 items to the front of the collection
   * // and moving each one before it forward one
   * collection.reorder({
   *     0: 1,
   *     1: 2,
   *     2: 3,
   *     3: 0,
   * });
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-reorder Original Ext JS documentation of 'reorder'
   */
  public native function reorder(mapping:Object):void;

  /**
   * Replaces an item in the collection. Fires the →<code>event:onReplace</code> event when complete.
   * @since 1.1.0
   * @param key The key associated with the item to replace, or the replacement item.
   * <p>If you supplied a →<code>getKey()</code> implementation for this MixedCollection, or if the key
   * of your stored items is in a property called <i><code>id</code></i>, then the MixedCollection
   * will be able to <i>derive</i> the key of the replacement item. If you want to replace an item
   * with one having the same key value, then just pass the replacement item in this parameter.</p>
   * @param o o (optional) If the first parameter passed was a key, the item to associate
   * with that key.
   * @return The new item.
   * @see #event:onReplace
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-replace Original Ext JS documentation of 'replace'
   * @see #getKey()
   */
  public native function replace(key:String, o:Object):Object;

  /**
   * Collects all of the values of the given property and returns their sum
   * @param property The property to sum by
   * @param root 'root' property to extract the first argument from. This is used
   * mainly when summing fields in records, where the fields are all stored inside the 'data'
   * object
   * @param start The record index to start at
   * @default 0
   * @param end The record index to end at
   * @default -1
   * @return The total
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-sum Original Ext JS documentation of 'sum'
   */
  public native function sum(property:String, root:String = null, start:Number = 0, end:Number = -1):Number;

  /**
   * Change the key for an existing item in the collection. If the old key
   * does not exist this is a no-op.
   * @param oldKey The old key
   * @param newKey The new key
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#method-updateKey Original Ext JS documentation of 'updateKey'
   */
  public native function updateKey(oldKey:Object, newKey:Object):void;
}
}