package ext.util {
import ext.Base;

[Native("Ext.util.BasicFilter", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.BasicFilter.html Original Ext JS documentation of 'Ext.util.BasicFilter'
 */
public class BasicFilter extends Base {
  /**
   * Initializes a filter.
   * @param config The config object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.BasicFilter.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function BasicFilter(config:Object) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Setting this property to <code>true</code> disables this individual filter.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.BasicFilter.html#cfg-disabled Original Ext JS documentation of 'disabled'
   * @see #getDisabled()
   * @see #setDisabled()
   */
  public native function get disabled():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set disabled(value:Boolean):void;

  /**
   * this property is a Mutation counter which is incremented whenever the filter changes
   * in a way that may change either its serialized form or its result.
   * @default 0
   * @since 6.5.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.BasicFilter.html#property-generation Original Ext JS documentation of 'generation'
   */
  public native function get generation():Number;

  [ExtConfig]
  [Bindable]
  /**
   * An identifier by which this Filter is known, for example, as a member of a
   * <i>Store's filters collection</i> (→<code>ext.data.Store.filters</code>).
   * <p>Identified filters are manageable in such collections because they can be found
   * or removed using their <code>→id</code>.</p>
   * @see ext.data.Store#filters
   * @see #id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.BasicFilter.html#cfg-id Original Ext JS documentation of 'id'
   * @see #getId()
   * @see #setId()
   */
  public native function get id():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set id(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A function to post-process any serialization. Accepts the serialized filter
   * containing <code>property</code>, <code>value</code> and <code>operator</code> properties, and may either
   * mutate it, or return a completely new representation. Returning a falsy
   * value does not modify the representation.
   * @since 6.2.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.BasicFilter.html#cfg-serializer Original Ext JS documentation of 'serializer'
   * @see #getSerializer()
   * @see #setSerializer()
   */
  public native function get serializer():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set serializer(value:Function):void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.BasicFilter.html#method-filter Original Ext JS documentation of 'filter'
   */
  public native function filter(item:Object):Boolean;

  /**
   * Returns the value of <code>disabled</code>.
   * @see #disabled
   */
  public native function getDisabled():Boolean;

  /**
   * Returns the value of <code>id</code>.
   * @see #id
   */
  public native function getId():String;

  /**
   * Returns the value of <code>serializer</code>.
   * @see #serializer
   */
  public native function getSerializer():Function;

  /**
   * Returns this filter's serialized state. This is used when transmitting this filter
   * to a server.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.BasicFilter.html#method-serialize Original Ext JS documentation of 'serialize'
   */
  public native function serialize():Object;

  /**
   * Sets the value of <code>disabled</code>.
   * @param disabled The new value.
   * @see #disabled
   */
  public native function setDisabled(disabled:Boolean):void;

  /**
   * Sets the value of <code>id</code>.
   * @param id The new value.
   * @see #id
   */
  public native function setId(id:String):void;

  /**
   * Sets the value of <code>serializer</code>.
   * @param serializer The new value.
   * @see #serializer
   */
  public native function setSerializer(serializer:Function):void;
}
}