package ext.util {
import ext.Component;
import ext.dom.Element;
import ext.mixin.Observable;

[Native("Ext.util.ClickRepeater", require)]
/**
 * @see ext.util.events.ClickRepeater_eEvent.CLICK
 * @eventType ext.util.events.ClickRepeater_eEvent.CLICK
 */
[Event(name='onClick', type='ext.util.events.ClickRepeater_eEvent')]
/**
 * @see ext.util.events.ClickRepeater_eEvent.MOUSE_DOWN
 * @eventType ext.util.events.ClickRepeater_eEvent.MOUSE_DOWN
 */
[Event(name='onMouseDown', type='ext.util.events.ClickRepeater_eEvent')]
/**
 * @see ext.util.events.ClickRepeater_eEvent.MOUSE_UP
 * @eventType ext.util.events.ClickRepeater_eEvent.MOUSE_UP
 */
[Event(name='onMouseUp', type='ext.util.events.ClickRepeater_eEvent')]
/**
 * A wrapper class which can be applied to any element. Fires a "click" event while the
 * mouse is pressed. The interval between firings may be specified in the config but
 * defaults to 20 milliseconds.
 * <p>Optionally, a CSS class may be applied to the element during the time it is pressed.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html Original Ext JS documentation of 'Ext.util.ClickRepeater'
 */
public class ClickRepeater extends ext.mixin.Observable {
  /**
   * Creates new ClickRepeater.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function ClickRepeater(config:ClickRepeater = null) {
    super();
  }

  [ExtConfig]
  /**
   * True if autorepeating should start slowly and accelerate.
   * "interval" and "delay" are ignored.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#cfg-accelerate Original Ext JS documentation of 'accelerate'
   */
  public native function get accelerate():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set accelerate(value:Boolean):void;

  [ExtConfig]
  /**
   * The initial delay before the repeating event begins firing.
   * Similar to an autorepeat key delay.
   * @default 250
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#cfg-delay Original Ext JS documentation of 'delay'
   */
  public native function get delay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set delay(value:Number):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The element to listen for clicks/taps on.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#cfg-el Original Ext JS documentation of 'el'
   * @see #getEl()
   * @see #setEl()
   */
  public native function get el():Element;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set el(value:Element):void;

  [ExtConfig]
  /**
   * A function called when the menu item is clicked (can be used instead of →<code>event:onClick</code> event).
   * @default null
   * <ul>
   * <li><code>clickRepeater:ext.util.ClickRepeater</code> (optional) —
   * This ClickRepeater.
   * </li>
   * <li><code>e:ext.event.Event</code> (optional) —
   * The underlying →<code>ext.event.Event</code>.
   * </li>
   * </ul>
   * @see #event:onClick
   * @see ext.event.Event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#cfg-handler Original Ext JS documentation of 'handler'
   */
  public native function get handler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set handler(value:*):void;

  [ExtConfig]
  /**
   * The interval between firings of the "click" event (in milliseconds).
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#cfg-interval Original Ext JS documentation of 'interval'
   */
  public native function get interval():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set interval(value:Number):void;

  [ExtConfig]
  /**
   * A CSS class name to be applied to the element while pressed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#cfg-pressedCls Original Ext JS documentation of 'pressedCls'
   */
  public native function get pressedCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pressedCls(value:String):void;

  [ExtConfig]
  /**
   * True to prevent the default click event
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#cfg-preventDefault Original Ext JS documentation of 'preventDefault'
   */
  public native function get preventDefault():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preventDefault(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The scope (<code>this</code> refeence) in which the configured →<code>handler</code> will be executed,
   * unless the scope is a ViewController method nmame.
   * @see #handler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#cfg-scope Original Ext JS documentation of 'scope'
   * @see #getScope()
   * @see #setScope()
   */
  public native function get scope():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * True to stop the default click event
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#cfg-stopDefault Original Ext JS documentation of 'stopDefault'
   */
  public native function get stopDefault():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stopDefault(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The Component who's encapsulating element to listen for clicks/taps on.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#cfg-target Original Ext JS documentation of 'target'
   * @see #getTarget()
   * @see #setTarget()
   */
  public native function get target():Component;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set target(value:Component):void;

  /**
   * Returns the value of <code>el</code>.
   * @see #el
   */
  public native function getEl():Element;

  /**
   * Returns the value of <code>scope</code>.
   * @see #scope
   */
  public native function getScope():Object;

  /**
   * Returns the value of <code>target</code>.
   * @see #target
   */
  public native function getTarget():Component;

  /**
   * Sets the value of <code>el</code>.
   * @param el The new value.
   * @see #el
   */
  public native function setEl(el:Element):void;

  /**
   * Sets the value of <code>scope</code>.
   * @param scope The new value.
   * @see #scope
   */
  public native function setScope(scope:Object):void;

  /**
   * Sets the value of <code>target</code>.
   * @param target The new value.
   * @see #target
   */
  public native function setTarget(target:Component):void;
}
}