package ext.util {
import ext.mixin.Observable;

[Native("Ext.util.Collection", require)]
/**
 * @see ext.util.events.Collection_detailsEvent.ADD
 * @eventType ext.util.events.Collection_detailsEvent.ADD
 */
[Event(name='onAdd', type='ext.util.events.Collection_detailsEvent')]
/**
 * @see ext.util.events.Collection_detailsEvent.BEFORE_ITEM_CHANGE
 * @eventType ext.util.events.Collection_detailsEvent.BEFORE_ITEM_CHANGE
 */
[Event(name='onBeforeItemChange', type='ext.util.events.Collection_detailsEvent')]
/**
 * @see ext.util.events.CollectionEvent.BEGIN_UPDATE
 * @eventType ext.util.events.CollectionEvent.BEGIN_UPDATE
 */
[Event(name='onBeginUpdate', type='ext.util.events.CollectionEvent')]
/**
 * @see ext.util.events.CollectionEvent.END_UPDATE
 * @eventType ext.util.events.CollectionEvent.END_UPDATE
 */
[Event(name='onEndUpdate', type='ext.util.events.CollectionEvent')]
/**
 * @see ext.util.events.Collection_detailsEvent.ITEM_CHANGE
 * @eventType ext.util.events.Collection_detailsEvent.ITEM_CHANGE
 */
[Event(name='onItemChange', type='ext.util.events.Collection_detailsEvent')]
/**
 * @see ext.util.events.CollectionEvent.REFRESH
 * @eventType ext.util.events.CollectionEvent.REFRESH
 */
[Event(name='onRefresh', type='ext.util.events.CollectionEvent')]
/**
 * @see ext.util.events.Collection_detailsEvent.REMOVE
 * @eventType ext.util.events.Collection_detailsEvent.REMOVE
 */
[Event(name='onRemove', type='ext.util.events.Collection_detailsEvent')]
/**
 * @see ext.util.events.CollectionEvent.SORT
 * @eventType ext.util.events.CollectionEvent.SORT
 */
[Event(name='onSort', type='ext.util.events.CollectionEvent')]
/**
 * @see ext.util.events.Collection_detailsEvent.UPDATE_KEY
 * @eventType ext.util.events.Collection_detailsEvent.UPDATE_KEY
 */
[Event(name='onUpdateKey', type='ext.util.events.Collection_detailsEvent')]
/**
 * This class manages uniquely keyed objects such as <i>records</i> (→<code>ext.data.Model</code>) or
 * <i>components</i> (→<code>ext.Component</code>).
 * <p><b><i>Keys</i></b></p>
 * <p>Unlike <code>→ext.util.MixedCollection</code> this class can only manage objects whose key can be
 * extracted from the instance. That is, this class does not support "external" keys. This
 * makes this class more efficient because it does not need to track keys in parallel with
 * items. It also means key-to-item lookup will be optimal and never need to perform a
 * linear search.</p>
 * <p><i>Extra Keys</i></p>
 * <p>In some cases items may need to be looked up by multiple property values. To enable this
 * there is the <code>→extraKeys</code> config.</p>
 * <p>For example, to quickly look up items by their "name" property:</p>
 * <pre>
 *  var collection = new Ext.util.Collection({
 *      extraKeys: {
 *          byName: 'name' // based on "name" property of each item
 *      }
 *  });
 * </pre>
 * <p><b><i>Ranges</i></b></p>
 * <p>When methods accept index arguments to indicate a range of items, these are either an
 * index and a number of items or a "begin" and "end" index.</p>
 * <p>In the case of "begin" and "end", the "end" is the first item outside the range. This
 * definition makes it simple to expression empty ranges because "length = end - begin".</p>
 * <p><i>Negative Indices</i></p>
 * <p>When an item index is provided, negative values are treated as offsets from the end of
 * the collection. In other words the follow are equivalent:</p>
 * <pre>
 *  +---+---+---+---+---+---+
 *  |   |   |   |   |   |   |
 *  +---+---+---+---+---+---+
 *    0   1   2   3   4   5
 *   -6  -5  -4  -3  -2  -1
 * </pre>
 * <p><b><i>Legacy Classes</i></b></p>
 * <p>The legacy classes <code>Ext.util.MixedCollection' and</code>→<code>ext.util.AbstractMixedCollection</code>`
 * may be needed if external keys are required, but for all other situations this class
 * should be used instead.</p>
 * @see ext.data.Model
 * @see ext.Component
 * @see ext.util.MixedCollection
 * @see #extraKeys
 * @see ext.util.AbstractMixedCollection
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html Original Ext JS documentation of 'Ext.util.Collection'
 */
public class Collection extends ext.mixin.Observable {
  /**
   * @param config @inheritDoc
   */
  public function Collection(config:Collection = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A function that can convert newly added items to a proper type before being
   * added to this collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#cfg-decoder Original Ext JS documentation of 'decoder'
   * @see #getDecoder()
   * @see #setDecoder()
   */
  public native function get decoder():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set decoder(value:Function):void;

  [ExtConfig]
  [Bindable]
  /**
   * The default sort direction to use if one is not specified.
   * @default 'ASC'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#cfg-defaultSortDirection Original Ext JS documentation of 'defaultSortDirection'
   * @see #getDefaultSortDirection()
   * @see #setDefaultSortDirection()
   */
  public native function get defaultSortDirection():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultSortDirection(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more <code>→ext.util.CollectionKey</code> configuration objects or key properties.
   * Each property of the given object is the name of the <code>CollectionKey</code> instance
   * that is stored on this collection. The value of each property configures the
   * <code>CollectionKey</code> instance.
   * <pre>
   *  var collection = new Ext.util.Collection({
   *      extraKeys: {
   *          byName: 'name' // based on "name" property of each item
   *      }
   *  });
   * </pre>
   * <p>Or equivalently:</p>
   * <pre>
   *  var collection = new Ext.util.Collection({
   *      extraKeys: {
   *          byName: {
   *              property: 'name'
   *          }
   *      }
   *  });
   * </pre>
   * <p>To provide a custom key extraction function instead:</p>
   * <pre>
   *  var collection = new Ext.util.Collection({
   *      extraKeys: {
   *          byName: {
   *              keyFn: function (item) {
   *                  return item.name;
   *              }
   *          }
   *      }
   *  });
   * </pre>
   * <p>Or to call a key getter method from each item:</p>
   * <pre>
   *  var collection = new Ext.util.Collection({
   *      extraKeys: {
   *          byName: {
   *              keyFn: 'getName'
   *          }
   *      }
   *  });
   * </pre>
   * <p>To use the above:</p>
   * <pre>
   *  var item = collection.byName.get('somename');
   * </pre>
   * <p><b>NOTE</b> Either a <code>property</code> or <code>→keyFn</code> must be be specified to define each
   * key.</p>
   * @since 5.0.0
   * @see ext.util.CollectionKey
   * @see #keyFn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#cfg-extraKeys Original Ext JS documentation of 'extraKeys'
   * @see #getExtraKeys()
   * @see #setExtraKeys()
   */
  public native function get extraKeys():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set extraKeys(value:Object):void;

  /**
   * A read-only flag indicating if this object is filtered.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#property-filtered Original Ext JS documentation of 'filtered'
   */
  public native function get filtered():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * The collection of <i>Filters</i> (→<code>ext.util.Filter</code>) for this collection. At the
   * time a collection is created <code>→filters</code> can be specified as a unit. After that
   * time the normal <code>setFilters</code> method can also be given a set of replacement
   * filters for the collection.
   * <p>Individual filters can be specified as an <code>→ext.util.Filter</code> instance, a config
   * object for <code>→ext.util.Filter</code> or simply a function that will be wrapped in a
   * instance with its →<code>ext.util.Filter.filterFn</code> set.</p>
   * <p>For fine grain control of the filters collection, call <code>→getFilters()</code> to return
   * the <code>→ext.util.Collection</code> instance that holds this collection's filters.</p>
   * <pre>
   *  var collection = new Ext.util.Collection();
   *  var filters = collection.getFilters(); // an Ext.util.FilterCollection
   *
   *  function legalAge (item) {
   *      return item.age &gt;= 21;
   *  }
   *
   *  filters.add(legalAge);
   *
   *  //...
   *
   *  filters.remove(legalAge);
   * </pre>
   * <p>Any changes to the <code>→filters</code> collection will cause this collection to adjust
   * its items accordingly (if <code>autoFilter</code> is <code>true</code>).</p>
   * @default null
   * @since 5.0.0
   * @see ext.util.Filter
   * @see #filters
   * @see ext.util.Filter#filterFn
   * @see #getFilters()
   * @see ext.util.Collection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#cfg-filters Original Ext JS documentation of 'filters'
   * @see #setFilters()
   */
  public native function get filters():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set filters(value:*):void;

  /**
   * Mutation counter which is incremented when the collection changes.
   * @default 0
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#property-generation Original Ext JS documentation of 'generation'
   */
  public native function get generation():Number;

  /**
   * A read-only flag indicating if this object is grouped.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#property-grouped Original Ext JS documentation of 'grouped'
   */
  public native function get grouped():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * A configuration object for this collection's <i>grouper</i> (→<code>ext.util.Grouper</code>).
   * <p>For example, to group items by the first letter of the last name:</p>
   * <pre>
   *  var collection = new Ext.util.Collection({
   *      grouper: {
   *          groupFn: function (item) {
   *              return item.lastName.substring(0, 1);
   *          }
   *      }
   *  });
   * </pre>
   * @see ext.util.Grouper
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#cfg-grouper Original Ext JS documentation of 'grouper'
   * @see #getGrouper()
   * @see #setGrouper()
   */
  public native function get grouper():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set grouper(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The collection of to hold each group container. This collection is created and
   * removed dynamically based on <code>→grouper</code>. Application code should only need to
   * call <code>getGroups</code> to retrieve the collection and not <code>setGroups</code>.
   * @see #grouper
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#cfg-groups Original Ext JS documentation of 'groups'
   * @see #getGroups()
   * @see #setGroups()
   */
  public native function get groups():Collection;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set groups(value:Collection):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Collection, or subclass
   * thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#property-isCollection Original Ext JS documentation of 'isCollection'
   */
  public native function get isCollection():Boolean;

  [ExtConfig]
  /**
   * A function to retrieve the key of an item in the collection. If provided,
   * this replaces the default <code>→getKey()</code> method. The default <code>→getKey()</code> method handles
   * items that have either an "id" or "_id" property or failing that a <code>→getId()</code>
   * method to call.
   * @since 5.0.0
   * @see #getKey()
   * @see #getId()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#cfg-keyFn Original Ext JS documentation of 'keyFn'
   */
  public native function get keyFn():Function;

  [ExtConfig]
  /**
   * @private
   */
  public native function set keyFn(value:Function):void;

  /**
   * The count of items in the collection.
   * @default 0
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#property-length Original Ext JS documentation of 'length'
   */
  public native function get length():Number;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum number of sorters which may be applied to this Sortable when using
   * the "multi" insertion position when adding sorters.
   * <p>New sorters added using the "multi" insertion position are inserted at the top
   * of the sorters list becoming the new primary sort key.</p>
   * <p>If the sorters collection has grown to longer then <b><code>→multiSortLimit</code></b>, then
   * the it is trimmed.</p>
   * @default 3
   * @see #multiSortLimit
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#cfg-multiSortLimit Original Ext JS documentation of 'multiSortLimit'
   * @see #getMultiSortLimit()
   * @see #setMultiSortLimit()
   */
  public native function get multiSortLimit():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set multiSortLimit(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The root property to use for aggregation, filtering and sorting. By default
   * this is <code>null</code> but when containing things like <i>records</i> (→<code>ext.data.Model</code>)
   * this config would likely be set to "data" so that property names are applied
   * to the fields of each record.
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#cfg-rootProperty Original Ext JS documentation of 'rootProperty'
   * @see #getRootProperty()
   * @see #setRootProperty()
   */
  public native function get rootProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rootProperty(value:String):void;

  /**
   * A read-only flag indicating if this object is sorted. This flag may not be correct
   * during an update of the sorter collection but will be correct before <code>→onSortChange()</code>
   * is called. This flag is <code>true</code> if <code>→grouped</code> is <code>true</code> because the collection is at
   * least sorted by the <code>→grouper</code>.
   * @default false
   * @see #onSortChange()
   * @see #grouped
   * @see #grouper
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#property-sorted Original Ext JS documentation of 'sorted'
   */
  public native function get sorted():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * Array of <i>sorters</i> (→<code>ext.util.Sorter</code>) for this collection. At the time a
   * collection is created the <code>→sorters</code> can be specified as a unit. After that time
   * the normal <code>setSorters</code> method can be also be given a set of replacement
   * sorters.
   * <p>Individual sorters can be specified as an <code>→ext.util.Sorter</code> instance, a config
   * object for <code>→ext.util.Sorter</code> or simply the name of a property by which to sort.</p>
   * <p>An alternative way to extend the sorters is to call the <code>sort</code> method and pass
   * a property or sorter config to add to the sorters.</p>
   * <p>For fine grain control of the sorters collection, call <code>→getSorters()</code> to return
   * the <code>→ext.util.Collection</code> instance that holds this collection's sorters.</p>
   * <pre>
   *  var collection = new Ext.util.Collection();
   *  var sorters = collection.getSorters(); // an Ext.util.SorterCollection
   *
   *  sorters.add('name');
   *
   *  //...
   *
   *  sorters.remove('name');
   * </pre>
   * <p>Any changes to the <code>→sorters</code> collection will cause this collection to adjust
   * its items accordingly (if <code>→autoSort</code> is <code>true</code>).</p>
   * @default null
   * @since 5.0.0
   * @see ext.util.Sorter
   * @see #sorters
   * @see #getSorters()
   * @see ext.util.Collection
   * @see #autoSort
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#cfg-sorters Original Ext JS documentation of 'sorters'
   * @see #setSorters()
   */
  public native function get sorters():Array;

  [ExtConfig]
  [Bindable]
  [ArrayElementType("ext.util.Sorter")]
  /**
   * @private
   */
  public native function set sorters(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The base <code>Collection</code>. This collection contains the items to which filters
   * are applied to populate this collection. In this configuration, only the
   * root <code>→source</code> collection can have items truly added or removed.
   * @since 5.0.0
   * @see #source
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#cfg-source Original Ext JS documentation of 'source'
   * @see #getSource()
   * @see #setSource()
   */
  public native function get source():Collection;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set source(value:Collection):void;

  /**
   * A counter that is increased by <code>→beginUpdate()</code> and decreased by <code>→endUpdate()</code>. When
   * this transitions from 0 to 1 the <code>→event:onBeginUpdate</code> event is
   * fired. When it transitions back from 1 to 0 the <code>→event:onEndUpdate</code>
   * event is fired.
   * @default 0
   * @since 5.0.0
   * @see #beginUpdate()
   * @see #endUpdate()
   * @see #event:onBeginUpdate
   * @see #event:onEndUpdate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#property-updating Original Ext JS documentation of 'updating'
   */
  public native function get updating():Number;

  /**
   * Adds an item to the collection. If the item already exists or an item with the
   * same key exists, the old item will be removed and the new item will be added to
   * the end.
   * <p>This method also accepts an array of items or simply multiple items as individual
   * arguments. The following 3 code sequences have the same end result:</p>
   * <pre>
   *  // Call add() once per item (not optimal - best avoided):
   *  collection.add(itemA);
   *  collection.add(itemB);
   *  collection.add(itemC);
   *  collection.add(itemD);
   *
   *  // Call add() with each item as an argument:
   *  collection.add(itemA, itemB, itemC, itemD);
   *
   *  // Call add() with the items as an array:
   *  collection.add([ itemA, itemB, itemC, itemD ]);
   * </pre>
   * <p>The first form should be avoided where possible because the collection and all
   * parties "watching" it will be updated 4 times.</p>
   * @since 5.0.0
   * @param item The item or items to add.
   * @return The item or items added.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-add Original Ext JS documentation of 'add'
   */
  public native function add(item:*):*;

  /**
   * Returns the result of the specified aggregation operation against all items in this
   * collection.
   * <p>This method is not typically called directly because there are convenience methods
   * for each of the supported <code>operation</code> values. These are:</p>
   * <ul>
   * <li><b>average</b> - Returns the average value.</li>
   * <li><b>bounds</b> - Returns an array of <code>[min, max]</code>.</li>
   * <li><b>max</b> - Returns the maximum value or <code>undefined</code> if empty.</li>
   * <li><b>min</b> - Returns the minimum value or <code>undefined</code> if empty.</li>
   * <li><b>sum</b> - Returns the sum of all values.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  result = collection.aggregate('age', 'sum');
   *
   *  result = collection.aggregate('age', 'sum', 2, 10); // the 8 items at index 2
   * </pre>
   * <p>To provide a custom operation function:</p>
   * <pre>
   *  function averageAgeOfMinors (items, values) {
   *      var sum = 0,
   *          count = 0;
   *
   *      for (var i = 0; i &lt; values.length; ++i) {
   *          if (values[i] &lt; 18) {
   *              sum += values[i];
   *              ++count;
   *          }
   *      }
   *
   *      return count ? sum / count : 0;
   *  }
   *
   *  result = collection.aggregate('age', averageAgeOfMinors);
   * </pre>
   * @param property The name of the property to aggregate from each item.
   * @param operation The operation to perform.
   * <ul>
   * <li><code>items:Array</code> (optional) —
   * The items on which the <code>operation</code> function is to
   * operate.
   * </li>
   * <li><code>values:Array</code> (optional) —
   * The values on which the <code>operation</code> function is to
   * operate.
   * </li>
   * </ul>
   * @param begin The index of the first item in <code>→items</code> to include in the
   * aggregation.
   * @param end The index at which to stop aggregating <code>→items</code>. The item at
   * this index will <i>not</i> be included in the aggregation.
   * @param scope The <code>this</code> pointer to use if <code>operation</code> is a function.
   * Defaults to this collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-aggregate Original Ext JS documentation of 'aggregate'
   * @see #items
   */
  public native function aggregate(property:String, operation:*, begin:Number = NaN, end:Number = NaN, scope:Object = null):Object;

  /**
   * See →<code>aggregate()</code>. The functionality is the same, however the aggregates are
   * provided per group. Assumes this collection has an active →<code>grouper</code>.
   * @param property The name of the property to aggregate from each item.
   * @param operation The operation to perform.
   * <ul>
   * <li><code>items:Array</code> (optional) —
   * The items on which the <code>operation</code> function is to
   * operate.
   * </li>
   * <li><code>values:Array</code> (optional) —
   * The values on which the <code>operation</code> function is to
   * operate.
   * </li>
   * </ul>
   * @param scope The <code>this</code> pointer to use if <code>operation</code> is a function.
   * Defaults to this collection.
   * @see #aggregate()
   * @see #grouper
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-aggregateByGroup Original Ext JS documentation of 'aggregateByGroup'
   */
  public native function aggregateByGroup(property:String, operation:*, scope:Object = null):Object;

  /**
   * Averages property values from some or all of the items in this collection.
   * @since 5.0.0
   * @param property The name of the property to average from each item.
   * @param begin The index of the first item to include in the average.
   * @param end The index at which to stop averaging <code>→items</code>. The item at
   * this index will <i>not</i> be included in the average.
   * @return The result of averaging the specified property from the indicated
   * items.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-average Original Ext JS documentation of 'average'
   * @see #items
   */
  public native function average(property:String, begin:Number = NaN, end:Number = NaN):Object;

  /**
   * See →<code>average()</code>. The result is partitioned by group.
   * @since 5.0.0
   * @param property The name of the property to average from each item.
   * @return The result of →<code>average()</code>, partitioned by group. See
   * →<code>aggregateByGroup()</code>.
   * @see #average()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-averageByGroup Original Ext JS documentation of 'averageByGroup'
   * @see #aggregateByGroup()
   */
  public native function averageByGroup(property:String):Object;

  /**
   * This method is called to indicate the start of multiple changes to the collection.
   * Application code should seldom need to call this method as it is called internally
   * when needed. If multiple collection changes are needed, consider wrapping them in
   * an <code>→update()</code> call rather than calling <code>→beginUpdate()</code> directly.
   * <p>Internally this method increments a counter that is decremented by <code>→endUpdate()</code>. It
   * is important, therefore, that if you call <code>→beginUpdate()</code> directly you match that
   * call with a call to <code>→endUpdate()</code> or you will prevent the collection from updating
   * properly.</p>
   * <p>For example:</p>
   * <pre>
   *  var collection = new Ext.util.Collection();
   *
   *  collection.beginUpdate();
   *
   *  collection.add(item);
   *  // ...
   *
   *  collection.insert(index, otherItem);
   *  //...
   *
   *  collection.endUpdate();
   * </pre>
   * @since 5.0.0
   * @see #update()
   * @see #beginUpdate()
   * @see #endUpdate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-beginUpdate Original Ext JS documentation of 'beginUpdate'
   */
  public native function beginUpdate():void;

  /**
   * Determines the minimum and maximum values for the specified property over some or
   * all of the items in this collection.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @param begin The index of the first item to include in the bounds.
   * @param end The index at which to stop in <code>→items</code>. The item at this index
   * will <i>not</i> be included in the bounds.
   * @return An array <code>[min, max]</code> with the minimum and maximum of the specified
   * property.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-bounds Original Ext JS documentation of 'bounds'
   * @see #items
   */
  public native function bounds(property:String, begin:Number = NaN, end:Number = NaN):Array;

  /**
   * See →<code>bounds()</code>. The result is partitioned by group.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @return The result of →<code>bounds()</code>, partitioned by group. See
   * →<code>aggregateByGroup()</code>.
   * @see #bounds()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-boundsByGroup Original Ext JS documentation of 'boundsByGroup'
   * @see #aggregateByGroup()
   */
  public native function boundsByGroup(property:String):Object;

  /**
   * Removes all items from the collection. This is similar to <code>→removeAll()</code> except that
   * <code>→removeAll()</code> fire events to inform listeners. This means that this method should be
   * called only when you are sure there are no listeners.
   * @since 5.0.0
   * @see #removeAll()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear():void;

  /**
   * Creates a shallow copy of this collection
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone():Collection;

  /**
   * Collects unique values of a particular property in this Collection.
   * @since 5.0.0
   * @param property The property to collect on
   * @param root 'root' property to extract the first argument from.
   * This is used mainly when summing fields in records, where the fields are all stored
   * inside the 'data' object
   * @param allowNull Pass <code>true</code> to include <code>null</code>, <code>undefined</code> or empty
   * string values.
   * @return The unique values
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-collect Original Ext JS documentation of 'collect'
   */
  public native function collect(property:String, root:String = null, allowNull:Boolean = false):Array;

  /**
   * Returns true if the collection contains the passed Object as an item.
   * @since 5.0.0
   * @param item The item to look for in the collection.
   * @return <code>true</code> if the collection contains the item.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(item:Object):Boolean;

  /**
   * Returns true if the collection contains all the passed items. If the first argument
   * is an array, then the items in that array are checked. Otherwise, all arguments
   * passed to this method are checked.
   * @since 6.5.2
   * @param items The item(s) that must be in the collection.
   * @return <code>true</code> if the collection contains all the items.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-containsAll Original Ext JS documentation of 'containsAll'
   */
  public native function containsAll(...items):Boolean;

  /**
   * Returns true if the collection contains the passed Object as a key.
   * @since 5.0.0
   * @param key The key to look for in the collection.
   * @return True if the collection contains the Object as a key.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-containsKey Original Ext JS documentation of 'containsKey'
   */
  public native function containsKey(key:String):Boolean;

  /**
   * Determines the number of items in the collection.
   * @since 5.0.0
   * @return The number of items.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-count Original Ext JS documentation of 'count'
   */
  public native function count():Number;

  /**
   * See →<code>count()</code>. The result is partitioned by group.
   * @since 5.0.0
   * @return The result of →<code>count()</code>, partitioned by group. See
   * →<code>aggregateByGroup()</code>.
   * @see #count()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-countByGroup Original Ext JS documentation of 'countByGroup'
   * @see #aggregateByGroup()
   */
  public native function countByGroup():Object;

  /**
   * Creates a new collection that is a filtered subset of this collection. The filter
   * passed can be a function, a simple property name and value, an <code>→ext.util.Filter</code>
   * instance, an array of <code>→ext.util.Filter</code> instances.
   * <p>If the passed filter is a function the second argument is its "scope" (or "this"
   * pointer). The function should return <code>true</code> given each item in the collection if
   * that item should be included in the filtered collection.</p>
   * <pre>
   *  var people = new Ext.util.Collection();
   *
   *  people.add([
   *      { id: 1, age: 25, name: 'Ed' },
   *      { id: 2, age: 24, name: 'Tommy' },
   *      { id: 3, age: 24, name: 'Arne' },
   *      { id: 4, age: 26, name: 'Aaron' }
   *  ]);
   *
   *  // Create a collection of people who are older than 24:
   *  var oldPeople = people.createFiltered(function (item) {
   *      return item.age &gt; 24;
   *  });
   * </pre>
   * <p>If the passed filter is a <code>→ext.util.Filter</code> instance or array of <code>→ext.util.Filter</code>
   * instances the filter(s) are used to produce the filtered collection and there are
   * no further arguments.</p>
   * <p>If the passed filter is a string it is understood as the name of the property by
   * which to filter. The second argument is the "value" used to compare each item's
   * property value. This comparison can be further tuned with the <code>anyMatch</code> and
   * <code>caseSensitive</code> (optional) arguments.</p>
   * <pre>
   * // Create a new Collection containing only the items where age == 24
   * var middleAged = people.createFiltered('age', 24);
   * </pre>
   * <p>Alternatively you can apply <code>→filters</code> to this Collection by calling <code>setFilters</code>
   * or modifying the filter collection returned by <code>→getFilters()</code>.</p>
   * @since 5.0.0
   * @param property A property on your objects, an
   * array of →<code>ext.util.Filter</code> objects or a filter function.
   * @param value If <code>property</code> is a function, this argument is the "scope"
   * (or "this" pointer) for the function. Otherwise this is either a <code>→RegExp</code> to test
   * property values or the value with which to compare.
   * @param anyMatch True to match any part of the string, not just
   * the beginning.
   * @default false
   * @param caseSensitive True for case sensitive comparison.
   * @default false
   * @param exactMatch <code>true</code> to force exact match (^ and $ characters
   * added to the regex).
   * @default false
   * @return The new, filtered collection.
   * @see ext.util.Filter
   * @see #filters
   * @see #getFilters()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-createFiltered Original Ext JS documentation of 'createFiltered'
   * @see RegExp
   */
  public native function createFiltered(property:*, value:Object, anyMatch:Boolean = false, caseSensitive:Boolean = false, exactMatch:Boolean = false):Collection;

  /**
   * This method is an alias for <code>→decodeItems()</code> but is called when items are being
   * removed. If a <code>→decoder</code> is provided it may be necessary to also override this
   * method to achieve symmetry between adding and removing items. This is the case
   * for <code>Ext.util.FilterCollection' and</code>Ext.util.SorterCollection' for example.
   * @since 5.0.0
   * @see #decodeItems()
   * @see #decoder
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-decodeRemoveItems Original Ext JS documentation of 'decodeRemoveItems'
   */
  protected native function decodeRemoveItems():void;

  /**
   * Destroys this collection. This is only necessary if this collection uses a <code>→source</code>
   * collection as that relationship will keep a reference from the <code>→source</code> to this
   * collection and potentially leak memory.
   * @since 5.0.0
   * @see #source
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Executes the specified function once for every item in the collection. If the value
   * returned by <code>fn</code> is <code>false</code> the iteration stops. In all cases, the last value that
   * <code>fn</code> returns is returned by this method.
   * @since 5.0.0
   * @param fn The function to execute for each item.
   * <ul>
   * <li><code>item:Object</code> (optional) —
   * The collection item.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The index of item.
   * </li>
   * <li><code>len:Number</code> (optional) —
   * Total length of collection.
   * </li>
   * </ul>
   * @param scope (Default this) The scope (<code>this</code> reference) in which the function
   * is executed. Defaults to this collection.
   * @default this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(fn:Function, scope:Object = null):void;

  /**
   * Executes the specified function once for every key in the collection, passing each
   * key, and its associated item as the first two parameters. If the value returned by
   * <code>fn</code> is <code>false</code> the iteration stops. In all cases, the last value that <code>fn</code> returns
   * is returned by this method.
   * @since 5.0.0
   * @param fn The function to execute for each item.
   * <ul>
   * <li><code>key:String</code> (optional) —
   * The key of collection item.
   * </li>
   * <li><code>item:Object</code> (optional) —
   * The collection item.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The index of item.
   * </li>
   * <li><code>len:Number</code> (optional) —
   * Total length of collection.
   * </li>
   * </ul>
   * @param scope (Default this) The scope (<code>this</code> reference) in which the function
   * is executed. Defaults to this collection.
   * @default this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-eachKey Original Ext JS documentation of 'eachKey'
   */
  public native function eachKey(fn:Function, scope:Object = null):void;

  /**
   * This method is called after modifications are complete on a collection. For details
   * see <code>→beginUpdate()</code>.
   * @since 5.0.0
   * @see #beginUpdate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-endUpdate Original Ext JS documentation of 'endUpdate'
   */
  public native function endUpdate():void;

  /**
   * Finds the items with the minimum and maximum for the specified property over some
   * or all of the items in this collection.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @param begin The index of the first item to include.
   * @param end The index at which to stop in <code>→items</code>. The item at this index
   * will <i>not</i> be included.
   * @return An array <code>[minItem, maxItem]</code> with the items that have the minimum
   * and maximum of the specified property.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-extremes Original Ext JS documentation of 'extremes'
   * @see #items
   */
  public native function extremes(property:String, begin:Number = NaN, end:Number = NaN):Array;

  /**
   * See →<code>extremes()</code>. The result is partitioned by group.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @return The result of →<code>extremes()</code>, partitioned by group. See
   * →<code>aggregateByGroup()</code>.
   * @see #extremes()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-extremesByGroup Original Ext JS documentation of 'extremesByGroup'
   * @see #aggregateByGroup()
   */
  public native function extremesByGroup(property:String):Object;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Filter by a function. Returns a <i>new</i> collection that has been filtered.
   * The passed function will be called with each object in the collection.
   * If the function returns true, the value is included otherwise it is filtered.
   * @param fn The function to be called.
   * <ul>
   * <li><code>item</code> (optional) —
   * The collection item.
   * </li>
   * <li><code>key:String</code> (optional) —
   * The key of collection item.
   * </li>
   * </ul>
   * @param scope The scope (<code>this</code> reference) in
   * which the function is executed. Defaults to this Collection.
   * @return The new filtered collection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-filterBy Original Ext JS documentation of 'filterBy'
   */
  public native function filterBy(fn:Function, scope:Object = null):Collection;

  /**
   * Finds the first matching object in this collection by a specific property/value.
   * @since 5.0.0
   * @param property The name of a property on your objects.
   * @param value A string that the property values
   * should start with or a RegExp to test against the property.
   * @param start The index to start searching at.
   * @default 0
   * @param startsWith Pass <code>false</code> to allow a match start anywhere in
   * the string. By default the <code>value</code> will match only at the start of the string.
   * @default true
   * @param endsWith Pass <code>false</code> to allow the match to end before the
   * end of the string. By default the <code>value</code> will match only at the end of the string.
   * @default true
   * @param ignoreCase Pass <code>false</code> to make the <code>→RegExp</code> case
   * sensitive (removes the 'i' flag).
   * @default true
   * @return The first item in the collection which matches the criteria or
   * <code>null</code> if none was found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-find Original Ext JS documentation of 'find'
   * @see RegExp
   */
  public native function find(property:String, value:*, start:Number = 0, startsWith:Boolean = true, endsWith:Boolean = true, ignoreCase:Boolean = true):Object;

  /**
   * Returns the first item in the collection which elicits a true return value from the
   * passed selection function.
   * @since 5.0.0
   * @param fn The selection function to execute for each item.
   * <ul>
   * <li><code>item:Object</code> (optional) —
   * The collection item.
   * </li>
   * <li><code>key:String</code> (optional) —
   * The key of collection item.
   * </li>
   * </ul>
   * @param scope (Default this) The scope (<code>this</code> reference) in which the function
   * is executed. Defaults to this collection.
   * @default this
   * @param start The index at which to start searching.
   * @default 0
   * @return The first item in the collection which returned true from the selection
   * function, or null if none was found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-findBy Original Ext JS documentation of 'findBy'
   */
  public native function findBy(fn:Function, scope:Object = null, start:Number = 0):Object;

  /**
   * Finds the index of the first matching object in this collection by a specific
   * property/value.
   * @since 5.0.0
   * @param property The name of a property on your objects.
   * @param value A string that the property values
   * should start with or a RegExp to test against the property.
   * @param start The index to start searching at.
   * @default 0
   * @param startsWith Pass <code>false</code> to allow a match start anywhere in
   * the string. By default the <code>value</code> will match only at the start of the string.
   * @default true
   * @param endsWith Pass <code>false</code> to allow the match to end before the
   * end of the string. By default the <code>value</code> will match only at the end of the string.
   * @default true
   * @param ignoreCase Pass <code>false</code> to make the <code>→RegExp</code> case
   * sensitive (removes the 'i' flag).
   * @default true
   * @return The matched index or -1 if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-findIndex Original Ext JS documentation of 'findIndex'
   * @see RegExp
   */
  public native function findIndex(property:String, value:*, start:Number = 0, startsWith:Boolean = true, endsWith:Boolean = true, ignoreCase:Boolean = true):Number;

  /**
   * Find the index of the first matching object in this collection by a function.
   * If the function returns <code>true</code> it is considered a match.
   * @since 5.0.0
   * @param fn The function to be called.
   * <ul>
   * <li><code>item:Object</code> (optional) —
   * The collection item.
   * </li>
   * <li><code>key:String</code> (optional) —
   * The key of collection item.
   * </li>
   * </ul>
   * @param scope (Default this) The scope (<code>this</code> reference) in which the function
   * is executed. Defaults to this collection.
   * @default this
   * @param start The index at which to start searching.
   * @default 0
   * @return The matched index or -1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-findIndexBy Original Ext JS documentation of 'findIndexBy'
   */
  public native function findIndexBy(fn:Function, scope:Object = null, start:Number = 0):Number;

  /**
   * Returns the first item in the collection.
   * @since 5.0.0
   * @param grouped <code>true</code> to extract the first item in each group. Only applies if
   * a →<code>grouper</code> is active in the collection.
   * @return The first item in the collection. If the grouped parameter is passed,
   * see →<code>aggregateByGroup()</code> for information on the return type.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-first Original Ext JS documentation of 'first'
   * @see #grouper
   * @see #aggregateByGroup()
   */
  public native function first(grouped:Boolean = false):Object;

  /**
   * Returns the item associated with the passed key.
   * @since 5.0.0
   * @param key The key of the item.
   * @return The item associated with the passed key.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-get Original Ext JS documentation of 'get'
   */
  public native function get(key:*):Object;

  /**
   * Returns the item at the specified index.
   * @since 5.0.0
   * @param index The index of the item.
   * @return The item at the specified index.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-getAt Original Ext JS documentation of 'getAt'
   */
  public native function getAt(index:Number):Object;

  /**
   * Returns the item associated with the passed key.
   * @since 5.0.0
   * @param key The key of the item.
   * @return The item associated with the passed key.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-getByKey Original Ext JS documentation of 'getByKey'
   */
  public native function getByKey(key:*):Object;

  /**
   * Returns the number of items in the collection.
   * @since 5.0.0
   * @return the number of items in the collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-getCount Original Ext JS documentation of 'getCount'
   */
  public native function getCount():Number;

  /**
   * Returns the value of <code>decoder</code>.
   * @see #decoder
   */
  public native function getDecoder():Function;

  /**
   * Returns the value of <code>defaultSortDirection</code>.
   * @see #defaultSortDirection
   */
  public native function getDefaultSortDirection():String;

  /**
   * Returns the value of <code>extraKeys</code>.
   * @see #extraKeys
   */
  public native function getExtraKeys():Object;

  /**
   * Returns the filter function.
   * @return sortFn The sort function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-getFilterFn Original Ext JS documentation of 'getFilterFn'
   */
  public native function getFilterFn():Function;

  /**
   * Returns the value of <code>filters</code>.
   * @see #filters
   */
  public native function getFilters(autoCreate:Boolean = true):Collection;

  /**
   * Returns the value of <code>grouper</code>.
   * @see #grouper
   */
  public native function getGrouper():Object;

  /**
   * Returns the value of <code>groups</code>.
   * @see #groups
   */
  public native function getGroups():Collection;

  /**
   * A function which will be called, passing an object belonging to this collection.
   * The function should return the key by which that object will be indexed. This key
   * must be unique to this item as only one item with this key will be retained.
   * <p>The default implementation looks basically like this (give or take special case
   * handling of 0):</p>
   * <pre>
   *  function getKey (item) {
   *      return item.id || item._id || item.getId();
   *  }
   * </pre>
   * <p>You can provide your own implementation by passing the <code>→keyFn</code> config.</p>
   * <p>For example, to hold items that have a unique "name" property:</p>
   * <pre>
   * var elementCollection = new Ext.util.Collection({
   *     keyFn: function (item) {
   *         return item.name;
   *     }
   * });
   * </pre>
   * <p>The collection can have <code>→extraKeys</code> if items need to be quickly looked up by other
   * (potentially non-unique) properties.</p>
   * @since 5.0.0
   * @param item The item.
   * @return The key for the passed item.
   * @see #keyFn
   * @see #extraKeys
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-getKey Original Ext JS documentation of 'getKey'
   */
  public native function getKey(item:Object):Object;

  /**
   * Returns the value of <code>multiSortLimit</code>.
   * @see #multiSortLimit
   */
  public native function getMultiSortLimit():Number;

  /**
   * Returns a range of items in this collection
   * @since 5.0.0
   * @param begin The index of the first item to get.
   * @default 0
   * @param end The ending index. The item at this index is <i>not</i> included.
   * @return An array of items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-getRange Original Ext JS documentation of 'getRange'
   */
  public native function getRange(begin:Number = 0, end:Number = NaN):Array;

  /**
   * Returns the value of <code>rootProperty</code>.
   * @see #rootProperty
   */
  public native function getRootProperty():String;

  /**
   * Returns an up to date sort function.
   * @return The sort function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-getSortFn Original Ext JS documentation of 'getSortFn'
   */
  public native function getSortFn():Function;

  /**
   * Returns the value of <code>sorters</code>.
   * @see #sorters
   */
  public native function getSorters(autoCreate:Boolean = true):Collection;

  /**
   * Returns all unfiltered items in the Collection when the Collection has been
   * filtered. Returns <code>null</code> when the Collection is not filtered.
   * @return items All unfiltered items (or <code>null</code> when the
   * Collection is not filtered)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-getSource Original Ext JS documentation of 'getSource'
   */
  public native function getSource():Collection;

  /**
   * Returns an array of values for the specified (sub) property.
   * <p>For example, to get an array of "name" properties from a collection of records (of
   * <code>→ext.data.Model</code> objects):</p>
   * <pre>
   *  var names = collection.getValues('name', 'data');
   * </pre>
   * @since 5.0.0
   * @param property The property to collect on
   * @param root 'root' property to extract the first argument from. This is
   * used mainly when operating on fields in records, where the fields are all stored
   * inside the 'data' object.
   * @param start The index of the first item to include.
   * @default 0
   * @param end The index at which to stop getting values. The value of this
   * item is <i>not</i> included.
   * @return The array of values.
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-getValues Original Ext JS documentation of 'getValues'
   */
  public native function getValues(property:String, root:String = null, start:Number = 0, end:Number = NaN):Array;

  /**
   * Returns index within the collection of the passed Object.
   * @since 5.0.0
   * @param item The item to find.
   * @return The index of the item or -1 if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-indexOf Original Ext JS documentation of 'indexOf'
   */
  public native function indexOf(item:Object):Number;

  /**
   * Returns index within the collection of the passed key.
   * @since 5.0.0
   * @param key The key to find.
   * @return The index of the item or -1 if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-indexOfKey Original Ext JS documentation of 'indexOfKey'
   */
  public native function indexOfKey(key:Object):Number;

  /**
   * Inserts one or more items to the collection. The <code>index</code> value is the position at
   * which the first item will be placed. The items starting at that position will be
   * shifted to make room.
   * @since 5.0.0
   * @param index The index at which to insert the item(s).
   * @param item The item or items to add.
   * @return The item or items added.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-insert Original Ext JS documentation of 'insert'
   */
  public native function insert(index:Number, item:*):*;

  /**
   * This method can be used to conveniently test whether an individual item would be
   * removed due to the current filter.
   * @param item The item to test.
   * @return The value <code>true</code> if the item would be "removed" from the
   * collection due to filters or <code>false</code> otherwise.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-isItemFiltered Original Ext JS documentation of 'isItemFiltered'
   */
  public native function isItemFiltered(item:Object):Boolean;

  /**
   * This method should be called when an item in this collection has been modified. If
   * the collection is sorted or filtered the result of modifying an item needs to be
   * reflected in the collection. If the item's key is also being modified, it is best
   * to pass the <code>oldKey</code> to this same call rather than call <code>→updateKey()</code> separately.
   * @since 5.0.0
   * @param item The item that was modified.
   * @param modified The names of the modified properties of the item.
   * @param oldKey Passed if the item's key was also modified.
   * @see #updateKey()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-itemChanged Original Ext JS documentation of 'itemChanged'
   */
  public native function itemChanged(item:Object, modified:Array = null, oldKey:* = undefined):void;

  /**
   * Returns the last item in the collection.
   * @since 5.0.0
   * @param grouped <code>true</code> to extract the first item in each group. Only applies if
   * a →<code>grouper</code> is active in the collection.
   * @return The last item in the collection. If the grouped parameter is passed,
   * see →<code>aggregateByGroup()</code> for information on the return type.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-last Original Ext JS documentation of 'last'
   * @see #grouper
   * @see #aggregateByGroup()
   */
  public native function last(grouped:Boolean = false):Object;

  /**
   * Determines the maximum value for the specified property over some or all of the
   * items in this collection.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @param begin The index of the first item to include in the maximum.
   * @param end The index at which to stop in <code>→items</code>. The item at this index
   * will <i>not</i> be included in the maximum.
   * @return The maximum of the specified property from the indicated items.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-max Original Ext JS documentation of 'max'
   * @see #items
   */
  public native function max(property:String, begin:Number = NaN, end:Number = NaN):Object;

  /**
   * See →<code>max()</code>. The result is partitioned by group.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @return The result of →<code>max()</code>, partitioned by group. See
   * →<code>aggregateByGroup()</code>.
   * @see #max()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-maxByGroup Original Ext JS documentation of 'maxByGroup'
   * @see #aggregateByGroup()
   */
  public native function maxByGroup(property:String):Object;

  /**
   * Finds the item with the maximum value for the specified property over some or all
   * of the items in this collection.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @param begin The index of the first item to include in the maximum.
   * @param end The index at which to stop in <code>→items</code>. The item at this index
   * will <i>not</i> be included in the maximum.
   * @return The item with the maximum of the specified property from the
   * indicated items.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-maxItem Original Ext JS documentation of 'maxItem'
   * @see #items
   */
  public native function maxItem(property:String, begin:Number = NaN, end:Number = NaN):Object;

  /**
   * See →<code>maxItem()</code>. The result is partitioned by group.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @return The result of →<code>maxItem()</code>, partitioned by group. See
   * →<code>aggregateByGroup()</code>.
   * @see #maxItem()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-maxItemByGroup Original Ext JS documentation of 'maxItemByGroup'
   * @see #aggregateByGroup()
   */
  public native function maxItemByGroup(property:String):Object;

  /**
   * Determines the minimum value for the specified property over some or all of the
   * items in this collection.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @param begin The index of the first item to include in the minimum.
   * @param end The index at which to stop in <code>→items</code>. The item at this index
   * will <i>not</i> be included in the minimum.
   * @return The minimum of the specified property from the indicated items.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-min Original Ext JS documentation of 'min'
   * @see #items
   */
  public native function min(property:String, begin:Number = NaN, end:Number = NaN):Object;

  /**
   * See →<code>min()</code>. The result is partitioned by group.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @return The result of →<code>min()</code>, partitioned by group. See
   * →<code>aggregateByGroup()</code>.
   * @see #min()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-minByGroup Original Ext JS documentation of 'minByGroup'
   * @see #aggregateByGroup()
   */
  public native function minByGroup(property:String):Object;

  /**
   * Finds the item with the minimum value for the specified property over some or all
   * of the items in this collection.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @param begin The index of the first item to include in the minimum.
   * @param end The index at which to stop in <code>→items</code>. The item at this index
   * will <i>not</i> be included in the minimum.
   * @return The item with the minimum of the specified property from the
   * indicated items.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-minItem Original Ext JS documentation of 'minItem'
   * @see #items
   */
  public native function minItem(property:String, begin:Number = NaN, end:Number = NaN):Object;

  /**
   * See →<code>minItem()</code>. The result is partitioned by group.
   * @since 5.0.0
   * @param property The name of the property from each item.
   * @return The result of →<code>minItem()</code>, partitioned by group. See
   * →<code>aggregateByGroup()</code>.
   * @see #minItem()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-minItemByGroup Original Ext JS documentation of 'minItemByGroup'
   * @see #aggregateByGroup()
   */
  public native function minItemByGroup(property:String):Object;

  /**
   * Called after a change of the filter is complete.
   * <p>For example:</p>
   * <pre>
   *  onFilterChange: function (filters) {
   *      if (this.filtered) {
   *          // process filters
   *      } else {
   *          // no filters present
   *      }
   *  }
   * </pre>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param filters The filters collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-onFilterChange Original Ext JS documentation of 'onFilterChange'
   */
  public native function onFilterChange(filters:FilterCollection):void;

  /**
   * Called after a change of the sort is complete.
   * <p>For example:</p>
   * <pre>
   *  onSortChange: function (sorters) {
   *      if (this.sorted) {
   *          // process sorters
   *      } else {
   *          // no sorters present
   *      }
   *  }
   * </pre>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param sorters The sorters collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-onSortChange Original Ext JS documentation of 'onSortChange'
   */
  public native function onSortChange(sorters:SorterCollection):void;

  /**
   * Remove an item from the collection.
   * @since 5.0.0
   * @param item The item or items to remove.
   * @return The number of items removed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-remove Original Ext JS documentation of 'remove'
   */
  public native function remove(item:*):Number;

  /**
   * Remove all items in the collection.
   * @since 5.0.0
   * @return This object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-removeAll Original Ext JS documentation of 'removeAll'
   */
  public native function removeAll():Collection;

  /**
   * Remove an item from a specified index in the collection.
   * @since 5.0.0
   * @param index The index within the collection of the item to remove.
   * @param count The number of items to remove.
   * @default 1
   * @return If <code>→count()</code> was 1 and the item was removed, that item is
   * returned. Otherwise the number of items removed is returned.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-removeAt Original Ext JS documentation of 'removeAt'
   * @see #count()
   */
  public native function removeAt(index:Number, count:Number = 1):*;

  /**
   * Removes the item associated with the passed key from the collection.
   * @since 5.0.0
   * @param key The key of the item to remove.
   * @return Only returned if removing at a specified key. The item removed or
   * <code>false</code> if no item was removed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-removeByKey Original Ext JS documentation of 'removeByKey'
   */
  public native function removeByKey(key:String):Object;

  /**
   * Adds an item to the collection while removing any existing items.
   * Similar to →<code>add()</code>.
   * @since 5.0.0
   * @param item The item or items to add.
   * @return The item or items added.
   * @see #add()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-replaceAll Original Ext JS documentation of 'replaceAll'
   */
  public native function replaceAll(item:*):*;

  /**
   * Sets the value of <code>decoder</code>.
   * @param decoder The new value.
   * @see #decoder
   */
  public native function setDecoder(decoder:Function):void;

  /**
   * Sets the value of <code>defaultSortDirection</code>.
   * @param defaultSortDirection The new value.
   * @see #defaultSortDirection
   */
  public native function setDefaultSortDirection(defaultSortDirection:String):void;

  /**
   * Sets the value of <code>extraKeys</code>.
   * @param extraKeys The new value.
   * @see #extraKeys
   */
  public native function setExtraKeys(extraKeys:Object):void;

  /**
   * Sets the value of <code>filters</code>.
   * @param filters The new value.
   * @see #filters
   */
  public native function setFilters(filters:*):void;

  /**
   * Sets the value of <code>grouper</code>.
   * @param grouper The new value.
   * @see #grouper
   */
  public native function setGrouper(grouper:Object):void;

  /**
   * Sets the value of <code>groups</code>.
   * @param groups The new value.
   * @see #groups
   */
  public native function setGroups(groups:Collection):void;

  /**
   * Sets the value of <code>multiSortLimit</code>.
   * @param multiSortLimit The new value.
   * @see #multiSortLimit
   */
  public native function setMultiSortLimit(multiSortLimit:Number):void;

  /**
   * Sets the value of <code>rootProperty</code>.
   * @param rootProperty The new value.
   * @see #rootProperty
   */
  public native function setRootProperty(rootProperty:String):void;

  /**
   * Sets the value of <code>sorters</code>.
   * @param sorters The new value.
   * @see #sorters
   */
  public native function setSorters(sorters:*):void;

  /**
   * Sets the value of <code>source</code>.
   * @param source The new value.
   * @see #source
   */
  public native function setSource(source:Collection):void;

  /**
   * Updates the sorters collection and triggers sorting of this Sortable.
   * <p>For example:</p>
   * <pre>
   * //sort by a single field
   * myStore.sort('myField', 'DESC');
   *
   * //sorting by multiple fields
   * myStore.sort([{
   *     property : 'age',
   *     direction: 'ASC'
   * }, {
   *     property : 'name',
   *     direction: 'DESC'
   * }]);
   * </pre>
   * <p>When passing a single string argument to sort, the <code>direction</code> is maintained for
   * each field and is toggled automatically. So this code:</p>
   * <pre>
   * store.sort('myField');
   * store.sort('myField');
   * </pre>
   * <p>Is equivalent to the following:</p>
   * <pre>
   * store.sort('myField', 'ASC');
   * store.sort('myField', 'DESC');
   * </pre>
   * @param property Either the name of a property
   * (such as a field of a <code>→ext.data.Model</code> in a <code>Store</code>), an array of configurations
   * for <code>→ext.util.Sorter</code> instances or just a comparison function.
   * @param direction The direction by which to sort the data. This parameter
   * is only valid when <code>property</code> is a String, otherwise the second parameter is the
   * <code>mode</code>.
   * @param mode Where to put new sorters in the collection. This
   * should be one the following values:
   * <ul>
   * <li>
   * <p><b><code>→replace()</code></b> : The new sorter(s) become the sole sorter set for this Sortable.
   * This is the most useful call mode to programmatically sort by multiple fields.</p>
   * </li>
   * <li>
   * <p><b><code>prepend</code></b> : The new sorters are inserted as the primary sorters. The sorter
   * collection length must be controlled by the developer.</p>
   * </li>
   * <li>
   * <p><b><code>multi</code></b> : Similar to <b><code>prepend</code></b> the new sorters are inserted at the front
   * of the collection of sorters. Following the insertion, however, this mode trims
   * the sorter collection to enforce the <code>→multiSortLimit</code> config. This is useful for
   * implementing intuitive "Sort by this" user interfaces.</p>
   * </li>
   * <li>
   * <p><b><code>append</code></b> : The new sorters are added at the end of the collection.</p>
   * </li>
   * </ul>
   * @default "replace"
   * @return This instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-sort Original Ext JS documentation of 'sort'
   * @see ext.data.Model
   * @see ext.util.Sorter
   * @see #replace()
   * @see #multiSortLimit
   */
  public native function sort(property:* = undefined, direction:String = null, mode:String = "replace"):Collection;

  [Deprecated(message="This method is deprecated.\n", since="6.5.0")]
  /**
   * Sorts the collection by a single sorter function
   * @param sortFn The function to sort by
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-sortBy Original Ext JS documentation of 'sortBy'
   */
  public native function sortBy(sortFn:Function):void;

  /**
   * This method will sort an array based on the currently configured →<code>sorters</code>.
   * @param data The array you want to have sorted.
   * @return The array you passed after it is sorted.
   * @see #sorters
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-sortData Original Ext JS documentation of 'sortData'
   */
  public native function sortData(data:Array):Array;

  /**
   * Sorts the items of the collection using the supplied function. This should only be
   * called for collections that have no <code>→sorters</code> defined.
   * @since 5.0.0
   * @param sortFn The function by which to sort the items.
   * @see #sorters
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-sortItems Original Ext JS documentation of 'sortItems'
   */
  public native function sortItems(sortFn:Function):void;

  /**
   * This method is basically the same as the JavaScript Array splice method.
   * <p>Negative indexes are interpreted starting at the end of the collection. That is,
   * a value of -1 indicates the last item, or equivalent to <code>length - 1</code>.</p>
   * @since 5.0.0
   * @param index The index at which to add or remove items.
   * @param toRemove The number of items to remove or an array of the
   * items to remove.
   * @param toAdd The items to insert at the given <code>index</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-splice Original Ext JS documentation of 'splice'
   */
  public native function splice(index:Number, toRemove:*, toAdd:Array = null):*;

  /**
   * Sums property values from some or all of the items in this collection.
   * @since 5.0.0
   * @param property The name of the property to sum from each item.
   * @param begin The index of the first item to include in the sum.
   * @param end The index at which to stop summing <code>→items</code>. The item at this
   * index will <i>not</i> be included in the sum.
   * @return The result of summing the specified property from the indicated
   * items.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-sum Original Ext JS documentation of 'sum'
   * @see #items
   */
  public native function sum(property:String, begin:Number = NaN, end:Number = NaN):Object;

  /**
   * See →<code>sum()</code>. The result is partitioned by group.
   * @since 5.0.0
   * @param property The name of the property to sum from each item.
   * @return The result of →<code>sum()</code>, partitioned by group. See
   * →<code>aggregateByGroup()</code>.
   * @see #sum()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-sumByGroup Original Ext JS documentation of 'sumByGroup'
   * @see #aggregateByGroup()
   */
  public native function sumByGroup(property:String):Object;

  /**
   * This method calls the supplied function <code>fn</code> between <code>→beginUpdate()</code> and <code>→endUpdate()</code>
   * calls.
   * <pre>
   *  collection.update(function () {
   *      // Perform multiple collection updates...
   *
   *      collection.add(item);
   *      // ...
   *
   *      collection.insert(index, otherItem);
   *      //...
   *
   *      collection.remove(someItem);
   *  });
   * </pre>
   * @since 5.0.0
   * @param fn The function to call that will modify this collection.
   * <ul>
   * <li><code>collection:ext.util.Collection</code> (optional) —
   * This collection.
   * </li>
   * </ul>
   * @param scope (Default this) The <code>this</code> pointer to use when calling <code>fn</code>.
   * @default this
   * @return Returns the value returned from <code>fn</code> (typically <code>undefined</code>).
   * @see #beginUpdate()
   * @see #endUpdate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-update Original Ext JS documentation of 'update'
   */
  public native function update(fn:Function, scope:Object = null):Object;

  /**
   * Change the key for an existing item in the collection. If the old key does not
   * exist this call does nothing. Even so, it is highly recommended to <i>avoid</i> calling
   * this method for an <code>item</code> that is not a member of this collection.
   * @since 5.0.0
   * @param item The item whose key has changed. The <code>item</code> should be a member
   * of this collection.
   * @param oldKey The old key for the <code>item</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Collection.html#method-updateKey Original Ext JS documentation of 'updateKey'
   */
  public native function updateKey(item:Object, oldKey:String, details:* = undefined):void;
}
}