package ext.util {
import ext.Base;
import ext.mixin.IIdentifiable;

[Native("Ext.util.CollectionKey", require)]
/**
 * Maintains an additional key map for an <code>→ext.util.Collection</code>. Instances of this class
 * are seldom created manually. Rather they are created by the <code>Ext.util.Collection' when given an</code>extraKeys` config.
 * @see ext.util.Collection
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CollectionKey.html Original Ext JS documentation of 'Ext.util.CollectionKey'
 */
public class CollectionKey extends Base implements IIdentifiable {
  /**
   * @param config @inheritDoc
   */
  public function CollectionKey(config:CollectionKey = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A function to retrieve the key of an item in the collection. This can be normal
   * function that takes an item and returns the key or it can be the name of the
   * method to call on an item to get the key.
   * <p>For example:</p>
   * <pre>
   *  new Ext.util.Collection({
   *      keys: {
   *          byName: {
   *              keyFn: 'getName' // each item has a "getName" method
   *          }
   *      }
   *  });
   * </pre>
   * <p>Or equivalently:</p>
   * <pre>
   *  new Ext.util.Collection({
   *      keys: {
   *          byName: {
   *              keyFn: function (item) {
   *                  return item.getName();
   *              }
   *          }
   *      }
   *  });
   * </pre>
   * @default null
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CollectionKey.html#cfg-keyFn Original Ext JS documentation of 'keyFn'
   * @see #getKeyFn()
   * @see #setKeyFn()
   */
  public native function get keyFn():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set keyFn(value:*):void;

  /**
   * This property is set by <code>→ext.util.Collection</code> when added via <code>extraKeys</code>.
   * @see ext.util.Collection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CollectionKey.html#property-name Original Ext JS documentation of 'name'
   */
  public native function get name():String;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the property on each item that is its key.
   * <pre>
   *  new Ext.util.Collection({
   *      keys: {
   *          byName: 'name'
   *      }
   *  });
   * </pre>
   * <p>Or equivalently:</p>
   * <pre>
   *  new Ext.util.Collection({
   *      keys: {
   *          byName: {
   *              property: 'name'
   *          }
   *      }
   *  });
   *
   *  var item = collection.byName.get('fooname');
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CollectionKey.html#cfg-property Original Ext JS documentation of 'property'
   * @see #getProperty()
   * @see #setProperty()
   */
  public native function get property():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set property(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the sub-object property on each item that is its key. This value
   * overrides <code>→ext.util.Collection.rootProperty</code>.
   * <pre>
   *  new Ext.util.Collection({
   *      keys: {
   *          byName: {
   *              property: 'name',
   *              rootProperty: 'data'
   *          }
   *      }
   *  });
   *
   *  var item = collection.byName.get('fooname');
   * </pre>
   * @see ext.util.Collection#rootProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CollectionKey.html#cfg-rootProperty Original Ext JS documentation of 'rootProperty'
   * @see #getRootProperty()
   * @see #setRootProperty()
   */
  public native function get rootProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rootProperty(value:String):void;

  /**
   * Returns the item or, if not <code>unique</code> possibly array of items that have the given
   * key.
   * @param key The key that will match the <code>→keyFn</code> return value or value of
   * the specified <code>→property</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CollectionKey.html#method-get Original Ext JS documentation of 'get'
   * @see #keyFn
   * @see #property
   */
  public native function get(key:*):Object;

  /**
   * @inheritDoc
   */
  public native function getId():String;

  /**
   * Returns the value of <code>keyFn</code>.
   * @see #keyFn
   */
  public native function getKeyFn():*;

  /**
   * Returns the value of <code>property</code>.
   * @see #property
   */
  public native function getProperty():String;

  /**
   * Returns the value of <code>rootProperty</code>.
   * @see #rootProperty
   */
  public native function getRootProperty():String;

  /**
   * Returns the index of the item with the given key in the collection. If this is not
   * a <code>unique</code> result, the index of the first item in the collection with the matching
   * key.
   * <p>To iterate the indices of all items with a matching (not <code>unique</code>) key:</p>
   * <pre>
   *  for (index = collection.byName.indexOf('foo');
   *          index &gt;= 0;
   *          index = collection.byName.indexOf('foo', index)) {
   *      // process item at "index"
   *  }
   * </pre>
   * @param key The key that will match the <code>→keyFn</code> return value or value of
   * the specified <code>→property</code>.
   * @param startAt The index at which to start. Only occurrences beyond
   * this index are returned.
   * @default -1
   * @return The index of the first item with the given <code>key</code> beyond the given
   * <code>startAt</code> index or -1 if there are no such items.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CollectionKey.html#method-indexOf Original Ext JS documentation of 'indexOf'
   * @see #keyFn
   * @see #property
   */
  public native function indexOf(key:*, startAt:Number = -1):Number;

  /**
   * Sets the value of <code>keyFn</code>.
   * @param keyFn The new value.
   * @see #keyFn
   */
  public native function setKeyFn(keyFn:*):void;

  /**
   * Sets the value of <code>property</code>.
   * @param property The new value.
   * @see #property
   */
  public native function setProperty(property:String):void;

  /**
   * Sets the value of <code>rootProperty</code>.
   * @param rootProperty The new value.
   * @see #rootProperty
   */
  public native function setRootProperty(rootProperty:String):void;

  /**
   * Change the key for an existing item in the collection. If the old key does not
   * exist this call does nothing.
   * @since 5.0.0
   * @param item The item whose key has changed.
   * @param oldKey The old key for the <code>item</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CollectionKey.html#method-updateKey Original Ext JS documentation of 'updateKey'
   */
  public native function updateKey(item:Object, oldKey:String):void;
}
}