package ext.util {
import ext.dd.DragTracker;

[Native("Ext.util.ComponentDragger", require)]
/**
 * A subclass of Ext.dd.DragTracker which handles dragging any Component.
 * <p>This is configured with a Component to be made draggable, and a config object for the
 * →<code>ext.dd.DragTracker</code>
 * class.</p>
 * <p>A →<code>delegate</code> may be provided which may be either the element to use as the mousedown
 * target or a CSS selector to activate multiple mousedown targets.</p>
 * <p>When the Component begins to be dragged, its <code>beginDrag</code> method will be called if implemented.</p>
 * <p>When the drag ends, its <code>→endDrag()</code> method will be called if implemented.</p>
 * @see ext.dd.DragTracker
 * @see #delegate
 * @see #endDrag()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ComponentDragger.html Original Ext JS documentation of 'Ext.util.ComponentDragger'
 */
public class ComponentDragger extends DragTracker {
  /**
   * Creates new ComponentDragger.
   * @param comp The Component to provide dragging for.
   * @param config Config object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ComponentDragger.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function ComponentDragger(comp:Object, config:ComponentDragger = null) {
    super();
  }

  [ExtConfig]
  /**
   * Specify as <code>true</code> to constrain the Component to within the bounds of the →<code>constrainTo</code>
   * region.
   * @see #constrainTo
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ComponentDragger.html#cfg-constrain Original Ext JS documentation of 'constrain'
   */
  public native function get constrain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set constrain(value:Boolean):void;

  [ExtConfig]
  /**
   * Specify as <code>true</code> to constrain the drag handles within the →<code>constrainTo</code> region.
   * @see #constrainTo
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ComponentDragger.html#cfg-constrainDelegate Original Ext JS documentation of 'constrainDelegate'
   */
  public native function get constrainDelegate():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set constrainDelegate(value:Boolean):void;

  [ExtConfig]
  /**
   * A CSS selector which identifies child elements within the Component's encapsulating
   * Element which are the drag handles. This limits dragging to only begin when the matching
   * elements are mousedowned.
   * <p>This may also be a specific child element within the Component's encapsulating element
   * to use as the drag handle.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ComponentDragger.html#cfg-delegate Original Ext JS documentation of 'delegate'
   */
  override public native function get delegate():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set delegate(value:String):void;
}
}