package ext.util {

[Native("Ext.util.DelayedTask", require)]
/**
 * The DelayedTask class provides a convenient way to "buffer" the execution of a method,
 * performing setTimeout where a new timeout cancels the old timeout. When called, the
 * task will wait the specified time period before executing. If durng that time period,
 * the task is called again, the original call will be cancelled. This continues so that
 * the function is only called a single time for each iteration.
 * <p>This method is especially useful for things like detecting whether a user has finished
 * typing in a text field. An example would be performing validation on a keypress. You can
 * use this class to buffer the keypress events for a certain number of milliseconds, and
 * perform only if they stop for that amount of time.</p>
 * <p><b><i>Usage</i></b></p>
 * <pre>
 * var task = new Ext.util.DelayedTask(function(){
 *     alert(Ext.getDom('myInputField').value.length);
 * });
 *
 * // Wait 500ms before calling our function. If the user presses another key
 * // during that 500ms, it will be cancelled and we'll wait another 500ms.
 * Ext.get('myInputField').on('keypress', function() {
 *     task.delay(500);
 * });
 * </pre>
 * <p>Note that we are using a DelayedTask here to illustrate a point. The configuration
 * option <code>buffer</code> for <i>addListener/on</i> (→<code>ext.util.Observable.addListener()</code>) will
 * also setup a delayed task for you to buffer events.</p>
 * @see ext.util.Observable#addListener()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.DelayedTask.html Original Ext JS documentation of 'Ext.util.DelayedTask'
 */
public class DelayedTask extends Object {
  /**
   * The parameters to this constructor serve as defaults and are not required.
   * @param fn The default function to call. If not specified here, it must be
   * specified during the →<code>delay()</code> call.
   * @param scope The default scope (The <b><code>this</code></b> reference) in which the
   * function is called. If not specified, <code>this</code> will refer to the browser window.
   * @param args The default Array of arguments.
   * @param cancelOnDelay By default, each call to →<code>delay()</code> cancels
   * any pending invocation and reschedules a new invocation. Specifying this as <code>false</code> means
   * that calls to →<code>delay()</code> when an invocation is pending just update the call settings,
   * <code>newDelay</code>, <code>newFn</code>, <code>newScope</code> or <code>newArgs</code>, whichever are passed.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.DelayedTask.html#method-constructor Original Ext JS documentation of 'constructor'
   * @see #delay()
   */
  public native function DelayedTask(fn:Function = null, scope:Object = null, args:Array = null, cancelOnDelay:Boolean = true);

  /**
   * The id of the currently pending invocation. Will be set to <code>null</code> if there is no
   * invocation pending.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.DelayedTask.html#property-id Original Ext JS documentation of 'id'
   */
  public native function get id():Number;

  /**
   * @private
   */
  public native function set id(value:Number):void;

  /**
   * Cancel the last queued timeout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.DelayedTask.html#method-cancel Original Ext JS documentation of 'cancel'
   */
  public native function cancel():void;

  /**
   * By default, cancels any pending timeout and queues a new one.
   * <p>If the <code>cancelOnDelay</code> parameter was specified as <code>false</code> in the constructor, this does not
   * cancel and reschedule, but just updates the call settings, <code>newDelay</code>, <code>newFn</code>, <code>newScope</code>
   * or <code>newArgs</code>, whichever are passed.</p>
   * @param newDelay The milliseconds to delay. <code>-1</code> means schedule for the next
   * animation frame if supported.
   * @param newFn Overrides function passed to constructor
   * @param newScope Overrides scope passed to constructor. Remember that if no scope
   * is specified, <code>this</code> will refer to the browser window.
   * @param newArgs Overrides args passed to constructor
   * @return The timer id being used.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.DelayedTask.html#method-delay Original Ext JS documentation of 'delay'
   */
  public native function delay(newDelay:Number, newFn:Function = null, newScope:Object = null, newArgs:Array = null):Number;
}
}