package ext.util {
import ext.Base;

[Native("Ext.util.ElementContainer", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>This mixin enables classes to declare relationships to child elements and provides the
 * mechanics for acquiring the <i>elements</i> (→<code>ext.dom.Element</code>) and storing them on an object
 * instance as properties.</p>
 * <p>This class is used by <i>components</i> (→<code>ext.Component</code>) and
 * <i>container layouts</i> (→<code>ext.layout.container.ContainerLayout</code>) to manage their child elements.</p>
 * <p>A typical component that uses these features might look something like this:</p>
 * <pre>
 *  Ext.define('Ext.ux.SomeComponent', {
 *      extend: 'Ext.Component',
 *
 *      childEls: [
 *          'bodyEl'
 *      ],
 *
 *      renderTpl: [
 *          '&lt;div id="{id}-bodyEl" data-ref="bodyEl"&gt;&lt;/div&gt;'
 *      ],
 *
 *      // ...
 *  });
 * </pre>
 * <p>The <code>→childEls</code> config lists one or more relationships to child elements managed
 * by the component. The items in this array can be objects that more fully specify the
 * child. For example, the above could have used this instead to achieve the same result:</p>
 * <pre>
 *  childEls: [
 *      { name: 'bodyEl', itemId: 'bodyEl' }
 *  ]
 * </pre>
 * <p>Unlike a <code>renderTpl</code> where there is a single value for an instance, <code>→childEls</code> are aggregated
 * up the class hierarchy so that they are effectively inherited. In other words, if a
 * class where to derive from <code>Ext.ux.SomeComponent</code> in the example above, it could also
 * have a <code>→childEls</code> property in the same way as <code>Ext.ux.SomeComponent</code>.</p>
 * <pre>
 *  Ext.define('Ext.ux.AnotherComponent', {
 *      extend: 'Ext.ux.SomeComponent',
 *
 *      childEls: [
 *          // 'bodyEl' is inherited
 *          'innerEl'
 *      ],
 *
 *      renderTpl: [
 *          '&lt;div id="{id}-bodyEl" data-ref="bodyEl"&gt;'
 *              '&lt;div id="{id}-innerEl" data-ref="innerEl"&gt;&lt;/div&gt;'
 *          '&lt;/div&gt;'
 *      ],
 *
 *      // ...
 *  });
 * </pre>
 * <p><b>IMPORTANT</b>
 * The <code>renderTpl</code> contains both child elements and unites them in the desired markup, but
 * the <code>→childEls</code> only contains the new child element. The <code>data-ref</code> attribute must be
 * rendered on to child elements that do not use <code>select</code> or <code>selectNode</code> options. This
 * is done for performance reasons on IE8 where element lookup (even by id) is not very
 * efficient.</p>
 * @see ext.dom.Element
 * @see ext.Component
 * @see ext.layout.container.ContainerLayout
 * @see #childEls
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ElementContainer.html Original Ext JS documentation of 'Ext.util.ElementContainer'
 */
public class ElementContainer extends Base implements IElementContainer {
  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default {}
   * @see #childEls
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ElementContainer.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set childEls(value:*):void;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  public native function getChildEls():*;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  public native function setChildEls(childEls:*):void;
}
}