package ext.util {

[Native("Ext.util.Filter", require)]
/**
 * A filter that can be applied to an <code>→ext.util.Collection</code> or other data container such
 * an <code>→ext.data.Store</code>. A <code>Filter</code> can be simply a filter on a <code>→property</code> and <code>→value</code> pair
 * or a filter function with custom logic.
 * <p>Normally filters are added to stores or collections but they can be created directly:</p>
 * <pre>
 * var ageFilter = new Ext.util.Filter({
 *     property: 'age',
 *     value: 42,
 *     operator: '&lt;'
 * });
 *
 * var longNameFilter = new Ext.util.Filter({
 *     filterFn: function(item) {
 *         return item.name.length &gt; 4;
 *     }
 * });
 * </pre>
 * @see ext.util.Collection
 * @see ext.data.Store
 * @see #property
 * @see #value
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html Original Ext JS documentation of 'Ext.util.Filter'
 */
public class Filter extends BasicFilter {
  /**
   * Creates a single filter function which encapsulates the passed Filter array or
   * Collection.
   * @param filters The filters from which to
   * create a filter function.
   * @return A function, which when passed a candidate object returns <code>true</code>
   * if the candidate passes all the specified Filters.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#static-method-createFilterFn Original Ext JS documentation of 'createFilterFn'
   */
  public static native function createFilterFn(filters:*):Function;

  /**
   * Checks if two filters have the same properties (Property, Operator and Value).
   * @since 6.2.0
   * @param filter1 The first filter to be compared
   * @param filter2 The second filter to be compared
   * @return <code>true</code> if they have the same properties.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#static-method-isEqual Original Ext JS documentation of 'isEqual'
   */
  public static native function isEqual(filter1:Filter, filter2:Filter):Boolean;

  /**
   * @param config @inheritDoc
   */
  public function Filter(config:Filter = null) {
    super(null);
  }

  [ExtConfig]
  [Bindable]
  /**
   * True to allow any match - no regex start/end line anchors will be added.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#cfg-anyMatch Original Ext JS documentation of 'anyMatch'
   * @see #getAnyMatch()
   * @see #setAnyMatch()
   */
  public native function get anyMatch():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set anyMatch(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to make the regex case sensitive (adds 'i' switch to regex).
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#cfg-caseSensitive Original Ext JS documentation of 'caseSensitive'
   * @see #getCaseSensitive()
   * @see #setCaseSensitive()
   */
  public native function get caseSensitive():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set caseSensitive(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to not have this filter participate in the filtering process when the
   * →<code>value</code> of this the filter is empty according to →<code>ext.Ext.isEmpty()</code>.
   * @default false
   * @since 5.1.0
   * @see #value
   * @see ext.SExt#isEmpty() ext.Ext.isEmpty()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#cfg-disableOnEmpty Original Ext JS documentation of 'disableOnEmpty'
   * @see #getDisableOnEmpty()
   * @see #setDisableOnEmpty()
   */
  public native function get disableOnEmpty():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set disableOnEmpty(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to force exact match (^ and $ characters added to the regex). Ignored if
   * <code>→anyMatch</code> is <code>true</code>.
   * @default false
   * @see #anyMatch
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#cfg-exactMatch Original Ext JS documentation of 'exactMatch'
   * @see #getExactMatch()
   * @see #setExactMatch()
   */
  public native function get exactMatch():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set exactMatch(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * A custom filter function which is passed each item. This function must return
   * <code>true</code> to accept an item or <code>false</code> to reject it.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#cfg-filterFn Original Ext JS documentation of 'filterFn'
   * @see #getFilterFn()
   * @see #setFilterFn()
   */
  public native function get filterFn():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set filterFn(value:Function):void;

  [ExtConfig]
  [Bindable]
  /**
   * The operator to use to compare the →<code>property</code> to this Filter's
   * →<code>value</code>.
   * <p>Possible values are:</p>
   * <ul>
   * <li><code>&lt;</code></li>
   * <li><code>&lt;=</code></li>
   * <li><code>=</code></li>
   * <li><code>&gt;=</code></li>
   * <li><code>&gt;</code></li>
   * <li><code>!=</code></li>
   * <li><code>in</code></li>
   * <li><code>notin</code></li>
   * <li><code>like</code></li>
   * <li><code>/=</code></li>
   * </ul>
   * <p>The <code>in</code> and <code>notin</code> operator expects this filter's →<code>value</code> to be
   * an array and matches values that are present in that array.</p>
   * <p>The <code>like</code> operator matches values that contain this filter's →<code>value</code>
   * as a substring.</p>
   * <p>The <code>/=</code> operator uses the →<code>value</code> as the source for a <code>→RegExp</code> and
   * tests whether the candidate value matches the regular expression.</p>
   * @see #property
   * @see #value
   * @see RegExp
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#cfg-operator Original Ext JS documentation of 'operator'
   * @see #getOperator()
   * @see #setOperator()
   */
  public native function get operator():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set operator(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The property to filter on. Required unless a →<code>filterFn</code> is passed.
   * @see #filterFn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#cfg-property Original Ext JS documentation of 'property'
   * @see #getProperty()
   * @see #setProperty()
   */
  public native function get property():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set property(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * This property is used to descend items to check for meaningful properties on
   * which to filter. For a <code>→ext.data.Model</code> for example this would be <code>'data'</code>.
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#cfg-root Original Ext JS documentation of 'root'
   * @see #getRoot()
   * @see #setRoot()
   */
  public native function get root():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set root(value:String):void;

  [ExtConfig]
  /**
   * The context (<code>this</code> property) in which the filtering function is called. Defaults
   * to this Filter object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The value you want to match against. Required unless a →<code>filterFn</code> is passed.
   * <p>Can be a regular expression which will be used as a matcher or any other value
   * such as an object or an array of objects. This value is compared using the configured
   * →<code>operator</code>.</p>
   * @default null
   * @see #filterFn
   * @see #operator
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set value(value:*):void;

  /**
   * Returns the value of <code>anyMatch</code>.
   * @see #anyMatch
   */
  public native function getAnyMatch():Boolean;

  /**
   * Returns the value of <code>caseSensitive</code>.
   * @see #caseSensitive
   */
  public native function getCaseSensitive():Boolean;

  /**
   * Returns the value of <code>disableOnEmpty</code>.
   * @see #disableOnEmpty
   */
  public native function getDisableOnEmpty():Boolean;

  /**
   * Returns the value of <code>exactMatch</code>.
   * @see #exactMatch
   */
  public native function getExactMatch():Boolean;

  /**
   * Returns the value of <code>filterFn</code>.
   * @see #filterFn
   */
  public native function getFilterFn():Function;

  /**
   * Returns the value of <code>operator</code>.
   * @see #operator
   */
  public native function getOperator():String;

  /**
   * Returns the value of <code>property</code>.
   * @see #property
   */
  public native function getProperty():String;

  /**
   * Returns the value of <code>root</code>.
   * @see #root
   */
  public native function getRoot():String;

  /**
   * Returns this filter's state.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#method-getState Original Ext JS documentation of 'getState'
   */
  public native function getState():Object;

  /**
   * Returns the value of <code>value</code>.
   * @see #value
   */
  public native function getValue():*;

  /**
   * Returns this filter's serialized state. This is used when transmitting this filter
   * to a server.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Filter.html#method-serialize Original Ext JS documentation of 'serialize'
   */
  override public native function serialize():Object;

  /**
   * Sets the value of <code>anyMatch</code>.
   * @param anyMatch The new value.
   * @see #anyMatch
   */
  public native function setAnyMatch(anyMatch:Boolean):void;

  /**
   * Sets the value of <code>caseSensitive</code>.
   * @param caseSensitive The new value.
   * @see #caseSensitive
   */
  public native function setCaseSensitive(caseSensitive:Boolean):void;

  /**
   * Sets the value of <code>disableOnEmpty</code>.
   * @param disableOnEmpty The new value.
   * @see #disableOnEmpty
   */
  public native function setDisableOnEmpty(disableOnEmpty:Boolean):void;

  /**
   * Sets the value of <code>exactMatch</code>.
   * @param exactMatch The new value.
   * @see #exactMatch
   */
  public native function setExactMatch(exactMatch:Boolean):void;

  /**
   * Sets the value of <code>filterFn</code>.
   * @param filterFn The new value.
   * @see #filterFn
   */
  public native function setFilterFn(filterFn:Function):void;

  /**
   * Sets the value of <code>operator</code>.
   * @param operator The new value.
   * @see #operator
   */
  public native function setOperator(operator:String):void;

  /**
   * Sets the value of <code>property</code>.
   * @param property The new value.
   * @see #property
   */
  public native function setProperty(property:String):void;

  /**
   * Sets the value of <code>root</code>.
   * @param root The new value.
   * @see #root
   */
  public native function setRoot(root:String):void;

  /**
   * Sets the value of <code>value</code>.
   * @param value The new value.
   * @see #value
   */
  public native function setValue(value:*):void;
}
}