package ext.util {

[Native("Ext.util.FilterCollection", require)]
/**
 * This class provides a flexible means to control the
 * <code>→ext.util.Collection.filters</code> of a
 * <code>→ext.util.Collection</code>. Instances of this class are created
 * automatically when filters are added to added to Collections.
 * <p>This collection can be directly manipulated by application code to gain full
 * control over the filters of the owner collection. Be aware that some components
 * create filters internally (such as <code>→ext.form.field.ComboBox</code> and the
 * <code>→ext.grid.filters.Filters</code> plugin) so be careful in such cases to not disturb
 * these additional filters.</p>
 * <p>Items in this collection are <code>→ext.util.Filter</code> instances and can be managed
 * individually by their <code>id</code>. This is the recommended way to manage application
 * filters while preserving filters applied from other sources.</p>
 * <p>Bulk changes to this collection should be wrapped in
 * <code>→ext.util.Collection.beginUpdate()</code> and
 * <code>→ext.util.Collection.endUpdate()</code> (as with any collection).
 * During these bulk updates all reactions to filter changes will be suspended.</p>
 * @see ext.util.Collection#filters
 * @see ext.util.Collection
 * @see ext.form.field.ComboBox
 * @see ext.grid.filters.Filters
 * @see ext.util.Filter
 * @see ext.util.Collection#beginUpdate()
 * @see ext.util.Collection#endUpdate()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.FilterCollection.html Original Ext JS documentation of 'Ext.util.FilterCollection'
 */
public class FilterCollection extends Collection {
  /**
   * @inheritDoc
   */
  public function FilterCollection(config:Collection = null) {
    super();
  }

  /**
   * This is the cached filter function.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.FilterCollection.html#property-filterFn Original Ext JS documentation of 'filterFn'
   */
  public native function get filterFn():*;

  /**
   * This method will filter an array based on the currently configured <code>→filters</code>.
   * @param data The array you want to have filtered.
   * @return The array you passed after it is filtered.
   * @see #filters
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.FilterCollection.html#method-filterData Original Ext JS documentation of 'filterData'
   */
  public native function filterData(data:Array):Array;

  /**
   * returns the number of <i>enabled</i> filters in this <code>FilterCollection</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.FilterCollection.html#method-getFilterCount Original Ext JS documentation of 'getFilterCount'
   */
  public native function getFilterCount():Number;

  /**
   * Returns the filter function.
   * @return The filter function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.FilterCollection.html#method-getFilterFn Original Ext JS documentation of 'getFilterFn'
   */
  override public native function getFilterFn():Function;
}
}