package ext.util {

[Native("Ext.util.Format", require)]
/**
 * This class is a centralized place for formatting functions. It includes
 * functions to format various different types of data, such as text, dates and numeric values.
 * <p><b><i>Localization</i></b></p>
 * <p>This class contains several options for localization. These can be set once the library
 * has loaded, all calls to the functions from that point will use the locale settings
 * that were specified.</p>
 * <p>Options include:</p>
 * <ul>
 * <li>thousandSeparator</li>
 * <li>decimalSeparator</li>
 * <li>currencyPrecision</li>
 * <li>currencySign</li>
 * <li>currencyAtEnd</li>
 * </ul>
 * <p>This class also uses the default date format defined here: →<code>ext.DateUtil.defaultFormat</code>.</p>
 * <p><b><i>Using with renderers</i></b></p>
 * <p>There are two helper functions that return a new function that can be used in conjunction with
 * grid renderers:</p>
 * <pre>
 * columns: [{
 *     dataIndex: 'date',
 *     renderer: Ext.util.Format.dateRenderer('Y-m-d')
 * }, {
 *     dataIndex: 'time',
 *     renderer: Ext.util.Format.numberRenderer('0.000')
 * }]
 * </pre>
 * <p>Functions that only take a single argument can also be passed directly:</p>
 * <pre>
 * columns: [{
 *     dataIndex: 'cost',
 *     renderer: Ext.util.Format.usMoney
 * }, {
 *     dataIndex: 'productCode',
 *     renderer: Ext.util.Format.uppercase
 * }]
 * </pre>
 * <p><b><i>Using with XTemplates</i></b></p>
 * <p>XTemplates can also directly use Ext.util.Format functions:</p>
 * <pre>
 * new Ext.XTemplate([
 *     'Date: {startDate:date("Y-m-d")}',
 *     'Cost: {cost:usMoney}'
 * ]);
 * </pre>
 * @see ext.SDateUtil#defaultFormat ext.DateUtil.defaultFormat
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Format.html Original Ext JS documentation of 'Ext.util.Format'
 */
public const Format:SFormat = new SFormat;
}