package ext.util {
import ext.data.Model;

[Native("Ext.util.Grouper", require)]
/**
 * Represents a grouping of items. The grouper works in a similar fashion as the
 * <code>→ext.util.Sorter</code> except that groups must be able to extract a value by which all items
 * in the group can be collected. By default this is derived from the <code>→property</code> config
 * but can be customized using the <code>→groupFn</code> if necessary.
 * <p>All items with the same group value compare as equal. If the group values do not compare
 * equally, the sort can be controlled further by setting <code>→sortProperty</code> or <code>→sorterFn</code>.</p>
 * @see ext.util.Sorter
 * @see #property
 * @see #groupFn
 * @see #sortProperty
 * @see #sorterFn
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Grouper.html Original Ext JS documentation of 'Ext.util.Grouper'
 */
public class Grouper extends Sorter {
  /**
   * @param config @inheritDoc
   */
  public function Grouper(config:Grouper = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * This function is called for each item in the collection
   * to determine the group to which it belongs. By default the <code>→property</code> value is
   * used to group items.
   * <ul>
   * <li><code>item:Object</code> (optional) —
   * The current item from the collection.
   * </li>
   * <li><code>return:String</code> (optional) —
   * The group identifier for the item.
   * </li>
   * </ul>
   * @see #property
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Grouper.html#cfg-groupFn Original Ext JS documentation of 'groupFn'
   * @see #getGroupFn()
   * @see #setGroupFn()
   */
  public native function get groupFn():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set groupFn(value:Function):void;

  [ExtConfig]
  [Bindable]
  /**
   * The field by which records are grouped. Groups are
   * sorted alphabetically by group value as the default. To sort groups by a different
   * property, use the →<code>sortProperty</code> configuration.
   * @see #sortProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Grouper.html#cfg-property Original Ext JS documentation of 'property'
   * @see #getProperty()
   * @see #setProperty()
   */
  override public native function get property():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set property(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * You can set this configuration if you want the groups
   * to be sorted on something other then the group string returned by the <code>→groupFn</code>.
   * This serves the same role as <code>→property</code> on a normal <code>→ext.util.Sorter</code>.
   * @see #groupFn
   * @see #property
   * @see ext.util.Sorter
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Grouper.html#cfg-sortProperty Original Ext JS documentation of 'sortProperty'
   * @see #getSortProperty()
   * @see #setSortProperty()
   */
  public native function get sortProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set sortProperty(value:String):void;

  /**
   * Returns the value of <code>groupFn</code>.
   * @see #groupFn
   */
  public native function getGroupFn():Function;

  /**
   * Returns the string value for grouping, primarily used for grouper key.
   * @param item The Model instance
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Grouper.html#method-getGroupString Original Ext JS documentation of 'getGroupString'
   */
  public native function getGroupString(item:Model):String;

  /**
   * Returns the value for grouping to be used.
   * @param item The Model instance
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Grouper.html#method-getGroupValue Original Ext JS documentation of 'getGroupValue'
   */
  public native function getGroupValue(item:Model):*;

  /**
   * Returns the value of <code>property</code>.
   * @see #property
   */
  override public native function getProperty():String;

  /**
   * Returns the value of <code>sortProperty</code>.
   * @see #sortProperty
   */
  public native function getSortProperty():String;

  /**
   * Sets the value of <code>groupFn</code>.
   * @param groupFn The new value.
   * @see #groupFn
   */
  public native function setGroupFn(groupFn:Function):void;

  /**
   * Sets the value of <code>property</code>.
   * @param property The new value.
   * @see #property
   */
  override public native function setProperty(property:String):void;

  /**
   * Sets the value of <code>sortProperty</code>.
   * @param sortProperty The new value.
   * @see #sortProperty
   */
  public native function setSortProperty(sortProperty:String):void;
}
}