package ext.util {
import ext.mixin.Observable;

[Native("Ext.util.HashMap", require)]
/**
 * @see ext.util.events.HashMap_key_valueEvent.ADD
 * @eventType ext.util.events.HashMap_key_valueEvent.ADD
 */
[Event(name='onAdd', type='ext.util.events.HashMap_key_valueEvent')]
/**
 * @see ext.util.events.HashMapEvent.CLEAR
 * @eventType ext.util.events.HashMapEvent.CLEAR
 */
[Event(name='onClear', type='ext.util.events.HashMapEvent')]
/**
 * @see ext.util.events.HashMap_key_valueEvent.REMOVE
 * @eventType ext.util.events.HashMap_key_valueEvent.REMOVE
 */
[Event(name='onRemove', type='ext.util.events.HashMap_key_valueEvent')]
/**
 * @see ext.util.events.HashMap_key_value_oldEvent.REPLACE
 * @eventType ext.util.events.HashMap_key_value_oldEvent.REPLACE
 */
[Event(name='onReplace', type='ext.util.events.HashMap_key_value_oldEvent')]
/**
 * Represents a collection of a set of key and value pairs. Each key in the HashMap
 * must be unique, the same key cannot exist twice. Access to items is provided via
 * the key only. Sample usage:
 * <pre>
 * var map = new Ext.util.HashMap();
 * map.add('key1', 1);
 * map.add('key2', 2);
 * map.add('key3', 3);
 *
 * map.each(function(key, value, length){
 *     console.log(key, value, length);
 * });
 * </pre>
 * <p>The HashMap is an unordered class,
 * there is no guarantee when iterating over the items that they will be in any particular
 * order. If this is required, then use a →<code>ext.util.MixedCollection</code>.</p>
 * @see ext.util.MixedCollection
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html Original Ext JS documentation of 'Ext.util.HashMap'
 */
public class HashMap extends ext.mixin.Observable {
  /**
   * Creates new HashMap.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function HashMap(config:HashMap = null) {
    super();
  }

  /**
   * Mutation counter which is incremented upon add and remove.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#property-generation Original Ext JS documentation of 'generation'
   */
  public native function get generation():*;

  [ExtConfig]
  [Bindable]
  /**
   * A function that is used to retrieve a default key for a passed
   * object. A default is provided that returns the <code>id</code> property on the object. This function
   * is only used if the <code>add</code> method is called with a single argument.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#cfg-keyFn Original Ext JS documentation of 'keyFn'
   * @see #getKeyFn()
   * @see #setKeyFn()
   */
  public native function get keyFn():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set keyFn(value:Function):void;

  /**
   * Adds an item to the collection. Fires the →<code>event:onAdd</code> event when complete.
   * @param key The key to associate with the item, or the new item.
   * <p>If a →<code>getKey()</code> implementation was specified for this HashMap,
   * or if the key of the stored items is in a property called <code>id</code>,
   * the HashMap will be able to <i>derive</i> the key for the new item.
   * In this case just pass the new item in this parameter.</p>
   * @param value The item to add.
   * @return The item added.
   * @see #event:onAdd
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-add Original Ext JS documentation of 'add'
   * @see #getKey()
   */
  public native function add(key:*, value:Object = null):Object;

  /**
   * Removes all items from the hash.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear():HashMap;

  /**
   * Performs a shallow copy on this hash.
   * @return The new hash object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone():HashMap;

  /**
   * Checks whether a value exists in the hash.
   * @param value The value to check for.
   * @return True if the value exists in the dictionary.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(value:Object):Boolean;

  /**
   * Checks whether a key exists in the hash.
   * @param key The key to check for.
   * @return True if they key exists in the hash.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-containsKey Original Ext JS documentation of 'containsKey'
   */
  public native function containsKey(key:String):Boolean;

  /**
   * Executes the specified function once for each item in the hash.
   * Returning false from the function will cease iteration.
   * @param fn The function to execute.
   * <ul>
   * <li><code>key:String</code> (optional) —
   * The key of the item.
   * </li>
   * <li><code>value:Number</code> (optional) —
   * The value of the item.
   * </li>
   * <li><code>length:Number</code> (optional) —
   * The total number of items in the hash.
   * </li>
   * </ul>
   * @param scope The scope to execute in. Defaults to <tt>this</tt>.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(fn:Function, scope:Object = null):HashMap;

  /**
   * Retrieves an item with a particular key.
   * @param key The key to lookup.
   * @return The value at that key. If it doesn't exist, <code>undefined</code> is returned.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-get Original Ext JS documentation of 'get'
   */
  public native function get(key:String):Object;

  /**
   * Gets the number of items in the hash.
   * @return The number of items in the hash.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-getCount Original Ext JS documentation of 'getCount'
   */
  public native function getCount():Number;

  /**
   * Extracts the key from an object. This is a default implementation, it may be overridden
   * @param o The object to get the key from
   * @return The key to use.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-getKey Original Ext JS documentation of 'getKey'
   */
  public native function getKey(o:Object):String;

  /**
   * Returns the value of <code>keyFn</code>.
   * @see #keyFn
   */
  public native function getKeyFn():Function;

  /**
   * Return all of the keys in the hash.
   * @return An array of keys.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-getKeys Original Ext JS documentation of 'getKeys'
   */
  public native function getKeys():Array;

  /**
   * Return all of the values in the hash.
   * @return An array of values.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-getValues Original Ext JS documentation of 'getValues'
   */
  public native function getValues():Array;

  /**
   * Remove an item from the hash.
   * @param o The value of the item to remove.
   * @return True if the item was successfully removed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-remove Original Ext JS documentation of 'remove'
   */
  public native function remove(o:Object):Boolean;

  /**
   * Remove an item from the hash.
   * @param key The key to remove.
   * @return True if the item was successfully removed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-removeAtKey Original Ext JS documentation of 'removeAtKey'
   */
  public native function removeAtKey(key:String):Boolean;

  /**
   * An alias for →<code>removeAtKey()</code>
   * Remove an item from the hash.
   * @param key The key to remove.
   * @return True if the item was successfully removed.
   * @see #removeAtKey()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-removeByKey Original Ext JS documentation of 'removeByKey'
   */
  public native function removeByKey(key:String):Boolean;

  /**
   * Replaces an item in the hash. If the key doesn't exist, the
   * →<code>add()</code> method will be used.
   * @param key The key of the item.
   * @param value The new value for the item.
   * @return The new value of the item.
   * @see #add()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.HashMap.html#method-replace Original Ext JS documentation of 'replace'
   */
  public native function replace(key:String, value:Object):Object;

  /**
   * Sets the value of <code>keyFn</code>.
   * @param keyFn The new value.
   * @see #keyFn
   */
  public native function setKeyFn(keyFn:Function):void;
}
}