package ext.util {

[Native("Ext.util.History", require)]
/**
 * History management component that allows you to register arbitrary tokens that signify
 * application history state on navigation actions. You can then handle the history
 * →<code>event:onChange</code> event in order to reset your application UI to the appropriate state when
 * the user navigates forward or backward through the browser history stack.
 * <p><b><i>Initializing</i></b></p>
 * <p>The →<code>init()</code> method of the History object must be called before using History. This sets up
 * the internal state and must be the first thing called before using History.</p>
 * @see SHistory#event:onChange
 * @see SHistory#init()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.History.html Original Ext JS documentation of 'Ext.util.History'
 */
public const History:SHistory = new SHistory;
}