package ext.util {
import ext.Component;
import ext.ZIndexManager;
import ext.container.Container;

[Mixin("ext.util.Floating")]
/**
 * A mixin to add floating capability to a Component.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html Original Ext JS documentation of 'Ext.util.Floating'
 * @see ext.util.Floating
 */
public interface IFloating {
  [ExtConfig] /**
   * By default, when the →<code>ext.Component.alignTo()</code> method is called, a floating
   * component will scroll to keep aligned with the anchoring element if the anchoring element
   * is part of the scroll.
   * <p>If this is not necessary, and the <code>alignTo</code> is a one-off operation then set this config
   * to <code>false</code>.</p>
   * @default true
   * @see ext.Component#alignTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-alignOnScroll Original Ext JS documentation of 'alignOnScroll'
   */
  function get alignOnScroll():Boolean;

  [ExtConfig] function set alignOnScroll(value:Boolean):void;

  [ExtConfig]
  [Bindable] /**
   * A flag indicating that this component should be
   * on the top of the z-index stack for use by the →<code>zIndexManager</code> to sort its stack.
   * <p>This may be a positive number to prioritize the ordering of multiple visible
   * always on top components.</p>
   * <p>This may be set to a <i>negative</i> number to prioritize a component to the <i>bottom</i>
   * of the z-index stack.</p>
   * @default false
   * @see #zIndexManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-alwaysOnTop Original Ext JS documentation of 'alwaysOnTop'
   * @see #getAlwaysOnTop()
   * @see #setAlwaysOnTop()
   */
  function get alwaysOnTop():*;

  [ExtConfig]
  [Bindable] function set alwaysOnTop(value:*):void;

  [ExtConfig] /**
   * <code>true</code> to animate the shadow along with the component while the component is animating.
   * By default the shadow is hidden while the component is animating
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-animateShadow Original Ext JS documentation of 'animateShadow'
   */
  function get animateShadow():Boolean;

  [ExtConfig] function set animateShadow(value:Boolean):void;

  [ExtConfig] /**
   * True to constrain this Components within its containing element, false to allow it to fall
   * outside of its containing element. By default this Component will be rendered to
   * <code>document.body</code>. To render and constrain this Component within another element specify
   * →<code>ext.Component.renderTo</code>.
   * @default false
   * @see ext.Component#renderTo
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-constrain Original Ext JS documentation of 'constrain'
   */
  function get constrain():Boolean;

  [ExtConfig] function set constrain(value:Boolean):void;

  [ExtConfig] /**
   * Configure as <code>true</code> to have this Component fixed at its <code>X, Y</code> coordinates in the browser
   * viewport, immune to scrolling the document.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-fixed Original Ext JS documentation of 'fixed'
   */
  function get fixed():Boolean;

  [ExtConfig] function set fixed(value:Boolean):void;

  [ExtConfig] /**
   * Specifies whether the floated component should be automatically
   * <i>focused</i> (→<code>ext.Component.focus()</code>) when it is <i>brought to the front</i> (→<code>toFront()</code>).
   * @default true
   * @see ext.Component#focus()
   * @see #toFront()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-focusOnToFront Original Ext JS documentation of 'focusOnToFront'
   */
  function get focusOnToFront():Boolean;

  [ExtConfig] function set focusOnToFront(value:Boolean):void;

  [ExtConfig] /**
   * True to make the floated component modal and mask everything behind it when displayed,
   * false to display it without restricting access to other UI elements.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-modal Original Ext JS documentation of 'modal'
   */
  function get modal():Boolean;

  [ExtConfig] function set modal(value:Boolean):void;

  [ExtConfig] /**
   * Specifies whether the floating component should be given a shadow. Set to true
   * to automatically create an →<code>ext.dom.Shadow</code>, or a string indicating the shadow's display
   * →<code>ext.dom.Shadow.mode</code>. Set to false to disable the shadow.
   * @default 'sides'
   * @see ext.dom.Shadow
   * @see ext.dom.Shadow#mode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-shadow Original Ext JS documentation of 'shadow'
   */
  function get shadow():*;

  [ExtConfig] function set shadow(value:*):void;

  [ExtConfig] /**
   * Number of pixels to offset the shadow.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-shadowOffset Original Ext JS documentation of 'shadowOffset'
   */
  function get shadowOffset():Number;

  [ExtConfig] function set shadowOffset(value:Number):void;

  [ExtConfig] /**
   * <code>true</code> to enable an iframe shim for this Component to keep
   * windowed objects from showing through.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-shim Original Ext JS documentation of 'shim'
   */
  function get shim():Boolean;

  [ExtConfig] function set shim(value:Boolean):void;

  /**
   * Only present for →<code>ext.Component.floating</code> Components after
   * they have been rendered.
   * <p>A reference to the ZIndexManager which is managing this Component's z-index.</p>
   * <p>The →<code>ext.ZIndexManager</code> maintains a stack of floating Component
   * z-indices, and also provides a single modal mask which is insert just beneath the topmost
   * visible modal floating Component.</p>
   * <p>Floating Components may be <i>brought to the front</i> (→<code>ext.Component.toFront()</code>) or
   * <i>sent to the back</i> (→<code>ext.Component.toBack()</code>) of the z-index stack.</p>
   * <p>This defaults to the global <i>ZIndexManager</i> (→<code>ext.WindowManager</code>) for floating Components
   * that are programatically <i>rendered</i> (→<code>ext.Component.render()</code>).</p>
   * <p>For →<code>ext.Component.floating</code> Components that are added to a
   * Container, the ZIndexManager is acquired from the first ancestor Container found
   * that is floating. If no floating ancestor is found, the global
   * <i>ZIndexManager</i> (→<code>ext.WindowManager</code>) is used.</p>
   * <p>See →<code>ext.Component.floating</code> and →<code>zIndexParent</code></p>
   * @see ext.Component#floating
   * @see ext.ZIndexManager
   * @see ext.Component#toFront()
   * @see ext.Component#toBack()
   * @see ext.#WindowManager ext.WindowManager
   * @see ext.Component#render()
   * @see #zIndexParent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#property-zIndexManager Original Ext JS documentation of 'zIndexManager'
   */
  function get zIndexManager():ZIndexManager;

  /**
   * Only present for →<code>ext.Component.floating</code> Components which were
   * inserted as child items of Containers, and which have a floating Container in
   * their containment ancestry.
   * <p>For →<code>ext.Component.floating</code> Components which are child items of a
   * Container, the zIndexParent will be a floating ancestor Container which is
   * responsible for the base z-index value of all its floating descendants. It
   * provides a →<code>ext.ZIndexManager</code> which provides z-indexing
   * services for all its descendant floating Components.</p>
   * <p>Floating Components that are programmatically <i>rendered</i> (→<code>ext.Component.render()</code>)
   * will not have a <code>→zIndexParent</code> property.</p>
   * <p>For example, the dropdown →<code>ext.view.BoundListView</code> of a ComboBox which is
   * in a Window will have the Window as its <code>→zIndexParent</code>, and will always show above
   * that Window, wherever the Window is placed in the z-index stack.</p>
   * <p>See →<code>ext.Component.floating</code> and →<code>zIndexManager</code></p>
   * @see ext.Component#floating
   * @see ext.ZIndexManager
   * @see ext.Component#render()
   * @see #zIndexParent
   * @see ext.view.BoundListView
   * @see #zIndexManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#property-zIndexParent Original Ext JS documentation of 'zIndexParent'
   */
  function get zIndexParent():Container;

  /**
   * Center this Component in its container.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#method-center Original Ext JS documentation of 'center'
   */
  function center():Component;

  /**
   * Moves this floating Component into a constrain region.
   * <p>By default, this Component is constrained to be within the container it was added to,
   * or the element it was rendered to.</p>
   * <p>An alternative constraint may be passed.</p>
   * @param constrainTo The Element
   * or →<code>ext.util.Region</code> into which this Component is to be constrained.
   * Defaults to the element into which this floating Component was rendered.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#method-doConstrain Original Ext JS documentation of 'doConstrain'
   * @see ext.util.Region
   */
  function doConstrain(constrainTo:* = undefined):void;

  /**
   * Returns the value of <code>alwaysOnTop</code>.
   * @see #alwaysOnTop
   */
  function getAlwaysOnTop():*;

  /**
   * Sets the value of <code>alwaysOnTop</code>.
   * @param alwaysOnTop The new value.
   * @see #alwaysOnTop
   */
  function setAlwaysOnTop(alwaysOnTop:*):void;

  /**
   * Sends this Component to the back of (lower z-index than) any other visible windows
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#method-toBack Original Ext JS documentation of 'toBack'
   */
  function toBack():Component;

  /**
   * Brings this floating Component to the front of any other visible, floating Components
   * managed by the same →<code>ext.ZIndexManager</code>
   * <p>If this Component is modal, inserts the modal mask just below this Component
   * in the z-index stack.</p>
   * @param preventFocus Specify <code>true</code> to prevent the Component
   * from being focused.
   * @default false
   * @return this
   * @see ext.ZIndexManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#method-toFront Original Ext JS documentation of 'toFront'
   */
  function toFront(preventFocus:Boolean = false):Component;
}
}