package ext.util {
import ext.data.AbstractStore;
import ext.data.Store;

[Mixin("ext.util.StoreHolder")]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>This class is used as a mixin.</p>
 * <p>This class is to be used to provide basic methods for binding/unbinding stores to other
 * classes.</p>
 * <p>This class is not intended for direct use but rather internally by those classes that
 * manage a Store.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html Original Ext JS documentation of 'Ext.util.StoreHolder'
 * @see ext.util.StoreHolder
 */
public interface IStoreHolder {
  /**
   * This property allows the object
   * to destroy bound stores that have →<code>ext.data.AbstractStore.autoDestroy</code>
   * option set to <code>true</code>.
   * @default false
   * @see ext.data.AbstractStore#autoDestroy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#property-autoDestroyBoundStore Original Ext JS documentation of 'autoDestroyBoundStore'
   */
  function get autoDestroyBoundStore():Boolean;

  function set autoDestroyBoundStore(value:Boolean):void;

  /**
   * Binds a store to this instance.
   * @param store The store to bind or ID of the store.
   * When no store given (or when <code>null</code> or <code>undefined</code> passed), unbinds the existing store.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-bindStore Original Ext JS documentation of 'bindStore'
   */
  function bindStore(store:Store = undefined, initial:Boolean = undefined, propertyName:* = undefined):void;

  /**
   * Gets the current store instance.
   * @return The store, null if one does not exist.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-getStore Original Ext JS documentation of 'getStore'
   */
  function getStore():AbstractStore;

  /**
   * Sets the store to the specified store.
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-setStore Original Ext JS documentation of 'setStore'
   */
  function setStore(store:Object):void;
}
}