package ext.util {

[Native("Ext.util.Inflector", require)]
/**
 * General purpose inflector class that <i>pluralizes</i> (→<code>pluralize()</code>),
 * <i>singularizes</i> (→<code>singularize()</code>) and <i>ordinalizes</i> (→<code>ordinalize()</code>) words. Sample usage:
 * <pre>
 * //turning singular words into plurals
 * Ext.util.Inflector.pluralize('word'); //'words'
 * Ext.util.Inflector.pluralize('person'); //'people'
 * Ext.util.Inflector.pluralize('sheep'); //'sheep'
 *
 * //turning plurals into singulars
 * Ext.util.Inflector.singularize('words'); //'word'
 * Ext.util.Inflector.singularize('people'); //'person'
 * Ext.util.Inflector.singularize('sheep'); //'sheep'
 *
 * //ordinalizing numbers
 * Ext.util.Inflector.ordinalize(11); //"11th"
 * Ext.util.Inflector.ordinalize(21); //"21st"
 * Ext.util.Inflector.ordinalize(1043); //"1043rd"
 * </pre>
 * <p><b>Customization</b></p>
 * <p>The Inflector comes with a default set of US English pluralization rules. These can be augmented
 * with additional rules if the default rules do not meet your application's requirements,
 * or swapped out entirely for other languages. Here is how we might add a rule that pluralizes
 * "ox" to "oxen":</p>
 * <pre>
 * Ext.util.Inflector.plural(/^(ox)$/i, "$1en");
 * </pre>
 * <p>Each rule consists of two items - a regular expression that matches one or more rules,
 * and a replacement string. In this case, the regular expression will only match the string "ox",
 * and will replace that match with "oxen". Here's how we could add the inverse rule:</p>
 * <pre>
 * Ext.util.Inflector.singular(/^(ox)en$/i, "$1");
 * </pre>
 * <p>Note that the ox/oxen rules are present by default.</p>
 * @see SInflector#pluralize()
 * @see SInflector#singularize()
 * @see SInflector#ordinalize()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Inflector.html Original Ext JS documentation of 'Ext.util.Inflector'
 */
public const Inflector:SInflector = new SInflector;
}