package ext.util {
import ext.Base;
import ext.event.Event;

[Native("Ext.util.KeyNav", require)]
/**
 * Provides a convenient wrapper for normalized keyboard navigation. KeyNav allows you to bind
 * navigation keys to function calls that will get called when the keys are pressed, providing
 * an easy way to implement custom navigation schemes for any UI component.
 * <p>The following are all of the possible keys that can be implemented: Enter, Space, Left, Right,
 * Up, Down, Tab, Esc, Page Up, Page Down, Delete, Backspace, Home, End.</p>
 * <p>Usage:</p>
 * <pre>
 *  var nav = new Ext.util.KeyNav({
 *      target: "my-element",
 *
 *      left: function(e) {
 *          this.moveLeft(e.ctrlKey);
 *      },
 *      right: function(e) {
 *          this.moveRight(e.ctrlKey);
 *      },
 *      enter: function(e) {
 *          this.save();
 *      },
 *
 *      // Binding may be a function specifiying fn, scope and defaultEventAction
 *      esc: {
 *          fn: this.onEsc,
 *          defaultEventAction: false
 *      },
 *
 *      // Binding may be keyed by a single character
 *      A: {
 *          ctrl: true,
 *          fn: selectAll
 *      },
 *
 *      // Binding may be keyed by a key code (45 = INSERT)
 *      45: {
 *          fn: doInsert
 *      },
 *
 *      scope: myObject
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html Original Ext JS documentation of 'Ext.util.KeyNav'
 */
public class KeyNav extends Base {
  /**
   * @param config @inheritDoc
   */
  public function KeyNav(config:KeyNav = null) {
    super();
  }

  [ExtConfig]
  /**
   * The method to call on the →<code>ext.event.Event</code> after this KeyNav intercepts a key.
   * Valid values are →<code>ext.event.Event.stopEvent()</code>, →<code>ext.event.Event.preventDefault()</code>
   * and →<code>ext.event.Event.stopPropagation()</code>.
   * <p>If a falsy value is specified, no method is called on the key event.</p>
   * @default false
   * @see ext.event.Event
   * @see ext.event.Event#stopEvent()
   * @see ext.event.Event#preventDefault()
   * @see ext.event.Event#stopPropagation()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#cfg-defaultEventAction Original Ext JS documentation of 'defaultEventAction'
   */
  public native function get defaultEventAction():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultEventAction(value:String):void;

  [ExtConfig]
  /**
   * True to disable this KeyNav instance.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#cfg-disabled Original Ext JS documentation of 'disabled'
   * @see #setDisabled()
   */
  public native function get disabled():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set disabled(value:Boolean):void;

  [ExtConfig]
  /**
   * The event to listen for to pick up key events.
   * @default 'keypress'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#cfg-eventName Original Ext JS documentation of 'eventName'
   */
  public native function get eventName():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set eventName(value:String):void;

  [ExtConfig]
  /**
   * Handle the keydown event instead of keypress. KeyNav automatically does this for IE
   * since IE does not propagate special keys on keypress, but setting this to true will force
   * other browsers to also handle keydown instead of keypress.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#cfg-forceKeyDown Original Ext JS documentation of 'forceKeyDown'
   */
  public native function get forceKeyDown():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set forceKeyDown(value:Boolean):void;

  [ExtConfig]
  /**
   * Configure this as <code>true</code> if there are any input fields within the →<code>target</code>, and this
   * KeyNav should not process events from input fields (<code>&lt;input&gt;</code>, <code>&lt;textarea&gt;</code> and elements
   * with <code>contentEditable="true"</code>)
   * @default false
   * @see #target
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#cfg-ignoreInputFields Original Ext JS documentation of 'ignoreInputFields'
   */
  public native function get ignoreInputFields():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ignoreInputFields(value:Boolean):void;

  [ExtConfig]
  /**
   * An optional pre-existing →<code>ext.util.KeyMap</code> to use to listen for key events.
   * If not specified, one is created.
   * @see ext.util.KeyMap
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#cfg-keyMap Original Ext JS documentation of 'keyMap'
   */
  public native function get keyMap():KeyMap;

  [ExtConfig]
  /**
   * @private
   */
  public native function set keyMap(value:KeyMap):void;

  /**
   * The last key event that this KeyMap handled.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#property-lastKeyEvent Original Ext JS documentation of 'lastKeyEvent'
   */
  public native function get lastKeyEvent():Event;

  /**
   * @private
   */
  public native function set lastKeyEvent(value:Event):void;

  [ExtConfig]
  /**
   * The priority to set on this KeyNav's listener. Listeners with a higher priority are fired
   * before those with lower priority.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#cfg-priority Original Ext JS documentation of 'priority'
   */
  public native function get priority():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set priority(value:Number):void;

  [ExtConfig]
  /**
   * An optional event processor function which accepts the argument list provided by the
   * <i>configured event</i> (→<code>eventName</code>) of the →<code>target</code>, and returns a keyEvent
   * for processing by the KeyMap.
   * <p>This may be useful when the →<code>target</code> is a Component with s complex event signature.
   * Extra information from the event arguments may be injected into the event for use
   * by the handler functions before returning it.</p>
   * @see #eventName
   * @see #target
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#cfg-processEvent Original Ext JS documentation of 'processEvent'
   */
  public native function get processEvent():Function;

  [ExtConfig]
  /**
   * @private
   */
  public native function set processEvent(value:Function):void;

  [ExtConfig]
  /**
   * The scope (<code>this</code> context) in which the →<code>processEvent</code> method is executed.
   * @default this
   * @see #processEvent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#cfg-processEventScope Original Ext JS documentation of 'processEventScope'
   */
  public native function get processEventScope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set processEventScope(value:Object):void;

  [ExtConfig]
  /**
   * The object on which to listen for the event specified by the →<code>eventName</code>
   * config option.
   * @see #eventName
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#cfg-target Original Ext JS documentation of 'target'
   */
  public native function get target():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set target(value:*):void;

  /**
   * Destroy this KeyNav.
   * @param params Pass <code>true</code> to remove the element associated with this KeyNav.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Disables this KeyNav.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#method-disable Original Ext JS documentation of 'disable'
   */
  public native function disable():void;

  /**
   * Enables this KeyNav.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#method-enable Original Ext JS documentation of 'enable'
   */
  public native function enable():void;

  /**
   * Convenience function for setting disabled/enabled by boolean.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.KeyNav.html#method-setDisabled Original Ext JS documentation of 'setDisabled'
   */
  public native function setDisabled(disabled:Boolean):void;
}
}