package ext.util {
import ext.Base;

[Native("Ext.util.Memento", require)]
/**
 * This class manages a set of captured properties from an object. These captured properties
 * can later be restored to an object.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Memento.html Original Ext JS documentation of 'Ext.util.Memento'
 */
public class Memento extends Base {
  /**
   * Creates a new memento and optionally captures properties from the target object.
   * @param target The target from which to capture properties. If specified in the
   * constructor, this target becomes the default target for all other operations.
   * @param props The property or array of properties to capture.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Memento.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Memento(target:Object, props:*) {
    super();
  }

  /**
   * The default target object for capture/restore (passed to the constructor).
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Memento.html#property-target Original Ext JS documentation of 'target'
   */
  public native function get target():*;

  /**
   * @private
   */
  public native function set target(value:*):void;

  /**
   * Captures the specified properties from the target object in this memento.
   * @param props The property or array of properties to capture.
   * @param target The object from which to capture properties.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Memento.html#method-capture Original Ext JS documentation of 'capture'
   */
  public native function capture(props:*, target:Object, prefix:String):void;

  /**
   * Removes the specified properties from this memento. These properties will not be
   * restored later without re-capturing their values.
   * @param props The property or array of properties to remove.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Memento.html#method-remove Original Ext JS documentation of 'remove'
   */
  public native function remove(props:*):void;

  /**
   * Restores the specified properties from this memento to the target object.
   * @param props The property or array of properties to restore.
   * @param clear True to remove the restored properties from this memento or
   * false to keep them (default is true).
   * @param target The object to which to restore properties.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Memento.html#method-restore Original Ext JS documentation of 'restore'
   */
  public native function restore(props:*, clear:Boolean, target:Object, prefix:String):void;

  /**
   * Restores all captured properties in this memento to the target object.
   * @param clear True to remove the restored properties from this memento or
   * false to keep them (default is true).
   * @param target The object to which to restore properties.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Memento.html#method-restoreAll Original Ext JS documentation of 'restoreAll'
   */
  public native function restoreAll(clear:Boolean, target:Object):void;
}
}