package ext.util {

[Native("Ext.util.MixedCollection", require)]
/**
 * @see ext.util.events.MixedCollection_me_sortersEvent.BEFORE_SORT
 * @eventType ext.util.events.MixedCollection_me_sortersEvent.BEFORE_SORT
 */
[Event(name='onBeforeSort', type='ext.util.events.MixedCollection_me_sortersEvent')]
/**
 * Represents a collection of a set of key and value pairs. Each key in the MixedCollection
 * must be unique, the same key cannot exist twice. This collection is ordered, items in the
 * collection can be accessed by index or via the key. Newly added items are added to
 * the end of the collection. This class is similar to →<code>ext.util.HashMap</code> however it
 * is heavier and provides more functionality. Sample usage:
 * <pre>
 * var coll = new Ext.util.MixedCollection();
 * coll.add('key1', 'val1');
 * coll.add('key2', 'val2');
 * coll.add('key3', 'val3');
 *
 * console.log(coll.get('key1')); // prints 'val1'
 * console.log(coll.indexOfKey('key3')); // prints 2
 * </pre>
 * <p>The MixedCollection also has support for sorting and filtering of the values in the collection.</p>
 * <pre>
 * var coll = new Ext.util.MixedCollection();
 * coll.add('key1', 100);
 * coll.add('key2', -100);
 * coll.add('key3', 17);
 * coll.add('key4', 0);
 * var biggerThanZero = coll.filterBy(function(value){
 *     return value &gt; 0;
 * });
 * console.log(biggerThanZero.getCount()); // prints 2
 * </pre>
 * @see ext.util.HashMap
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.MixedCollection.html Original Ext JS documentation of 'Ext.util.MixedCollection'
 */
public class MixedCollection extends AbstractMixedCollection implements ISortable {
  /**
   * Creates new MixedCollection.
   * @param config A configuration object.
   * <ul>
   * <li><code>allowFunctions:Boolean</code> (default = <code>false</code>) —
   * Specify <code>true</code> if the
   * →<code>addAll()</code> function should add function references to the collection.
   * </li>
   * <li><code>getKey:Function</code> (optional) —
   * A function that can accept an item of the
   * type(s) stored in this MixedCollection and return the key value for that item.
   * This is used when available to look up the key on items that were passed without
   * an explicit key parameter to a MixedCollection method. Passing this parameter is
   * equivalent to overriding the →<code>getKey()</code> method.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.MixedCollection.html#method-constructor Original Ext JS documentation of 'constructor'
   * @see #addAll()
   * @see #getKey()
   */
  public function MixedCollection(config:MixedCollection = null) {
    super();
  }

  [ExtConfig]
  /**
   * Configure as <code>true</code> if the →<code>addAll()</code> function should add function references
   * to the collection.
   * @see #addAll()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.MixedCollection.html#cfg-allowFunctions Original Ext JS documentation of 'allowFunctions'
   */
  override public native function get allowFunctions():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set allowFunctions(value:Boolean):void;

  [ExtConfig]
  /**
   * The default sort direction to use if one is not specified.
   * @default "ASC"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sortable.html#cfg-defaultSortDirection Original Ext JS documentation of 'defaultSortDirection'
   */
  public native function get defaultSortDirection():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultSortDirection(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get isSortable():Boolean;

  /**
   * @inheritDoc
   */
  public native function set isSortable(value:Boolean):void;

  [ExtConfig]
  /**
   * The maximum number of sorters which may be applied to this Sortable when using the "multi"
   * insertion position when adding sorters.
   * <p>New sorters added using the "multi" insertion position are inserted at the top of the
   * sorters list becoming the new primary sort key.</p>
   * <p>If the sorters collection has grown to longer then <b><code>→multiSortLimit</code></b>, then it is trimmed.</p>
   * @default 3
   * @see #multiSortLimit
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sortable.html#cfg-multiSortLimit Original Ext JS documentation of 'multiSortLimit'
   */
  public native function get multiSortLimit():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set multiSortLimit(value:Number):void;

  [ExtConfig]
  /**
   * The property in each item that contains the data to sort.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sortable.html#cfg-sortRoot Original Ext JS documentation of 'sortRoot'
   */
  public native function get sortRoot():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set sortRoot(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The initial set of <i>Sorters</i> (→<code>ext.util.Sorter</code>).
   * <pre>
   * sorters: [{
   *     property: 'age',
   *     direction: 'DESC'
   * }, {
   *     property: 'firstName',
   *     direction: 'ASC'
   * }]
   * </pre>
   * @default null
   * @see ext.util.Sorter
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sortable.html#cfg-sorters Original Ext JS documentation of 'sorters'
   * @see #getSorters()
   * @see #setSorters()
   */
  public native function get sorters():Array;

  [ExtConfig]
  [Bindable]
  [ArrayElementType("ext.util.Sorter")]
  /**
   * @private
   */
  public native function set sorters(value:Array):void;

  /**
   * Calculates the insertion index of the new item based upon the comparison function passed,
   * or the current sort order.
   * @param newItem The new object to find the insertion position of.
   * @param sorterFn The function to sort by. This is the same as the sorting
   * function passed to →<code>sortBy()</code>. It accepts 2 items from this MixedCollection,
   * and returns -1 0, or 1 depending on the relative sort positions of the 2 compared items.
   * <p>If omitted, a function <i>generated</i> (→<code>generateComparator()</code>) from the currently defined
   * set of →<code>sorters</code> will be used.</p>
   * @return The insertion point to add the new item into this MixedCollection
   * at using →<code>insert()</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.MixedCollection.html#method-findInsertionIndex Original Ext JS documentation of 'findInsertionIndex'
   * @see #sortBy()
   * @see #generateComparator()
   * @see #sorters
   * @see #insert()
   */
  public native function findInsertionIndex(newItem:Object, sorterFn:Function = null):Number;

  /**
   * @inheritDoc
   */
  public native function generateComparator():void;

  /**
   * Gets the first sorter from the sorters collection, excluding
   * any groupers that may be in place
   * @return The sorter, null if none exist
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sortable.html#method-getFirstSorter Original Ext JS documentation of 'getFirstSorter'
   */
  protected native function getFirstSorter():Sorter;

  /**
   * Returns the number of Sorters which apply to this Sortable.
   * <p>May be overridden in subclasses. →<code>ext.data.Store</code> in particular overrides
   * this because its groupers must contribute to the sorter count so that the sort method above
   * executes doSort.</p>
   * @see ext.data.Store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sortable.html#method-getSorterCount Original Ext JS documentation of 'getSorterCount'
   */
  protected native function getSorterCount():uint;

  [ArrayElementType("ext.util.Sorter")]
  /**
   * Returns the value of <code>sorters</code>.
   * @see #sorters
   */
  public native function getSorters():Array;

  /**
   * Reorders each of the items based on a mapping from old index to new index. Internally this
   * just translates into a sort. The 'sort' event is fired whenever reordering has
   * occurred.
   * @param mapping Mapping from old item index to new item index
   * <pre>
   * // example of moving the last of 4 items to the front of the collection
   * // and moving each one before it forward one
   * collection.reorder({
   *     0: 1,
   *     1: 2,
   *     2: 3,
   *     3: 0,
   * });
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.MixedCollection.html#method-reorder Original Ext JS documentation of 'reorder'
   */
  override public native function reorder(mapping:Object):void;

  /**
   * Sets the value of <code>sorters</code>.
   * @param sorters The new value.
   * @see #sorters
   */
  public native function setSorters(sorters:Array):void;

  /**
   * @inheritDoc
   */
  public native function sort(sorters:* = undefined, direction:String = "ASC", insertionPosition:String = "replace", doSort:Boolean = false):Array;

  /**
   * Sorts the collection by a single sorter function
   * @param sorterFn The function to sort by
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.MixedCollection.html#method-sortBy Original Ext JS documentation of 'sortBy'
   */
  public native function sortBy(sorterFn:Function):void;

  /**
   * Sorts this collection by <b>key</b>s.
   * @param dir 'ASC' or 'DESC'. Defaults to 'ASC'.
   * @default "ASC"
   * @param fn Comparison function that defines the sort order.
   * Defaults to sorting by case insensitive string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.MixedCollection.html#method-sortByKey Original Ext JS documentation of 'sortByKey'
   */
  public native function sortByKey(dir:String = "ASC", fn:Function = null):void;
}
}