package ext.util {
import ext.Base;

[Native("Ext.util.ObjectTemplate", require)]
/**
 * This class accepts an object that serves as a template for creating new objects. Like
 * other templates (<code>→ext.XTemplate</code>) this creation step requires a context object to give
 * the template its values.
 * <p>For example:</p>
 * <pre>
 *  var tpl = new Ext.util.ObjectTemplate({
 *      property: 'Hello {name}',
 *      data: {
 *          value: '{age}'
 *      }
 *  });
 *
 *  var obj = tpl.apply({
 *      name: 'Bill',
 *      age: 42
 *  });
 *
 *  // obj = {
 *  //     property: 'Hello Bill',
 *  //     data: {
 *  //         value: 42
 *  //     }
 *  // }
 * </pre>
 * @see ext.XTemplate
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ObjectTemplate.html Original Ext JS documentation of 'Ext.util.ObjectTemplate'
 */
public class ObjectTemplate extends Base {
  /**
   * Creates an <code>ObjectTemplate</code> given a config object or instance.
   * @since 5.0.0
   * @param template The template object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ObjectTemplate.html#static-method-create Original Ext JS documentation of 'create'
   */
  public static native function create(template:*, options:Object = null):ObjectTemplate;

  /**
   * Constructs the <code>ObjectTemplate</code>. The actual compilation of the object to a ready to
   * apply form happens on the first call to <code>→apply()</code>.
   * @since 5.0.0
   * @see #apply()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ObjectTemplate.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function ObjectTemplate(template:Object, options:Object = null) {
    super();
  }

  /**
   * Applies the given <code>context</code> object to this template and returns a new object with
   * the appropriate pieces replaced.
   * @since 5.0.0
   * @param context The data used to populate the template.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ObjectTemplate.html#method-apply Original Ext JS documentation of 'apply'
   */
  public native function apply(context:Object):Object;
}
}