package ext.util {
import ext.mixin.IObservable;
import ext.mixin.Observable;

[Native("Ext.util.Observable", require)]
/**
 * A Ext.mixin.Observable subclass that is provided for backward compatibility.
 * Applications should avoid using this class, and use Ext.mixin.Observable instead.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Observable.html Original Ext JS documentation of 'Ext.util.Observable'
 */
public class Observable extends ext.mixin.Observable {
  /**
   * Starts capture on the specified Observable. All events will be passed to the supplied
   * function with the event name + standard signature of the event <b>before</b> the event
   * is fired. If the supplied function returns false, the event will not fire.
   * @param o The Observable to capture events from.
   * @param fn The function to call when an event is fired.
   * @param scope The scope (<code>this</code> reference) in which the function
   * is executed. Defaults to the Observable firing the event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Observable.html#static-method-capture Original Ext JS documentation of 'capture'
   */
  public static native function capture(o:IObservable, fn:Function, scope:Object = null):void;

  /**
   * Sets observability on the passed class constructor.
   * <p>This makes any event fired on any instance of the passed class also fire a single
   * event through the <b>class</b> allowing for central handling of events on many instances
   * at once.</p>
   * <p>Usage:</p>
   * <pre>
   * Ext.util.Observable.observe(Ext.data.Connection);
   * Ext.data.Connection.on('beforerequest', function(con, options) {
   *     console.log('Ajax request made to ' + options.url);
   * });
   * </pre>
   * @param cls The class constructor to make observable.
   * @param listeners An object containing a series of listeners to
   * add. See →<code>ext.util.Observable.addListener()</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Observable.html#static-method-observe Original Ext JS documentation of 'observe'
   * @see ext.util.Observable#addListener()
   */
  public static native function observe(cls:Class, listeners:Object = null):void;

  /**
   * Removes <b>all</b> added captures from the Observable.
   * @param o The Observable to release
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Observable.html#static-method-releaseCapture Original Ext JS documentation of 'releaseCapture'
   */
  public static native function releaseCapture(o:IObservable):void;

  /**
   * @inheritDoc
   */
  public function Observable(config:ext.mixin.Observable = null) {
    super();
  }
}
}