package ext.util {
import js.Event;

[Native("Ext.util.Point", require)]
/**
 * Represents a 2D point with x and y properties, useful for comparison and instantiation
 * from an event...
 * <pre>
 * var point = Ext.util.Point.fromEvent(e);
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html Original Ext JS documentation of 'Ext.util.Point'
 */
public class Point extends Region {
  /**
   * Returns a new point from an object that has <code>x</code> and <code>y</code> properties, if that object
   * is not an instance of →<code>ext.util.Point</code>. Otherwise, returns the given point itself.
   * @see ext.util.Point
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#static-method-from Original Ext JS documentation of 'from'
   */
  public static native function from(object:Object):Point;

  /**
   * Returns a new instance of →<code>ext.util.Point</code> based on the <code>pageX</code> / <code>pageY</code> values
   * of the given event.
   * @param e The event.
   * @see ext.util.Point
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#static-method-fromEvent Original Ext JS documentation of 'fromEvent'
   */
  public static native function fromEvent(e:Event):Point;

  /**
   * Returns a new instance of →<code>ext.util.Point</code> based on the <code>pageX</code> / <code>pageY</code> values
   * of the given touch.
   * @see ext.util.Point
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#static-method-fromTouch Original Ext JS documentation of 'fromTouch'
   */
  public static native function fromTouch(touch:Event):Point;

  /**
   * Creates point on 2D plane.
   * @param x X coordinate.
   * @default 0
   * @param y Y coordinate.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Point(x:Number = 0, y:Number = 0) {
    super(NaN, NaN, NaN, NaN);
  }

  /**
   * Copy a new instance of this point.
   * @return The new point.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone():Point;

  [Deprecated(replacement="clone", since="2.0.0")]
  /**
   * Clones this Point.
   * @return The new point.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#method-copy Original Ext JS documentation of 'copy'
   */
  override public native function copy():Region;

  /**
   * Copy the <code>x</code> and <code>y</code> values of another point / object to this point itself.
   * @param p The region to copy from.
   * @return This point.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#method-copyFrom Original Ext JS documentation of 'copyFrom'
   */
  override public native function copyFrom(p:Region):Region;

  /**
   * Compare this point and another point.
   * @param region The region to compare with
   * @return Returns whether they are equivalent.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#method-equals Original Ext JS documentation of 'equals'
   */
  override public native function equals(region:Region):Boolean;

  /**
   * Returns <code>true</code> if the passed point is within a certain distance of this point.
   * @param point The point to check with, either an instance
   * of →<code>ext.util.Point</code> or an object with <code>x</code> and <code>y</code> properties.
   * @param threshold Can be either an object with <code>x</code> and <code>y</code> properties
   * or a number.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#method-isCloseTo Original Ext JS documentation of 'isCloseTo'
   * @see ext.util.Point
   */
  public native function isCloseTo(point:*, threshold:*):Boolean;

  /**
   * Determins whether this Point contained by the passed Region, Component or element.
   * @param region The rectangle to check that this Point is within.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#method-isContainedBy Original Ext JS documentation of 'isContainedBy'
   */
  public native function isContainedBy(region:*):Boolean;

  [Deprecated(replacement="isCloseTo", since="2.0.0")]
  /**
   * Returns <code>true</code> if this point is close to another one.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#method-isWithin Original Ext JS documentation of 'isWithin'
   */
  public native function isWithin():Boolean;

  /**
   * Compare this point with another point when the <code>x</code> and <code>y</code> values of both points are rounded.
   * For example: [100.3,199.8] will equals to [100, 200].
   * @param point The point to compare with, either an instance
   * of Ext.util.Point or an object with <code>x</code> and <code>y</code> properties.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#method-roundedEquals Original Ext JS documentation of 'roundedEquals'
   */
  public native function roundedEquals(point:*):Boolean;

  /**
   * Returns a human-eye-friendly string that represents this point,
   * useful for debugging.
   * @return For example <code>Point[12,8]</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#method-toString Original Ext JS documentation of 'toString'
   */
  public native function toString():String;

  /**
   * Alias for →<code>translateBy()</code>
   * Translate this Region by the given offset amount
   * @param x Object containing the <code>x</code> and <code>y</code> properties.
   * Or the x value is using the two argument form.
   * @param y The y value unless using an Offset object.
   * @return this This Region
   * @see #translateBy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Point.html#method-translate Original Ext JS documentation of 'translate'
   */
  public native function translate(x:*, y:Number):Region;
}
}