package ext.util {
import ext.Base;

[Native("Ext.util.Region", require)]
/**
 * This class represents a rectangular region in X,Y space, and performs geometric
 * transformations or tests upon the region.
 * <p>This class may be used to compare the document regions occupied by elements.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html Original Ext JS documentation of 'Ext.util.Region'
 */
public class Region extends Base {
  /**
   * Creates a Region from a "box" Object which contains four numeric properties <code>top</code>,
   * <code>right</code>, <code>bottom</code> and <code>left</code>.
   * @param o An object with <code>top</code>, <code>right</code>, <code>bottom</code> and <code>left</code> properties.
   * @return region The Region constructed based on the passed object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#static-method-from Original Ext JS documentation of 'from'
   */
  public static native function from(o:Object):Region;

  /**
   * This function converts a legacy alignment string such as 't-b' into a
   * pair of edge, offset objects which describe the alignment points of
   * the two regions.
   * <p>So tl-br becomes {myEdge:'t', offset:0}, {otherEdge:'b', offset:100}</p>
   * <p>This not only allows more flexibility in the alignment possibilities,
   * but it also resolves any ambiguity as to which two edges are desired
   * to be adjacent if an anchor pointer is required.</p>
   * @param align The align spec, eg <code>"tl-br"</code>
   * @param rtl Pass <code>true</code> to use RTL calculations.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#static-method-getAlignInfo Original Ext JS documentation of 'getAlignInfo'
   */
  public static native function getAlignInfo(align:String, rtl:Boolean = false):void;

  /**
   * Retrieves an Ext.util.Region for a particular element.
   * @param el An element ID, htmlElement or Ext.Element
   * representing an element in the document.
   * @return region
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#static-method-getRegion Original Ext JS documentation of 'getRegion'
   */
  public static native function getRegion(el:*):Region;

  /**
   * Creates a region from the bounding sides.
   * @param top The topmost pixel of the Region.
   * @param right The rightmost pixel of the Region.
   * @param bottom The bottom pixel of the Region.
   * @param left The leftmost pixel of the Region.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Region(top:Number, right:Number, bottom:Number, left:Number) {
    super();
  }

  /**
   * Modifies the current region to be adjusted by offsets.
   * @param top Top offset
   * @param right Right offset
   * @param bottom Bottom offset
   * @param left Left offset
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-adjust Original Ext JS documentation of 'adjust'
   */
  public native function adjust(top:Number, right:Number, bottom:Number, left:Number):Region;

  /**
   * Returns the Region to which this rectangle should be moved in order to
   * have the desired alignment with the specified target while remaining within the
   * constraint.
   * <p>The <code>align</code> option can be one of these forms:</p>
   * <ul>
   * <li><b>Blank</b>: Defaults to aligning the region's top-left corner to the target's
   * bottom-left corner ("tl-bl").</li>
   * <li><b>Two anchors</b>: If two values from the table below are passed separated by a dash,
   * the first value is used as this region's anchor point, and the second value is
   * used as the target's anchor point.</li>
   * <li><b>One anchor</b>: The passed anchor position is used as the target's anchor point.
   * This region will position its top-left corner (tl) to that point.</li>
   * <li><b>Two edge/offset descriptors:</b> An edge/offset descriptor is an edge initial
   * (<code>t</code>/<code>r</code>/<code>b</code>/<code>l</code>) followed by a percentage along that side. This describes a
   * point to align with a similar point in the target. So <code>'t0-b0'</code> would be
   * the same as <code>'tl-bl'</code>, <code>'l0-r50'</code> would place the top left corner of this item
   * halfway down the right edge of the target item. This allows more flexibility
   * and also describes which two edges are considered adjacent when positioning an anchor.</li>
   * </ul>
   * <p>If the <code>inside</code> option is passed, the Region will attempt to align as specified,
   * but the position will be adjusted to constrain to the <code>inside</code> Region if necessary.
   * Note that the Region being aligned might be swapped to align to a different position
   * than that specified in order to enforce the constraints. Following are all of the
   * supported anchor positions:</p>
   * <pre>
   *  Value  Description
   *  -----  -----------------------------
   *  tl     The top left corner
   *  t      The center of the top edge
   *  tr     The top right corner
   *  l      The center of the left edge
   *  c      The center
   *  r      The center of the right edge
   *  bl     The bottom left corner
   *  b      The center of the bottom edge
   *  br     The bottom right corner
   * </pre>
   * <p>Example Usage:</p>
   * <pre>
   *  var xy = comp.getRegion().alignTo({
   *      align: 't-b',  // align comp's top/center to el's bottom/center
   *      target: el.getRegion(),
   *      anchorSize: new Ext.util.Point(10, 10),
   *      inside: new Ext.util.Region(0, Ext.Element.getViewportWidth(),
   *                                  Ext.Element.getViewportHeight(), 0)
   *  });
   * </pre>
   * @param options The alignment options.
   * <ul>
   * <li><code>target:ext.util.Region</code> (optional) —
   * The rectangle to which this rectangle
   * should align.
   * </li>
   * <li><code>align:String</code> (default = <code>tl-bl</code>) —
   * The alignment descriptor for positioning this
   * rectangle with respect to the <code>target</code>. See →<code>ext.util.Positionable.alignTo()</code>.
   * Note that if the requested alignment results in violation of the <code>inside</code> constraint,
   * the result will be flipped align to the closest edge which conforms to the constraint.
   * </li>
   * <li><code>position</code> (optional) —
   * The position at which to place the
   * resulting region before being excluded from the target area and aligned to the closest
   * edge which allows conformity with any passed <code>inside</code> option. Used instead of the <code>align</code>
   * option.
   * </li>
   * <li><code>offset</code> (optional) —
   * An offset by which to adjust the result.
   * </li>
   * <li><code>anchorSize</code> (optional) —
   * The width and height of any external
   * anchor
   * element. This is used to calculate the true bounds of the Region inclusive of the anchor.
   * The <code>x</code> dimension is the height of the arrow in all orientations, and the <code>y</code> dimension
   * is the width of the baseline of the arrow in all dimensions.
   * If this option is used, and the returned region successfully clears the
   * bounds of the target, then the anchor region will be returned in the return value
   * as the <code>anchor</code> property. This will in turn have a <code>position</code> property which will
   * be <code>'top'</code>, <code>'left</code>, <code>'right'</code>, or <code>'bottom'</code>.
   * </li>
   * <li><code>overlap:Boolean</code> (optional) —
   * Pass <code>true</code> to allow this rectangle to overlap
   * the target.
   * </li>
   * <li><code>rtl:Boolean</code> (optional) —
   * Pass <code>true</code> to swap left/right alignment.
   * </li>
   * <li><code>inside</code> (optional) —
   * The rectangle to
   * which this rectangle is constrained.
   * </li>
   * <li><code>minHeight:Number</code> (optional) —
   * Used when this Region is to be aligned directly
   * below or above the target. Gives the option to reduce the height to fit in the
   * available space.
   * </li>
   * <li><code>axisLock:Boolean</code> (optional) —
   * If <code>true</code>, then fallback on constraint violation will
   * only take place along the major align axis. That is, if <code>align: "l-r"</code> is being used, and
   * <code>axisLock: true</code> is used, then if constraints fail, only fallback to <code>r-l</code> is considered.
   * </li>
   * </ul>
   * @return The Region that will align this rectangle. Note that if
   * a <code>minHeight</code> option was passed, and alignment is either above or below the target,
   * the Region might be reduced to fit within the space.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-alignTo Original Ext JS documentation of 'alignTo'
   * @see ext.util.Positionable#alignTo()
   */
  public native function alignTo(options:Object):Region;

  /**
   * Modifies the current region to be constrained to the targetRegion.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-constrainTo Original Ext JS documentation of 'constrainTo'
   */
  public native function constrainTo(targetRegion:Region):Region;

  /**
   * Checks if this region completely contains the region or point that is passed in.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(region:*):Boolean;

  /**
   * Create a copy of this Region.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-copy Original Ext JS documentation of 'copy'
   */
  public native function copy():Region;

  /**
   * Copy the values of another Region to this Region
   * @param p The region to copy from.
   * @return This Region
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-copyFrom Original Ext JS documentation of 'copyFrom'
   */
  public native function copyFrom(p:Region):Region;

  /**
   * Check whether this region is equivalent to the given region
   * @param region The region to compare with
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-equals Original Ext JS documentation of 'equals'
   */
  public native function equals(region:Region):Boolean;

  /**
   * This method pushes the "other" Region out of this region via the shortest
   * translation. If an "inside" Region is passed, the exclusion also honours
   * that constraint.
   * @param other The Region to move so that it does not intersect this Region.
   * @param options Object of options passed to exclude.
   * <ul>
   * <li><code>inside:Object</code> (optional) —
   * A Region into which the other Region must be constrained.
   * </li>
   * <li><code>minHeight:Number</code> (optional) —
   * If passed, indicates that the height may be reduced up
   * to a point to fit the "other" region below or above the target but within the "inside"
   * Region.
   * </li>
   * <li><code>allowX:Boolean</code> (default = <code>true</code>) —
   * Pass <code>false</code> to disallow translation along the X axis.
   * </li>
   * <li><code>allowY:Boolean</code> (default = <code>true</code>) —
   * Pass <code>false</code> to disallow translation along the Y axis.
   * </li>
   * </ul>
   * @return The edge it is now aligned to, 0=top, 1=right, 2=bottom, 3=left.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-exclude Original Ext JS documentation of 'exclude'
   */
  public native function exclude(other:Object, options:Object):Number;

  /**
   * Returns the offsets of this region from the passed region or point.
   * @param offsetsTo The region or point to get get
   * the offsets from.
   * @return The XY page offsets
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The x offset
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The y offset
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-getOffsetsTo Original Ext JS documentation of 'getOffsetsTo'
   */
  public native function getOffsetsTo(offsetsTo:*):Object;

  /**
   * Get the offset amount of a point outside the region
   * @param axis
   * @param p the point
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-getOutOfBoundOffset Original Ext JS documentation of 'getOutOfBoundOffset'
   */
  public native function getOutOfBoundOffset(axis:String = null, p:Point = null):Base;

  /**
   * Get the offset amount on the x-axis
   * @param p the offset
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-getOutOfBoundOffsetX Original Ext JS documentation of 'getOutOfBoundOffsetX'
   */
  public native function getOutOfBoundOffsetX(p:Number):Number;

  /**
   * Get the offset amount on the y-axis
   * @param p the offset
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-getOutOfBoundOffsetY Original Ext JS documentation of 'getOutOfBoundOffsetY'
   */
  public native function getOutOfBoundOffsetY(p:Number):Number;

  /**
   * Checks if this region intersects the region passed in.
   * @return Returns the intersected region or false
   * if there is no intersection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-intersect Original Ext JS documentation of 'intersect'
   */
  public native function intersect(region:Region):*;

  /**
   * Check whether the point / offset is out of bound
   * @param axis
   * @param p the point / offset
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-isOutOfBound Original Ext JS documentation of 'isOutOfBound'
   */
  public native function isOutOfBound(axis:String = null, p:* = undefined):Boolean;

  /**
   * Check whether the offset is out of bound in the x-axis
   * @param p the offset
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-isOutOfBoundX Original Ext JS documentation of 'isOutOfBoundX'
   */
  public native function isOutOfBoundX(p:Number):Boolean;

  /**
   * Check whether the offset is out of bound in the y-axis
   * @param p the offset
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-isOutOfBoundY Original Ext JS documentation of 'isOutOfBoundY'
   */
  public native function isOutOfBoundY(p:Number):Boolean;

  /**
   * Round all the properties of this region
   * @return this This Region
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-round Original Ext JS documentation of 'round'
   */
  public native function round():Region;

  /**
   * Translates this Region to the specified position
   * @param x The new X position.
   * @param y The new Y position.
   * @return This region after translation.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-setPosition Original Ext JS documentation of 'setPosition'
   */
  public native function setPosition(x:Number, y:Number):Region;

  /**
   * Translate this Region by the given offset amount
   * @param x Object containing the <code>x</code> and <code>y</code> properties.
   * Or the x value is using the two argument form.
   * @param y The y value unless using an Offset object.
   * @return this This Region
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-translateBy Original Ext JS documentation of 'translateBy'
   */
  public native function translateBy(x:*, y:Number):Region;

  /**
   * Returns the smallest region that contains the current AND targetRegion.
   * @return a new region
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Region.html#method-union Original Ext JS documentation of 'union'
   */
  public native function union(region:Region):Region;
}
}