package ext.util {
import ext.Base;
import ext.dom.Element;

import js.HTMLElement;

[Native("Ext.util.Renderable", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>Given a component hierarchy of this:</p>
 * <pre>
 *  {
 *      xtype: 'panel',
 *      id: 'ContainerA',
 *      layout: 'hbox',
 *      renderTo: Ext.getBody(),
 *      items: [
 *          {
 *              id: 'ContainerB',
 *              xtype: 'container',
 *              items: [
 *                  { id: 'ComponentA' }
 *              ]
 *          }
 *      ]
 *  }
 * </pre>
 * <p>The rendering of the above proceeds roughly like this:</p>
 * <ul>
 * <li>ContainerA's initComponent calls #render passing the <code>renderTo</code> property as the
 * container argument.</li>
 * <li><code>→render()</code> calls the <code>getRenderTree</code> method to get a complete →<code>ext.dom.DomHelper</code> spec.</li>
 * <li><code>getRenderTree</code> fires the "beforerender" event and calls the #beforeRender
 * method. Its result is obtained by calling #getElConfig.</li>
 * <li>The #getElConfig method uses the <code>renderTpl</code> and its render data as the content
 * of the <code>autoEl</code> described element.</li>
 * <li>The result of <code>getRenderTree</code> is passed to →<code>ext.dom.DomHelper.append()</code>.</li>
 * <li>The <code>renderTpl</code> contains calls to render things like docked items, container items
 * and raw markup (such as the <code>html</code> or <code>tpl</code> config properties). These calls are to
 * methods added to the →<code>ext.XTemplate</code> instance by #setupRenderTpl.</li>
 * <li>The #setupRenderTpl method adds methods such as <code>renderItems</code>, <code>renderContent</code>, etc.
 * to the template. These are directed to "doRenderItems", "doRenderContent" etc..</li>
 * <li>The #setupRenderTpl calls traverse from components to their →<code>ext.layout.Layout</code>
 * object.</li>
 * <li>When a container is rendered, it also has a <code>renderTpl</code>. This is processed when the
 * <code>renderContainer</code> method is called in the component's <code>renderTpl</code>. This call goes to
 * Ext.layout.container.Container#doRenderContainer. This method repeats this
 * process for all components in the container.</li>
 * <li>After the top-most component's markup is generated and placed in to the DOM, the next
 * step is to link elements to their components and finish calling the component methods
 * <code>→onRender()</code> and <code>→afterRender()</code> as well as fire the corresponding events.</li>
 * <li>The first step in this is to call #finishRender. This method descends the
 * component hierarchy and calls <code>→onRender()</code> and fires the <code>→render()</code> event. These calls
 * are delivered top-down to approximate the timing of these calls/events from previous
 * versions.</li>
 * <li>During the pass, the component's <code>el</code> is set. Likewise, the <code>renderSelectors</code> and
 * <code>childEls</code> are applied to capture references to the component's elements.</li>
 * <li>These calls are also made on the →<code>ext.layout.container.ContainerLayout</code> layout to
 * capture its elements. Both of these classes use →<code>ext.util.ElementContainer</code> to
 * handle <code>childEls</code> processing.</li>
 * </ul>
 * @see #render()
 * @see ext.dom.#DomHelper ext.dom.DomHelper
 * @see ext.dom.SDomHelper#append() ext.dom.DomHelper.append()
 * @see ext.XTemplate
 * @see ext.layout.Layout
 * @see #onRender()
 * @see #afterRender()
 * @see ext.layout.container.ContainerLayout
 * @see ext.util.ElementContainer
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html Original Ext JS documentation of 'Ext.util.Renderable'
 */
public class Renderable extends Base implements IRenderable {
  /**
   * Allows additional behavior after rendering is complete. At this stage, the
   * <i>Component's</i> (→<code>ext.Component</code>) <i>Element</i> (→<code>ext.Component.getEl()</code>) will have
   * been styled according to the configuration, will have had any configured CSS
   * class names added, and will be in the configured visibility and configured enable
   * state.
   * <p><b>Note:</b> If the Component has a <i>ViewController</i> (→<code>ext.Component.controller</code>)
   * and the controller has an →<code>ext.app.ViewController.afterRender()</code>
   * method it will be called passing the Component as the single param.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see ext.Component
   * @see ext.Component#getEl()
   * @see ext.Component#controller
   * @see ext.app.ViewController#afterRender()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html#method-afterRender Original Ext JS documentation of 'afterRender'
   */
  protected native function afterRender():void;

  /**
   * Allows additional behavior before rendering.
   * <p><b>Note:</b> If the Component has a <i>ViewController</i> (→<code>ext.Component.controller</code>)
   * and the controller has a →<code>ext.app.ViewController.beforeRender()</code>
   * method it will be called passing the Component as the single param.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see ext.Component#controller
   * @see ext.app.ViewController#beforeRender()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html#method-beforeRender Original Ext JS documentation of 'beforeRender'
   */
  protected native function beforeRender():void;

  /**
   * Ensures that this component is attached to <code>document.body</code>. If the component was
   * rendered to →<code>ext.Ext.getDetachedBody()</code>, then it will be appended to <code>document.body</code>.
   * Any configured position is also restored.
   * @param runLayout True to run the component's layout.
   * @default false
   * @see ext.SExt#getDetachedBody() ext.Ext.getDetachedBody()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html#method-ensureAttachedToBody Original Ext JS documentation of 'ensureAttachedToBody'
   */
  public native function ensureAttachedToBody(runLayout:Boolean = false):void;

  /**
   * This function takes the position argument passed to onRender and returns a
   * DOM element that you can use in the insertBefore.
   * @param position Index, element id
   * or element you want to put this component before.
   * @return DOM element that you can use in the insertBefore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html#method-getInsertPosition Original Ext JS documentation of 'getInsertPosition'
   */
  public native function getInsertPosition(position:*):HTMLElement;

  /**
   * Initialized the renderData to be used when rendering the renderTpl.
   * @return Object with keys and values that are going to be applied to the renderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html#method-initRenderData Original Ext JS documentation of 'initRenderData'
   */
  protected native function initRenderData():Object;

  /**
   * Template method called when this Component's DOM structure is created.
   * <p>At this point, this Component's (and all descendants') DOM structure <i>exists</i> but it has not
   * been layed out (positioned and sized).</p>
   * <p>Subclasses which override this to gain access to the structure at render time should
   * call the parent class's method before attempting to access any child elements of the
   * Component.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param parentNode The parent Element in which this Component's
   * encapsulating element is contained.
   * @param containerIdx The index within the parent Container's child collection
   * of this Component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html#method-onRender Original Ext JS documentation of 'onRender'
   */
  protected native function onRender(parentNode:Element, containerIdx:Number):void;

  /**
   * Renders the Component into the passed HTML element.
   * <p><b>If you are using a →<code>ext.container.Container</code> object to house this
   * Component, then do not use the render method.</b></p>
   * <p>A Container's child Components are rendered by that Container's
   * →<code>ext.container.Container.layout</code> manager when the Container is first rendered.</p>
   * <p>When creating complex UIs, it is important to remember that sizing and positioning
   * of child items is the responsibility of the Container's
   * →<code>ext.container.Container.layout</code> manager. If you expect child items to be sized
   * in response to user interactions, you must configure the Container with a layout manager
   * which creates and manages the type of layout you have in mind.</p>
   * <p><b>Omitting the Container's →<code>ext.container.Container.layout</code> config means that a basic
   * layout manager is used which does nothing but render child components sequentially into the
   * Container. No sizing or positioning will be performed in this situation.</b></p>
   * @param container The element this Component should be
   * rendered into. If it is being created from existing markup, this should be omitted.
   * @param position The element ID or DOM node index within the container
   * <b>before</b> which this component will be inserted (defaults to appending to the end
   * of the container)
   * @see ext.container.Container
   * @see ext.container.Container#layout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html#method-render Original Ext JS documentation of 'render'
   */
  public native function render(container:* = undefined, position:* = undefined):void;
}
}