package ext.util {
import ext.Base;

[Native]
/**
 * Base64 is a group of similar binary-to-text encoding schemes that represent binary data
 * in an ASCII string format by translating it into a radix-64 representation.
 * <p>This class is an implementation of base64 encoding and decoding functions and is UTF-8 safe.</p>
 * <p>Type of singleton Base64.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Base64.html Original Ext JS documentation of 'Ext.util.Base64'
 * @see ext.util.#Base64 ext.util.Base64
 */
public class SBase64 extends Base {
  /**
   * Decodes given base64 formatted string
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Base64.html#method-decode Original Ext JS documentation of 'decode'
   */
  public native function decode(input:*):String;

  /**
   * Encodes given string in to base64 formatted string
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Base64.html#method-encode Original Ext JS documentation of 'encode'
   */
  public native function encode(input:*):String;
}
}