package ext.util {
import ext.Base;

[Native]
/**
 * Utility class for manipulating CSS rules
 * <p>Type of singleton CSS.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CSS.html Original Ext JS documentation of 'Ext.util.CSS'
 * @see ext.util.#CSS ext.util.CSS
 */
public class SCSS extends Base {
  /**
   * Creates a rule.
   * @param styleSheet The StyleSheet to create the rule in as returned
   * from →<code>createStyleSheet()</code>.
   * @param selector The selector to target the rule.
   * @param cssText The cssText specification e.g.
   * <code>"color:red;font-weight:bold;text-decoration:underline"</code>
   * @return The created rule
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CSS.html#method-createRule Original Ext JS documentation of 'createRule'
   * @see SCSS#createStyleSheet()
   */
  public native function createRule(styleSheet:Object, selector:String, cssText:String):Object;

  /**
   * Creates a stylesheet from a text blob of rules.
   * These rules will be wrapped in a STYLE tag and appended to the HEAD of the document.
   * @param cssText The text containing the css rules
   * @param id An id to add to the stylesheet for later removal
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CSS.html#method-createStyleSheet Original Ext JS documentation of 'createStyleSheet'
   */
  public native function createStyleSheet(cssText:String, id:String):Object;

  /**
   * Gets an an individual CSS rule by selector(s)
   * @param selector The CSS selector or an array of selectors to try.
   * The first selector that is found is returned.
   * @param refreshCache true to refresh the internal cache if you have recently
   * updated any rules or added styles dynamically
   * @param rawCache The CSS rule or null if one is not found
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CSS.html#method-getRule Original Ext JS documentation of 'getRule'
   */
  public native function getRule(selector:*, refreshCache:Boolean, rawCache:*):void;

  /**
   * Gets all css rules for the document
   * @param refreshCache true to refresh the internal cache
   * @return An object (hash) of rules indexed by selector
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CSS.html#method-getRules Original Ext JS documentation of 'getRules'
   */
  public native function getRules(refreshCache:Boolean):Object;

  /**
   * Refresh the rule cache if you have dynamically added stylesheets
   * @return An object (hash) of rules indexed by selector
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CSS.html#method-refreshCache Original Ext JS documentation of 'refreshCache'
   */
  public native function refreshCache():Object;

  /**
   * Removes a style or link tag by id
   * @param stylesheet The id of the style tag, or the CSSStyleSheet
   * reference to remove
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CSS.html#method-removeStyleSheet Original Ext JS documentation of 'removeStyleSheet'
   */
  public native function removeStyleSheet(stylesheet:*):void;

  /**
   * Dynamically swaps an existing stylesheet reference for a new one
   * @param id The id of an existing link tag to remove
   * @param url The href of the new stylesheet to include
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CSS.html#method-swapStyleSheet Original Ext JS documentation of 'swapStyleSheet'
   */
  public native function swapStyleSheet(id:String, url:String):void;

  /**
   * Updates a rule property
   * @param selector If it's an array it tries each selector until
   * it finds one. Stops immediately once one is found.
   * @param property The css property or a cssText specification e.g.
   * <code>"color:red;font-weight:bold;text-decoration:underline"</code>
   * @param value The new value for the property
   * @return true If a rule was found and updated
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.CSS.html#method-updateRule Original Ext JS documentation of 'updateRule'
   */
  public native function updateRule(selector:*, property:String, value:String):Boolean;
}
}