package ext.util {
import ext.Base;

[Native]
/**
 * Utility class for setting/reading values from browser cookies.
 * Values can be written using the →<code>set()</code> method.
 * Values can be read using the →<code>get()</code> method.
 * A cookie can be invalidated on the client machine using the →<code>clear()</code> method.
 * <p>Type of singleton Cookies.</p>
 * @see SCookies#set()
 * @see SCookies#get()
 * @see SCookies#clear()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Cookies.html Original Ext JS documentation of 'Ext.util.Cookies'
 * @see ext.util.#Cookies ext.util.Cookies
 */
public class SCookies extends Base {
  /**
   * Removes a cookie with the provided name from the browser
   * if found by setting its expiration date to sometime in the past.
   * @param name The name of the cookie to remove
   * @param path The path for the cookie.
   * This must be included if you included a path while setting the cookie.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Cookies.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear(name:String, path:String = null):void;

  /**
   * Retrieves cookies that are accessible by the current page. If a cookie does not exist,
   * <code>get()</code> returns null. The following example retrieves the cookie called "valid" and stores
   * the String value in the variable validStatus.
   * <pre>
   * var validStatus = Ext.util.Cookies.get("valid");
   * </pre>
   * @param name The name of the cookie to get
   * @return Returns the cookie value for the specified name;
   * null if the cookie name does not exist.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Cookies.html#method-get Original Ext JS documentation of 'get'
   */
  public native function get(name:String):Object;

  /**
   * Creates a cookie with the specified name and value. Additional settings for the cookie
   * may be optionally specified (for example: expiration, access restriction, SSL).
   * @param name The name of the cookie to set.
   * @param value The value to set for the cookie.
   * @param expires Specify an expiration date the cookie is to persist until.
   * Note that the specified Date object will be converted to Greenwich Mean Time (GMT).
   * @param path Setting a path on the cookie restricts access to pages that match
   * that path. Defaults to all pages ('/').
   * @param domain Setting a domain restricts access to pages on a given domain
   * (typically used to allow cookie access across subdomains). For example, "sencha.com"
   * will create a cookie that can be accessed from any subdomain of sencha.com, including
   * www.sencha.com, support.sencha.com, etc.
   * @param secure Specify true to indicate that the cookie should only be accessible
   * via SSL on a page using the HTTPS protocol. Defaults to false. Note that this will only work
   * if the page calling this code uses the HTTPS protocol, otherwise the cookie will be created
   * with default options.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Cookies.html#method-set Original Ext JS documentation of 'set'
   */
  public native function set(name:String, value:Object, expires:Object = null, path:String = null, domain:String = null, secure:Boolean = false):void;
}
}