package ext.util {
import ext.mixin.Observable;

[Native]
/**
 * @see ext.util.events.History_tokenEvent.CHANGE
 * @eventType ext.util.events.History_tokenEvent.CHANGE
 */
[Event(name='onChange', type='ext.util.events.History_tokenEvent')]
/**
 * @see ext.util.events.HistoryEvent.READY
 * @eventType ext.util.events.HistoryEvent.READY
 */
[Event(name='onReady', type='ext.util.events.HistoryEvent')]
/**
 * History management component that allows you to register arbitrary tokens that signify
 * application history state on navigation actions. You can then handle the history
 * →<code>event:onChange</code> event in order to reset your application UI to the appropriate state when
 * the user navigates forward or backward through the browser history stack.
 * <p><b><i>Initializing</i></b></p>
 * <p>The →<code>init()</code> method of the History object must be called before using History. This sets up
 * the internal state and must be the first thing called before using History.</p>
 * <p>Type of singleton History.</p>
 * @see SHistory#event:onChange
 * @see SHistory#init()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.History.html Original Ext JS documentation of 'Ext.util.History'
 * @see ext.util.#History ext.util.History
 */
public class SHistory extends ext.mixin.Observable {
  /**
   * @inheritDoc
   */
  public function SHistory(config:ext.mixin.Observable = null) {
    super();
  }

  /**
   * If set to <code>true</code>, when a hash is set, the hash will be prefixed
   * with an exclamation making it a hash bang instead of just a hash.
   * <pre>
   * Ext.util.History.add('foo'); // will result in #foo
   *
   * Ext.util.History.hashbang = true;
   * Ext.util.History.add('bar'); // will result in #!bar
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.History.html#property-hashbang Original Ext JS documentation of 'hashbang'
   */
  public native function get hashbang():Boolean;

  /**
   * @private
   */
  public native function set hashbang(value:Boolean):void;

  /**
   * True to use <code>window.top.location.hash</code> or false to use <code>window.location.hash</code>. Must be set
   * before →<code>init()</code> is called because the <code>hashchange</code> event listener is added to the window
   * at initialization time.
   * @default false
   * @see SHistory#init()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.History.html#property-useTopWindow Original Ext JS documentation of 'useTopWindow'
   */
  public native function get useTopWindow():*;

  /**
   * @private
   */
  public native function set useTopWindow(value:*):void;

  /**
   * Add a new token to the history stack. This can be any arbitrary value, although it would
   * commonly be the concatenation of a component id and another id marking the specific history
   * state of that component. Example usage:
   * <pre>
   * // Handle tab changes on a TabPanel
   * tabPanel.on('tabchange', function(tabPanel, tab){
   *      Ext.History.add(tabPanel.id + ':' + tab.id);
   * });
   * </pre>
   * @param token The value that defines a particular application-specific history state
   * @param preventDuplicates When true, if the passed token matches the current
   * token it will not save a new history step. Set to false if the same state can be saved more
   * than once at the same history stack location.
   * @default true
   * @return Whether the token was set in the case if the current token matches
   * the token passed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.History.html#method-add Original Ext JS documentation of 'add'
   */
  public native function add(token:String, preventDuplicates:Boolean = true):Boolean;

  /**
   * Programmatically steps back one step in browser history (equivalent to the user pressing
   * the Back button).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.History.html#method-back Original Ext JS documentation of 'back'
   */
  public native function back():void;

  /**
   * Programmatically steps forward one step in browser history (equivalent to the user pressing
   * the Forward button).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.History.html#method-forward Original Ext JS documentation of 'forward'
   */
  public native function forward():void;

  /**
   * Retrieves the currently-active history token.
   * @return The token
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.History.html#method-getToken Original Ext JS documentation of 'getToken'
   */
  public native function getToken():String;

  /**
   * Initializes the global History instance.
   * @param onReady A callback function that will be called once the history
   * component is fully initialized.
   * @param scope The scope (<code>this</code> reference) in which the callback is executed.
   * Defaults to the browser window.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.History.html#method-init Original Ext JS documentation of 'init'
   */
  public native function init(onReady:Function = null, scope:Object = null):void;

  /**
   * Replaces the current resource in history.
   * @param token The value that will replace the current resource in the history state.
   * @param preventDuplicates When <code>true</code>, if the passed token matches
   * the current token it will not save a new history step. Set to <code>false</code> if the same state
   * can be saved more than once at the same history stack location.
   * @default true
   * @return Whether the token was set in the case if the current token matches
   * the token passed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.History.html#method-replace Original Ext JS documentation of 'replace'
   */
  public native function replace(token:String, preventDuplicates:Boolean = true):Boolean;
}
}