package ext.util {
import ext.Base;

[Native("Ext.util.Schedulable", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>This is a base class for objects that can be managed by <code>→null</code>.</p>
 * @see null
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Schedulable.html Original Ext JS documentation of 'Ext.util.Schedulable'
 */
public class Schedulable extends Base {
  /**
   * This method should be overridden by items that have dependencies to insert. The
   * standard form would be:
   * <pre>
   *  sort: function () {
   *      this.getScheduler().sortItems(this.dependencies);
   *  }
   * </pre>
   * <p>This example assumes the item has a "dependencies" array to pass to the scheduler.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Schedulable.html#method-sort Original Ext JS documentation of 'sort'
   */
  public native function sort():void;
}
}