package ext.util {
import ext.Base;

[Native("Ext.util.Sorter", require)]
/**
 * Represents a single sorter that can be used as part of the sorters configuration in
 * Ext.mixin.Sortable.
 * <p>A common place for Sorters to be used are <i>Stores</i> (→<code>ext.data.Store</code>). For example:</p>
 * <p><b>Example:</b></p>
 * <pre>
 *  var store = Ext.create('Ext.data.Store', {
 *       fields: ['firstName', 'level'],
 *       sorters: 'level',
 *
 *       data: [
 *           { firstName: 'Mitch',  level: 9000},
 *           { firstName: 'Seth',   level: 42},
 *           { firstName: 'Fred',   level: 510},
 *           { firstName: 'Israel', level: 690},
 *           { firstName: 'Greg',   level: 101},
 *           { firstName: 'Pat',    level: 0},
 *           { firstName: 'Kevin',  level: 17},
 *           { firstName: 'Brandon',level: 690},
 *           { firstName: 'Gary',   level: 409},
 *           { firstName: 'Scott',  level: 789}
 *       ]
 *    });
 *
 *    Ext.create('Ext.grid.Panel', {
 *        title: 'Support',
 *        store: store,
 *        columns: [
 *            { text: 'Name',  dataIndex: 'firstName' },
 *            { text: 'Level', dataIndex: 'level' }
 *        ],
 *        height: 300,
 *        width: 200,
 *        renderTo: Ext.getBody()
 *    });
 * </pre>
 * <p>In the next example, we specify a custom sorter function:</p>
 * <p><b>Example:</b></p>
 * <pre>
 *    var store = Ext.create('Ext.data.Store', {
 *       fields: ['firstName', 'spiritAnimal'],
 *        sorters: [
 *            {
 *                // Sort by first letter of second word of spirit animal, in
 *                // descending order
 *                sorterFn: function(record1, record2) {
 *                    var name1 = record1.data.spiritAnimal.split(' ')[1].substr(0,1),
 *                        name2 = record2.data.spiritAnimal.split(' ')[1].substr(0,1);
 *
 *                    return name1 &gt; name2 ? 1 : (name1 === name2) ? 0 : -1;
 *                },
 *                direction: 'DESC'
 *            }
 *        ],
 *
 *       data: [
 *           { firstName: 'Mitch',  spiritAnimal: "Panda Bear"},
 *           { firstName: 'Seth',   spiritAnimal: "Rascally Rabbit"},
 *           { firstName: 'Fred',   spiritAnimal: "Honey Badger"},
 *           { firstName: 'Israel', spiritAnimal: "Mysterious Capybara"},
 *           { firstName: 'Greg',   spiritAnimal: "Majestic Platypus"},
 *           { firstName: 'Kevin',  spiritAnimal: "Sparkling Unicorn"},
 *           { firstName: 'Brandon',spiritAnimal: "Pygmy Goat"},
 *           { firstName: 'Gary',   spiritAnimal: "Suri Alpaca"},
 *           { firstName: 'Scott',  spiritAnimal: "Ripe Armadillo"},
 *           { firstName: 'Pat',    spiritAnimal: "Wiley Coyote"}
 *       ]
 *    });
 *
 *    Ext.create('Ext.grid.Panel', {
 *        title: 'Support',
 *        store: store,
 *        columns: [
 *            { text: 'Name',          dataIndex: 'firstName' },
 *            { text: 'Spirit Animal', dataIndex: 'spiritAnimal', flex: 1 }
 *        ],
 *        height: 310,
 *        renderTo: Ext.getBody()
 *    });
 * </pre>
 * @see ext.data.Store
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sorter.html Original Ext JS documentation of 'Ext.util.Sorter'
 */
public class Sorter extends Base {
  /**
   * Creates a comparator function (a function that can be passed to <code>Array.sort</code>)
   * given one or more <code>Sorter</code> instances.
   * <p>The returned function retains a reference to the collection or array of sorters
   * passed. This means the function will produce a comparison based on the current
   * content of the collection or array, and not based on the content at the time of
   * this call.</p>
   * @param sorters The <code>Sorter</code> instances.
   * @param nextFn The next comparator function to call if all the <code>sorters</code> end
   * with equality.
   * @return The comparator function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sorter.html#static-method-createComparator Original Ext JS documentation of 'createComparator'
   */
  public static native function createComparator(sorters:*, nextFn:* = undefined):Function;

  /**
   * @param config @inheritDoc
   */
  public function Sorter(config:Sorter = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The direction to sort by. Valid values are "ASC", and "DESC".
   * @default "ASC"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sorter.html#cfg-direction Original Ext JS documentation of 'direction'
   * @see #getDirection()
   * @see #setDirection()
   */
  public native function get direction():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set direction(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * An optional id this sorter can be keyed by in Collections. If
   * no id is specified it will use the property name used in this Sorter. If no
   * property is specified, e.g. when adding a custom sorter function we will generate
   * a random id.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sorter.html#cfg-id Original Ext JS documentation of 'id'
   * @see #getId()
   * @see #setId()
   */
  public native function get id():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set id(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The property to sort by. Required unless <code>→sorterFn</code> is provided
   * @see #sorterFn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sorter.html#cfg-property Original Ext JS documentation of 'property'
   * @see #getProperty()
   * @see #setProperty()
   */
  public native function get property():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set property(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Optional root property. This is mostly useful when sorting a Store,
   * in which case we set the root to 'data' to make the filter pull the →<code>property</code>
   * out of the data object of each item
   * @see #property
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sorter.html#cfg-root Original Ext JS documentation of 'root'
   * @see #getRoot()
   * @see #setRoot()
   */
  public native function get root():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set root(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A specific sorter function to execute. Can be passed instead of →<code>property</code>.
   * This function should compare the two passed arguments, returning -1, 0 or 1
   * depending on if item 1 should be sorted before, at the same level, or after
   * item 2.
   * <pre>
   * sorterFn: function(person1, person2) {
   *     return (person1.age &gt; person2.age) ? 1 : (person1.age === person2.age ? 0 : -1);
   * }
   * </pre>
   * @see #property
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sorter.html#cfg-sorterFn Original Ext JS documentation of 'sorterFn'
   * @see #getSorterFn()
   * @see #setSorterFn()
   */
  public native function get sorterFn():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set sorterFn(value:Function):void;

  [ExtConfig]
  [Bindable]
  /**
   * A function that will be run on each value before
   * it is compared in the sorter. The function will receive a single argument,
   * the value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sorter.html#cfg-transform Original Ext JS documentation of 'transform'
   * @see #getTransform()
   * @see #setTransform()
   */
  public native function get transform():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set transform(value:Function):void;

  /**
   * Returns the value of <code>direction</code>.
   * @see #direction
   */
  public native function getDirection():String;

  /**
   * Returns the value of <code>id</code>.
   * @see #id
   */
  public native function getId():*;

  /**
   * Returns the value of <code>property</code>.
   * @see #property
   */
  public native function getProperty():String;

  /**
   * Returns the value of <code>root</code>.
   * @see #root
   */
  public native function getRoot():String;

  /**
   * Returns the value of <code>sorterFn</code>.
   * @see #sorterFn
   */
  public native function getSorterFn():Function;

  /**
   * Returns this sorter's state.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sorter.html#method-getState Original Ext JS documentation of 'getState'
   */
  public native function getState():Object;

  /**
   * Returns the value of <code>transform</code>.
   * @see #transform
   */
  public native function getTransform():Function;

  /**
   * Returns this sorter's serialized state. This is used when transmitting this sorter
   * to a server.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sorter.html#method-serialize Original Ext JS documentation of 'serialize'
   */
  public native function serialize():Object;

  /**
   * Sets the value of <code>direction</code>.
   * @param direction The new value.
   * @see #direction
   */
  public native function setDirection(direction:String):void;

  /**
   * Sets the value of <code>id</code>.
   * @param id The new value.
   * @see #id
   */
  public native function setId(id:*):void;

  /**
   * Sets the value of <code>property</code>.
   * @param property The new value.
   * @see #property
   */
  public native function setProperty(property:String):void;

  /**
   * Sets the value of <code>root</code>.
   * @param root The new value.
   * @see #root
   */
  public native function setRoot(root:String):void;

  /**
   * Sets the value of <code>sorterFn</code>.
   * @param sorterFn The new value.
   * @see #sorterFn
   */
  public native function setSorterFn(sorterFn:Function):void;

  /**
   * Sets the value of <code>transform</code>.
   * @param transform The new value.
   * @see #transform
   */
  public native function setTransform(transform:Function):void;

  /**
   * Toggles the direction of this Sorter. Note that when you call this function,
   * the Collection this Sorter is part of does not get refreshed automatically.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sorter.html#method-toggle Original Ext JS documentation of 'toggle'
   */
  public native function toggle():void;
}
}