package ext.util {

[Native("Ext.util.SorterCollection", require)]
/**
 * This class provides a flexible means to control the
 * <code>→ext.util.Collection.sorters</code> of a
 * <code>→ext.util.Collection</code>. Instances of this class are created
 * automatically when sorters are added to added to Collections.
 * <p>This collection can be directly manipulated by application code to gain full
 * control over the sorters of the owner collection. Be aware that some components
 * create sorters internally (such as grids) so be careful in such cases to not disturb
 * these additional sorters.</p>
 * <p>Items in this collection are <code>→ext.util.Sorter</code> instances and can be managed
 * individually by their <code>id</code>. This is the recommended way to manage application
 * filters while preserving sorter applied from other sources.</p>
 * <p>Bulk changes to this collection should be wrapped in
 * <code>→ext.util.Collection.beginUpdate()</code> and
 * <code>→ext.util.Collection.endUpdate()</code> (as with any collection).
 * During these bulk updates all reactions to sorter changes will be suspended.</p>
 * @see ext.util.Collection#sorters
 * @see ext.util.Collection
 * @see ext.util.Sorter
 * @see ext.util.Collection#beginUpdate()
 * @see ext.util.Collection#endUpdate()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.SorterCollection.html Original Ext JS documentation of 'Ext.util.SorterCollection'
 */
public class SorterCollection extends Collection {
  /**
   * @inheritDoc
   */
  public function SorterCollection(config:Collection = null) {
    super();
  }

  /**
   * This is the cached sorting function which is a generated function that calls all the
   * configured sorters in the correct order.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.SorterCollection.html#property-sortFn Original Ext JS documentation of 'sortFn'
   */
  public native function get sortFn():*;

  /**
   * Returns an up to date sort function.
   * @return The sort function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.SorterCollection.html#method-getSortFn Original Ext JS documentation of 'getSortFn'
   */
  override public native function getSortFn():Function;
}
}