package ext.util {
import ext.Base;
import ext.data.AbstractStore;
import ext.data.Store;

[Native("Ext.util.StoreHolder", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>This class is used as a mixin.</p>
 * <p>This class is to be used to provide basic methods for binding/unbinding stores to other
 * classes.</p>
 * <p>This class is not intended for direct use but rather internally by those classes that
 * manage a Store.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html Original Ext JS documentation of 'Ext.util.StoreHolder'
 */
public class StoreHolder extends Base implements IStoreHolder {
  /**
   * This property allows the object
   * to destroy bound stores that have →<code>ext.data.AbstractStore.autoDestroy</code>
   * option set to <code>true</code>.
   * @default false
   * @see ext.data.AbstractStore#autoDestroy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#property-autoDestroyBoundStore Original Ext JS documentation of 'autoDestroyBoundStore'
   */
  public native function get autoDestroyBoundStore():Boolean;

  /**
   * @private
   */
  public native function set autoDestroyBoundStore(value:Boolean):void;

  /**
   * Binds a store to this instance.
   * @param store The store to bind or ID of the store.
   * When no store given (or when <code>null</code> or <code>undefined</code> passed), unbinds the existing store.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-bindStore Original Ext JS documentation of 'bindStore'
   */
  public native function bindStore(store:Store = undefined, initial:Boolean = undefined, propertyName:* = undefined):void;

  /**
   * Binds listeners for this component to the store. By default it will add
   * anything bound by the getStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to bind to
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-bindStoreListeners Original Ext JS documentation of 'bindStoreListeners'
   */
  protected native function bindStoreListeners(store:AbstractStore):void;

  /**
   * Gets the current store instance.
   * @return The store, null if one does not exist.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-getStore Original Ext JS documentation of 'getStore'
   */
  public native function getStore():AbstractStore;

  /**
   * Gets the listeners to bind to a new store.
   * @param store The Store which is being bound to for which a listeners object
   * should be returned.
   * @return The listeners to be bound to the store in object literal form. The scope
   * may be omitted, it is assumed to be the current instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-getStoreListeners Original Ext JS documentation of 'getStoreListeners'
   */
  protected native function getStoreListeners(store:Store):Object;

  /**
   * Template method, it is called when a new store is bound
   * to the current instance.
   * @param store The store being bound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onBindStore Original Ext JS documentation of 'onBindStore'
   */
  protected native function onBindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * Template method, it is called when an existing store is unbound
   * from the current instance.
   * @param store The store being unbound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onUnbindStore Original Ext JS documentation of 'onUnbindStore'
   */
  protected native function onUnbindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * Sets the store to the specified store.
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-setStore Original Ext JS documentation of 'setStore'
   */
  public native function setStore(store:Object):void;

  /**
   * Unbinds listeners from this component to the store. By default it will remove
   * anything bound by the bindStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to unbind from
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-unbindStoreListeners Original Ext JS documentation of 'unbindStoreListeners'
   */
  protected native function unbindStoreListeners(store:AbstractStore):void;
}
}