package ext.util {

[Native("Ext.util.TaskManager", require)]
/**
 * A static →<code>ext.util.TaskRunner</code> instance that can be used to start and stop
 * arbitrary tasks. See →<code>ext.util.TaskRunner</code> for supported methods and task
 * config properties.
 * <p><b>Example:</b></p>
 * <pre>
 * var task, clock;
 *
 * clock = Ext.getBody().appendChild({
 *     id: 'clock'
 * });
 *
 * // Start a simple clock task that updates a div once per second
 * task = {
 *     run: function() {
 *         clock.setHtml(Ext.Date.format(new Date(), 'g:i:s A'));
 *     },
 *     interval: 1000
 * };
 *
 * Ext.TaskManager.start(task);
 * </pre>
 * <p>See the →<code>start()</code> method for details about how to configure a task object.</p>
 * @see ext.util.TaskRunner
 * @see STaskManager#start()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.TaskManager.html Original Ext JS documentation of 'Ext.util.TaskManager'
 */
public const TaskManager:TaskRunner = new TaskRunner;
}