package ext.util {
import ext.Base;

[Native("Ext.util.TaskRunner.Task", require)]
/**
 * Instances of this class are created by →<code>ext.util.TaskRunner.newTask()</code> method.
 * <p>For details on config properties, see →<code>ext.util.TaskRunner.start()</code>.</p>
 * @see ext.util.TaskRunner#newTask()
 * @see ext.util.TaskRunner#start()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.TaskRunner.Task.html Original Ext JS documentation of 'Ext.util.TaskRunner.Task'
 */
public class TaskRunnerTask extends Base {
  /**
   * Destroys this instance, stopping this task's execution.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.TaskRunner.Task.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Restarts this task, clearing it duration, expiration and run count.
   * @param interval Optionally reset this task's interval.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.TaskRunner.Task.html#method-restart Original Ext JS documentation of 'restart'
   */
  public native function restart(interval:Number = NaN):void;

  /**
   * Starts this task if it is not already started.
   * @param interval Optionally reset this task's interval.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.TaskRunner.Task.html#method-start Original Ext JS documentation of 'start'
   */
  public native function start(interval:Number = NaN):void;

  /**
   * Stops this task.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.TaskRunner.Task.html#method-stop Original Ext JS documentation of 'stop'
   */
  public native function stop(andRemove:*):void;
}
}