package ext.util {

[Native("Ext.util.TsvDecoder", require)]
/**
 * This class contains utility methods for dealing with TSV (Tab Separated Values) as
 * specified in
 * <a href="https://www.iana.org/assignments/media-types/text/tab-separated-values">
 * IANA MIME type for text/tab-separated-values</a>.
 * <p>For details see <code>→ext.util.DelimitedValue</code>.</p>
 * @see ext.util.DelimitedValue
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.TsvDecoder.html Original Ext JS documentation of 'Ext.util.TsvDecoder'
 */
public class TsvDecoder extends DelimitedValue {
  /**
   * @inheritDoc
   */
  public function TsvDecoder(config:DelimitedValue = null) {
    super();
  }
}
}