package ext.util.events {
import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.util.events.AbstractMixedCollection_index_o_keyEvent")]
public class AbstractMixedCollection_index_o_keyEvent extends FlExtEvent {
  /**
   * Fires when an item is added to the collection.
   * @since 1.1.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.AbstractMixedCollection.html#event-add Original Ext JS documentation of 'add'
   * @see ext.util.AbstractMixedCollection
   * @eventType onAdd
   */
  public static const ADD:String = "onAdd";
  public static const __PARAMETER_SEQUENCE__:Array = ["index", "o", "key", "eOpts"];

  public function AbstractMixedCollection_index_o_keyEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The index at which the item was added.
   */
  public native function get index():Number;

  /**
   * The key associated with the added item.
   */
  public native function get key():String;

  /**
   * The item added.
   */
  public native function get o():Object;
}
}