package ext.util.events {
import ext.event.Event;
import ext.util.ClickRepeater;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.util.events.ClickRepeater_eEvent")]
public class ClickRepeater_eEvent extends FlExtEvent {
  /**
   * Fires on a specified interval during the time the element is pressed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#event-click Original Ext JS documentation of 'click'
   * @see ext.util.ClickRepeater
   * @eventType onClick
   */
  public static const CLICK:String = "onClick";
  /**
   * Fires when the mouse button is depressed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#event-mousedown Original Ext JS documentation of 'mousedown'
   * @see ext.util.ClickRepeater
   * @eventType onMouseDown
   */
  public static const MOUSE_DOWN:String = "onMouseDown";
  /**
   * Fires when the mouse key is released.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ClickRepeater.html#event-mouseup Original Ext JS documentation of 'mouseup'
   * @see ext.util.ClickRepeater
   * @eventType onMouseUp
   */
  public static const MOUSE_UP:String = "onMouseUp";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "e", "eOpts"];

  public function ClickRepeater_eEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get e():Event;

  public native function get source():ClickRepeater;
}
}