package ext.util.events {
import ext.util.Sortable;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.util.events.MixedCollection_me_sortersEvent")]
public class MixedCollection_me_sortersEvent extends FlExtEvent {
  /**
   * Fires before a sort occurs.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Sortable.html#event-beforesort Original Ext JS documentation of 'beforesort'
   * @see ext.util.MixedCollection
   * @eventType onBeforeSort
   */
  public static const BEFORE_SORT:String = "onBeforeSort";
  public static const __PARAMETER_SEQUENCE__:Array = ["me", "sorters", "eOpts"];

  public function MixedCollection_me_sortersEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * This object.
   */
  public native function get me():Sortable;

  [ArrayElementType("ext.util.Sorter")]
  /**
   * The collection of Sorters being used to generate
   * the comparator function.
   */
  public native function get sorters():Array;
}
}