package ext.view {
import ext.Component;
import ext.data.AbstractStore;
import ext.data.Model;
import ext.data.Store;
import ext.event.Event;
import ext.selection.SelectionModel;
import ext.util.IStoreHolder;

import js.HTMLElement;

[Native("Ext.view.AbstractView", require)]
/**
 * @see ext.view.events.AbstractViewEvent.BEFORE_REFRESH
 * @eventType ext.view.events.AbstractViewEvent.BEFORE_REFRESH
 */
[Event(name='onBeforeRefresh', type='ext.view.events.AbstractViewEvent')]
/**
 * @see ext.view.events.AbstractView_records_index_node_viewEvent.ITEM_ADD
 * @eventType ext.view.events.AbstractView_records_index_node_viewEvent.ITEM_ADD
 */
[Event(name='onItemAdd', type='ext.view.events.AbstractView_records_index_node_viewEvent')]
/**
 * @see ext.view.events.AbstractView_records_index_item_viewEvent.ITEM_REMOVE
 * @eventType ext.view.events.AbstractView_records_index_item_viewEvent.ITEM_REMOVE
 */
[Event(name='onItemRemove', type='ext.view.events.AbstractView_records_index_item_viewEvent')]
/**
 * @see ext.view.events.AbstractView_record_index_node_viewEvent.ITEM_UPDATE
 * @eventType ext.view.events.AbstractView_record_index_node_viewEvent.ITEM_UPDATE
 */
[Event(name='onItemUpdate', type='ext.view.events.AbstractView_record_index_node_viewEvent')]
/**
 * @see ext.view.events.AbstractViewEvent.REFRESH
 * @eventType ext.view.events.AbstractViewEvent.REFRESH
 */
[Event(name='onRefresh', type='ext.view.events.AbstractViewEvent')]
/**
 * @see ext.view.events.AbstractViewEvent.VIEW_READY
 * @eventType ext.view.events.AbstractViewEvent.VIEW_READY
 */
[Event(name='onViewReady', type='ext.view.events.AbstractViewEvent')]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>This is an abstract superclass and should not be used directly. Please see →<code>ext.view.DataView</code>.</p>
 * @see ext.view.DataView
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html Original Ext JS documentation of 'Ext.view.AbstractView'
 */
public class AbstractView extends Component implements IStoreHolder {
  /**
   * Global config for use when using
   * <i>throttled view updating</i> (→<code>throttledUpdate</code>) if the data in the backing
   * <i>store</i> (→<code>ext.data.Store</code>) is being changed rapidly, for example receiving changes
   * from the server through a WebSocket connection.
   * <p>To avoid too-frequent view updates overloading the browser with style recalculation,
   * layout and paint requests, updates can be <i>throttled</i> (→<code>throttledUpdate</code>) to
   * coalesced, and applied at the interval specified in milliseconds.</p>
   * <p>Note that on lower powered devices, updating is throttled to once every second.</p>
   * @default 200
   * @see #throttledUpdate
   * @see ext.data.Store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#static-property-updateDelay Original Ext JS documentation of 'updateDelay'
   */
  public static native function get updateDelay():Number;

  /**
   * @private
   */
  public static native function set updateDelay(value:Number):void;

  /**
   * @param config @inheritDoc
   */
  public function AbstractView(config:AbstractView = null) {
    super();
  }

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'listbox'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  public native function set ariaRole(value:String):void;

  /**
   * This property allows the object
   * to destroy bound stores that have →<code>ext.data.AbstractStore.autoDestroy</code>
   * option set to <code>true</code>.
   * @default true
   * @see ext.data.AbstractStore#autoDestroy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#property-autoDestroyBoundStore Original Ext JS documentation of 'autoDestroyBoundStore'
   */
  public native function get autoDestroyBoundStore():Boolean;

  /**
   * @private
   */
  public native function set autoDestroyBoundStore(value:Boolean):void;

  [ExtConfig]
  /**
   * Set this to true to ignore refresh events on the bound store. This is useful if
   * you wish to provide custom transition animations via a plugin
   * @default false
   * @since 3.4.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-blockRefresh Original Ext JS documentation of 'blockRefresh'
   */
  public native function get blockRefresh():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set blockRefresh(value:Boolean):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @default 'store'
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  override public native function get defaultBindProperty():String;

  /**
   * @private
   */
  override public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  /**
   * True to defer emptyText being applied until the store's first load.
   * @default true
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-deferEmptyText Original Ext JS documentation of 'deferEmptyText'
   */
  public native function get deferEmptyText():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set deferEmptyText(value:Boolean):void;

  [ExtConfig]
  /**
   * Configure as 'true` to defer the initial refresh of the view.
   * <p>This allows the View to execute its render and initial layout more quickly because
   * the process will not be encumbered by the update of the view structure.</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-deferInitialRefresh Original Ext JS documentation of 'deferInitialRefresh'
   */
  public native function get deferInitialRefresh():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set deferInitialRefresh(value:Boolean):void;

  [ExtConfig]
  /**
   * True to disable selection within the DataView. This configuration will lock
   * the selection model that the DataView uses.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-disableSelection Original Ext JS documentation of 'disableSelection'
   */
  public native function get disableSelection():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disableSelection(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The text to display in the view when there is no data to display.
   * Note that when using local data the emptyText will not be displayed unless you set
   * the →<code>deferEmptyText</code> option to false.
   * @default ""
   * @since 2.3.0
   * @see #deferEmptyText
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-emptyText Original Ext JS documentation of 'emptyText'
   * @see #getEmptyText()
   * @see #setEmptyText()
   */
  public native function get emptyText():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set emptyText(value:String):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default true
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  public native function set focusable(value:Boolean):void;

  [ExtConfig]
  /**
   * Specifies the class to be assigned to each element in the view when used in conjunction
   * with the →<code>itemTpl</code> configuration.
   * @default Ext.baseCSSPrefix + 'dataview-item'
   * @since 2.3.0
   * @see #itemTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-itemCls Original Ext JS documentation of 'itemCls'
   */
  public native function get itemCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemCls(value:String):void;

  [ExtConfig]
  /**
   * <b>This is a required setting</b>. A simple CSS selector (e.g. <code>div.some-class</code> or
   * <code>span:first-child</code>) that will be used to determine what nodes this DataView will be
   * working with. The itemSelector is used to map DOM nodes to records. As such, there should
   * only be one root level element that matches the selector for each record. The itemSelector
   * will be automatically configured if the →<code>itemTpl</code> config is used.
   * <pre>
   * new Ext.view.View({
   *     renderTo: Ext.getBody(),
   *     store: {
   *         fields: ['name'],
   *         data: [
   *             {name: 'Item 1'},
   *             {name: 'Item 2'}
   *         ]
   *     },
   *     tpl: [
   *         '&lt;ul&gt;',
   *         '&lt;tpl for="."&gt;',
   *             '&lt;li&gt;{name}&lt;/li&gt;',
   *         '&lt;/tpl&gt;',
   *         '&lt;/ul&gt;'
   *     ],
   *     // Match the li, since each one maps to a record
   *     itemSelector: 'li'
   * });
   * </pre>
   * @since 2.3.0
   * @see #itemTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-itemSelector Original Ext JS documentation of 'itemSelector'
   */
  public native function get itemSelector():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemSelector(value:String):void;

  [ExtConfig]
  /**
   * The inner portion of the item template to be rendered. Follows an XTemplate
   * structure and will be placed inside of a tpl.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-itemTpl Original Ext JS documentation of 'itemTpl'
   */
  public native function get itemTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemTpl(value:*):void;

  [ExtConfig]
  /**
   * False to disable a load mask from displaying while the view is loading. This can also be a
   * →<code>ext.LoadMask</code> configuration object.
   * @default true
   * @see ext.LoadMask
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-loadMask Original Ext JS documentation of 'loadMask'
   */
  public native function get loadMask():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set loadMask(value:*):void;

  [ExtConfig]
  /**
   * The CSS class to apply to the loading message element. Defaults to
   * Ext.LoadMask.prototype.msgCls "x-mask-loading".
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-loadingCls Original Ext JS documentation of 'loadingCls'
   */
  public native function get loadingCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set loadingCls(value:String):void;

  [ExtConfig]
  /**
   * If specified, gives an explicit height for the data view when it is showing the
   * →<code>loadingText</code>, if that is specified. This is useful to prevent the view's height
   * from collapsing to zero when the loading mask is applied and there are no other contents
   * in the data view.
   * @see #loadingText
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-loadingHeight Original Ext JS documentation of 'loadingHeight'
   */
  public native function get loadingHeight():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set loadingHeight(value:Number):void;

  [ExtConfig]
  /**
   * A string to display during data load operations. If specified, this text will be
   * displayed in a loading div and the view's contents will be cleared while loading, otherwise
   * the view's contents will continue to display normally until the new data is loaded
   * and the contents are replaced.
   * @default 'Loading...'
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-loadingText Original Ext JS documentation of 'loadingText'
   */
  public native function get loadingText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set loadingText(value:String):void;

  [Deprecated(replacement="mode", since="4.0")]
  [ExtConfig]
  /**
   * True to allow selection of more than one item at a time, false to allow selection
   * of only a single item at a time or no selection at all, depending on the value of
   * →<code>singleSelect</code>.
   * @default false
   * @since 2.3.0
   * @see #singleSelect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-multiSelect Original Ext JS documentation of 'multiSelect'
   */
  public native function get multiSelect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set multiSelect(value:Boolean):void;

  [ExtConfig]
  /**
   * A CSS class to apply to each item in the view on mouseover.
   * Setting this will automatically set →<code>trackOver</code> to <code>true</code>.
   * @see #trackOver
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-overItemCls Original Ext JS documentation of 'overItemCls'
   */
  public native function get overItemCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set overItemCls(value:String):void;

  [ExtConfig]
  /**
   * True to preserve scroll position across refresh operations.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-preserveScrollOnRefresh Original Ext JS documentation of 'preserveScrollOnRefresh'
   */
  public native function get preserveScrollOnRefresh():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preserveScrollOnRefresh(value:Boolean):void;

  [ExtConfig]
  /**
   * True to preserve scroll position when the store is reloaded.
   * <p>You may want to configure this as <code>true</code> if you are using a
   * <i>buffered store</i> (→<code>ext.data.BufferedStore</code>) and you require refreshes of the client side
   * data state not to disturb the state of the UI.</p>
   * @default false
   * @since 5.1.1
   * @see ext.data.BufferedStore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-preserveScrollOnReload Original Ext JS documentation of 'preserveScrollOnReload'
   */
  public native function get preserveScrollOnReload():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preserveScrollOnReload(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default [
   *     'selection'
   * ]
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * A CSS class to apply to each selected item in the view.
   * @default Ext.baseCSSPrefix + 'item-selected'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-selectedItemCls Original Ext JS documentation of 'selectedItemCls'
   */
  public native function get selectedItemCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set selectedItemCls(value:String):void;

  [ExtConfig]
  /**
   * The selected model. Typically used with <i>binding</i> (→<code>bind</code>).
   * @see #bind
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-selection Original Ext JS documentation of 'selection'
   * @see #setSelection()
   */
  public native function get selection():Model;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set selection(value:Model):void;

  [ExtConfig]
  [Bindable]
  /**
   * The <i>selection model</i> (→<code>ext.selection.SelectionModel</code>) [dataviewmodel] config or alias to use.
   * @default {
   *     type: 'dataviewmodel'
   * }
   * @since 5.1.0
   * @see ext.selection.SelectionModel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-selectionModel Original Ext JS documentation of 'selectionModel'
   * @see #getSelectionModel()
   * @see #setSelectionModel()
   */
  public native function get selectionModel():SelectionModel;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set selectionModel(value:SelectionModel):void;

  [Deprecated(replacement="mode", since="4.0")]
  [ExtConfig]
  /**
   * True to enable multiselection by clicking on multiple items without requiring
   * the user to hold Shift or Ctrl, false to force the user to hold Ctrl or Shift
   * to select more than on item.
   * @default false
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-simpleSelect Original Ext JS documentation of 'simpleSelect'
   */
  public native function get simpleSelect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set simpleSelect(value:Boolean):void;

  [ExtConfig]
  /**
   * Allows selection of exactly one item at a time. As this is the default selection mode
   * anyway, this config is completely ignored.
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-singleSelect Original Ext JS documentation of 'singleSelect'
   */
  public native function get singleSelect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set singleSelect(value:Boolean):void;

  [ExtConfig]
  /**
   * The →<code>ext.data.Store</code> to bind this DataView to.
   * @default 'ext-empty-store'
   * @since 2.3.0
   * @see ext.data.Store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-store Original Ext JS documentation of 'store'
   * @see #setStore()
   */
  public native function get store():Store;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set store(value:Store):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * DOM tabIndex attribute for this component's →<code>focusEl</code>.
   * @default 0
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-tabIndex Original Ext JS documentation of 'tabIndex'
   * @see #getTabIndex()
   * @see #setTabIndex()
   */
  override public native function get tabIndex():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set tabIndex(value:Number):void;

  [ExtConfig]
  /**
   * Configure as <code>true</code> to have this view participate in the global throttled update queue
   * which flushes store changes to the UI at a maximum rate determined by the
   * →<code>updateDelay</code> setting.
   * @default false
   * @see #updateDelay
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-throttledUpdate Original Ext JS documentation of 'throttledUpdate'
   */
  public native function get throttledUpdate():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set throttledUpdate(value:Boolean):void;

  [ExtConfig]
  /**
   * <b>This is a required setting</b>. The HTML fragment or an array of fragments that will make up the template
   * used by this DataView. This should be specified in the same format expected by the
   * constructor of →<code>ext.XTemplate</code>. When a <code>→tpl</code> is specified, this class assumes that
   * records are rendered in the order they appear in the <code>→store</code>. If a custom <code>→tpl</code>
   * does not conform to this assumption, index values will be incorrect which may cause the view
   * to misbehave.
   * @since 2.3.0
   * @see ext.XTemplate
   * @see #tpl
   * @see #store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-tpl Original Ext JS documentation of 'tpl'
   */
  override public native function get tpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set tpl(value:*):void;

  [ExtConfig]
  /**
   * When <code>true</code> the →<code>overItemCls</code> will be applied to items when hovered over.
   * This in return will also cause →<code>ext.view.DataView.event:onHighlightItem</code> and
   * →<code>ext.view.DataView.event:onUnhighlightItem</code> events to be fired.
   * <p>Enabled automatically when the →<code>overItemCls</code> config is set.</p>
   * @default false
   * @since 2.3.0
   * @see #overItemCls
   * @see ext.view.DataView#event:onHighlightItem
   * @see ext.view.DataView#event:onUnhighlightItem
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-trackOver Original Ext JS documentation of 'trackOver'
   */
  public native function get trackOver():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set trackOver(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object holds a map of <code>config</code> properties that will update their binding
   * as they are modified. For example, <code>value</code> is a key added by form fields. The
   * form of this config is the same as <code>→publishes</code>.
   * <p>This config is defined so that updaters are not created and added for all
   * bound properties since most cannot be modified by the end-user and hence are
   * not appropriate for two-way binding.</p>
   * @default [
   *     'selection'
   * ]
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  override public native function get twoWayBindable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set twoWayBindable(value:*):void;

  /**
   * Adds a CSS Class to a specific item.
   * @param itemInfo An HTMLElement,
   * index or instance of a model representing this item
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-addItemCls Original Ext JS documentation of 'addItemCls'
   */
  public native function addItemCls(itemInfo:*, cls:String):void;

  /**
   * Changes the data store bound to this view and refreshes it.
   * @since 3.4.0
   * @param store The store to bind or ID of the store.
   * When no store given (or when <code>null</code> or <code>undefined</code> passed), unbinds the existing store.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-bindStore Original Ext JS documentation of 'bindStore'
   */
  public native function bindStore(store:Store = undefined, initial:Boolean = undefined, propertyName:* = undefined):void;

  /**
   * Binds listeners for this component to the store. By default it will add
   * anything bound by the getStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to bind to
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-bindStoreListeners Original Ext JS documentation of 'bindStoreListeners'
   */
  protected native function bindStoreListeners(store:AbstractStore):void;

  [Deprecated(replacement="deselectAll", since="4.0")]
  /**
   * Deselects all selected records.
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-clearSelections Original Ext JS documentation of 'clearSelections'
   */
  public native function clearSelections():void;

  /**
   * Function which can be overridden which returns the data object passed to this
   * DataView's <i>template</i> (→<code>tpl</code>) to render the whole DataView.
   * <p>This is usually an Array of data objects, each element of which is processed by an
   * →<code>ext.XTemplate</code> which uses <code>'&amp;lt;tpl for="."&amp;gt;'</code> to iterate over
   * its supplied data object as an Array. However, <i>named</i> properties may be placed
   * into the data object to provide non-repeating data such as headings, totals etc.</p>
   * @since 2.3.0
   * @param records An Array of →<code>ext.data.Model</code>s to be rendered into
   * the DataView.
   * @param startIndex the index number of the Record being prepared for rendering.
   * @return An Array of data objects to be processed by a repeating XTemplate.
   * May also contain <i>named</i> properties.
   * @see #tpl
   * @see ext.XTemplate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-collectData Original Ext JS documentation of 'collectData'
   * @see ext.data.Model
   */
  public native function collectData(records:Array, startIndex:Number):Array;

  /**
   * Deselects a record instance by record instance or index.
   * @since 2.3.0
   * @param records An array of records or an index
   * @param suppressEvent Set to false to not fire a deselect event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-deselect Original Ext JS documentation of 'deselect'
   */
  public native function deselect(records:*, suppressEvent:Boolean):void;

  /**
   * Returns the template node the passed child belongs to, or null if it doesn't belong to one.
   * @return The template node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-findItemByChild Original Ext JS documentation of 'findItemByChild'
   */
  public native function findItemByChild(node:HTMLElement):HTMLElement;

  /**
   * Returns the template node by the Ext.event.Event or null if it is not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-findTargetByEvent Original Ext JS documentation of 'findTargetByEvent'
   */
  public native function findTargetByEvent(e:Event):void;

  /**
   * Returns the value of <code>emptyText</code>.
   * @see #emptyText
   */
  public native function getEmptyText():String;

  /**
   * Gets a template node.
   * @since 2.3.0
   * @param nodeInfo An HTMLElement template node,
   * index of a template node, the id of a template node or the record associated with the node.
   * @return The node or null if it wasn't found
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-getNode Original Ext JS documentation of 'getNode'
   */
  public native function getNode(nodeInfo:*):HTMLElement;

  /**
   * Returns a CSS selector which selects the element which contains record nodes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-getNodeContainerSelector Original Ext JS documentation of 'getNodeContainerSelector'
   */
  public native function getNodeContainerSelector():String;

  [ArrayElementType("js.HTMLElement")]
  /**
   * Gets a range nodes.
   * @since 2.3.0
   * @param start The index of the first node in the range
   * @param end The index of the last node in the range
   * @return An array of nodes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-getNodes Original Ext JS documentation of 'getNodes'
   */
  public native function getNodes(start:Number = NaN, end:Number = NaN):Array;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  override public native function getPublishes():*;

  /**
   * Gets a record from a node
   * @since 2.3.0
   * @param node The node to evaluate
   * @return record The →<code>ext.data.Model</code> object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-getRecord Original Ext JS documentation of 'getRecord'
   * @see ext.data.Model
   */
  public native function getRecord(node:HTMLElement):Model;

  [ArrayElementType("ext.data.Model")]
  /**
   * Gets an array of the records from an array of nodes
   * @since 2.3.0
   * @param nodes The nodes to evaluate
   * @return records The →<code>ext.data.Model</code> objects
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-getRecords Original Ext JS documentation of 'getRecords'
   * @see ext.data.Model
   */
  public native function getRecords(nodes:Array):Array;

  [ArrayElementType("js.HTMLElement")]
  /**
   * Gets the currently selected nodes.
   * @since 2.3.0
   * @return An array of HTMLElements
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-getSelectedNodes Original Ext JS documentation of 'getSelectedNodes'
   */
  public native function getSelectedNodes():Array;

  [ArrayElementType("ext.data.Model")]
  [Deprecated(replacement="getSelection", since="4.0")]
  /**
   * Gets an array of the selected records
   * @since 2.3.0
   * @return An array of →<code>ext.data.Model</code> objects
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-getSelectedRecords Original Ext JS documentation of 'getSelectedRecords'
   * @see ext.data.Model
   */
  public native function getSelectedRecords():Array;

  [Deprecated(replacement="getCount", since="4.0")]
  /**
   * Gets the number of selected nodes.
   * @since 2.3.0
   * @return The node count
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-getSelectionCount Original Ext JS documentation of 'getSelectionCount'
   */
  public native function getSelectionCount():Number;

  /**
   * Returns the value of <code>selectionModel</code>.
   * @see #selectionModel
   */
  public native function getSelectionModel():SelectionModel;

  /**
   * Returns the value of <code>store</code>.
   * @see #store
   */
  public native function getStore():AbstractStore;

  /**
   * Gets the listeners to bind to a new store.
   * @param store The Store which is being bound to for which a listeners object
   * should be returned.
   * @return The listeners to be bound to the store in object literal form. The scope
   * may be omitted, it is assumed to be the current instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-getStoreListeners Original Ext JS documentation of 'getStoreListeners'
   */
  protected native function getStoreListeners(store:Store):Object;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  override public native function getTwoWayBindable():*;

  /**
   * Finds the index of the passed node.
   * @since 2.3.0
   * @param node An HTMLElement template node,
   * index of a template node, the id of a template node or a record associated with a node.
   * @return The index of the node or -1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-indexOf Original Ext JS documentation of 'indexOf'
   */
  public native function indexOf(node:*):Number;

  /**
   * Returns true if the passed node is selected, else false.
   * @since 2.3.0
   * @param node The node, node index or record to check
   * @return True if selected, else false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-isSelected Original Ext JS documentation of 'isSelected'
   */
  public native function isSelected(node:*):Boolean;

  /**
   * Template method, it is called when a new store is bound
   * to the current instance.
   * @param store The store being bound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onBindStore Original Ext JS documentation of 'onBindStore'
   */
  protected native function onBindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * Template method, it is called when an existing store is unbound
   * from the current instance.
   * @param store The store being unbound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onUnbindStore Original Ext JS documentation of 'onUnbindStore'
   */
  protected native function onUnbindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * Function which can be overridden to provide custom formatting for each Record that is used by
   * this DataView's <i>template</i> (→<code>tpl</code>) to render each node.
   * @since 2.3.0
   * @param data The raw data object that was used to create the Record.
   * @param recordIndex the index number of the Record being prepared for rendering.
   * @param record The Record being prepared for rendering.
   * @return The formatted data in a format expected by the internal
   * <i>template</i> (→<code>tpl</code>)'s overwrite() method. (either an array if your params are numeric
   * (i.e. {0}) or an object (i.e. { foo: 'bar' }))
   * @see #tpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-prepareData Original Ext JS documentation of 'prepareData'
   */
  public native function prepareData(data:*, recordIndex:Number, record:Model):*;

  /**
   * Refreshes the view by reloading the data from the store and re-rendering the template.
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-refresh Original Ext JS documentation of 'refresh'
   */
  public native function refresh():void;

  /**
   * Refreshes an individual node's data from the store.
   * @since 2.3.0
   * @param record The record or index of the record to update.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-refreshNode Original Ext JS documentation of 'refreshNode'
   */
  public native function refreshNode(record:Number):void;

  /**
   * Removes a CSS Class from a specific item.
   * @param itemInfo An HTMLElement,
   * index or instance of a model representing this item
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-removeItemCls Original Ext JS documentation of 'removeItemCls'
   */
  public native function removeItemCls(itemInfo:*, cls:String):void;

  [Deprecated(replacement="select", since="4.0")]
  /**
   * Selects a record instance by record instance or index.
   * @since 2.3.0
   * @param records An array of records or an index
   * @param keepExisting
   * @param suppressEvent Set to false to not fire a select event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-select Original Ext JS documentation of 'select'
   */
  public native function select(records:*, keepExisting:Boolean = false, suppressEvent:Boolean = false):void;

  /**
   * Sets the value of <code>emptyText</code>.
   * @param emptyText The new value.
   * @see #emptyText
   */
  public native function setEmptyText(emptyText:String):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  override public native function setPublishes(publishes:*):void;

  /**
   * Sets the value of the selection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#method-setSelection Original Ext JS documentation of 'setSelection'
   */
  public native function setSelection(selection:Model):void;

  /**
   * Sets the value of <code>selectionModel</code>.
   * @param selectionModel The new value.
   * @see #selectionModel
   */
  public native function setSelectionModel(selectionModel:*):void;

  /**
   * Sets the value of <code>store</code>.
   * @see #store
   */
  public native function setStore(store:Object):void;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  override public native function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * Unbinds listeners from this component to the store. By default it will remove
   * anything bound by the bindStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to unbind from
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-unbindStoreListeners Original Ext JS documentation of 'unbindStoreListeners'
   */
  protected native function unbindStoreListeners(store:AbstractStore):void;
}
}
