package ext.view {
import ext.dom.Element;

[Native("Ext.view.BoundListKeyNav", require)]
/**
 * A specialized →<code>ext.util.KeyNav</code> implementation for navigating a →<code>ext.view.BoundListView</code>
 * using the keyboard. The up, down, pageup, pagedown, home, and end keys move the active highlight
 * through the list. The enter key invokes the selection model's select action using the highlighted
 * item.
 * @see ext.util.KeyNav
 * @see ext.view.BoundListView
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundListKeyNav.html Original Ext JS documentation of 'Ext.view.BoundListKeyNav'
 */
public class BoundListKeyNavView extends NavigationModelView {
  /**
   * @param config @inheritDoc
   */
  public function BoundListKeyNavView(config:BoundListKeyNavView = null) {
    super();
  }

  [ExtConfig]
  /**
   * <b>This is a required setting</b>. The →<code>ext.view.BoundListView</code> instance for which key navigation will be managed.
   * @see ext.view.BoundListView
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundListKeyNav.html#cfg-boundList Original Ext JS documentation of 'boundList'
   */
  public native function get boundList():BoundListView;

  [ExtConfig]
  /**
   * @private
   */
  public native function set boundList(value:BoundListView):void;

  /**
   * Highlights the item at the given index.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundListKeyNav.html#method-focusItem Original Ext JS documentation of 'focusItem'
   */
  override protected native function focusItem(item:Element):void;

  /**
   * Triggers selection of the currently highlighted item according to the behavior of
   * the configured SelectionModel.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundListKeyNav.html#method-selectHighlighted Original Ext JS documentation of 'selectHighlighted'
   */
  public native function selectHighlighted(e:*):void;
}
}