package ext.view {
import ext.Component;
import ext.mixin.IQueryable;
import ext.toolbar.PagingToolbar;

[Native("Ext.view.BoundList", require)]
/**
 * An internally used DataView for →<code>ext.form.field.ComboBox</code>.
 * @see ext.form.field.ComboBox
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html Original Ext JS documentation of 'Ext.view.BoundList'
 */
public class BoundListView extends DataView implements IQueryable {
  /**
   * @param config @inheritDoc
   */
  public function BoundListView(config:BoundListView = null) {
    super();
  }

  [ExtConfig]
  /**
   * By default, when the →<code>ext.Component.alignTo()</code> method is called, a floating
   * component will scroll to keep aligned with the anchoring element if the anchoring element
   * is part of the scroll.
   * <p>If this is not necessary, and the <code>→alignTo()</code> is a one-off operation then set this config
   * to <code>false</code>.</p>
   * @default false
   * @see ext.Component#alignTo()
   * @see #alignTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-alignOnScroll Original Ext JS documentation of 'alignOnScroll'
   */
  override public native function get alignOnScroll():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set alignOnScroll(value:Boolean):void;

  /**
   * The name of the Component property that holds
   * a reference to the Element that serves as that Component's ARIA element.
   * This property will be replaced with the actual Element reference after rendering.
   * <p>Most of the simple Components will have their main element as ariaEl.</p>
   * @default 'listEl'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#property-ariaEl Original Ext JS documentation of 'ariaEl'
   */
  public native function get ariaEl():String;

  /**
   * @private
   */
  public native function set ariaEl(value:String):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'boundlist'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default [
   *     'listWrap',
   *     'listEl'
   * ]
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  [ExtConfig]
  /**
   * The sizing and positioning of a Component's internal Elements is the responsibility
   * of the Component's layout manager which sizes a Component's internal structure in response
   * to the Component being sized.
   * <p>Generally, developers will not use this configuration as all provided Components which need
   * their internal elements sizing (Such as <i>input fields</i> (→<code>ext.form.field.BaseField</code>)) come with
   * their own componentLayout managers.</p>
   * <p>The <i>default layout manager</i> (→<code>ext.layout.container.AutoLayout</code>) will be used on instances of the
   * base Ext.Component class which simply sizes the Component's encapsulating element to the
   * height and width specified in the →<code>setSize()</code> method.</p>
   * @default 'boundlist'
   * @see ext.form.field.BaseField
   * @see ext.layout.container.AutoLayout
   * @see #setSize()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-componentLayout Original Ext JS documentation of 'componentLayout'
   */
  override public native function get componentLayout():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set componentLayout(value:*):void;

  [ExtConfig]
  /**
   * The field from the store to show in the view.
   * @default ""
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-displayField Original Ext JS documentation of 'displayField'
   * @see #setDisplayField()
   */
  public native function get displayField():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set displayField(value:String):void;

  [ExtConfig]
  /**
   * Specifies whether the floated component should be automatically
   * <i>focused</i> (→<code>ext.Component.focus()</code>) when it is <i>brought to the front</i> (→<code>toFront()</code>).
   * @default false
   * @see ext.Component#focus()
   * @see #toFront()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-focusOnToFront Original Ext JS documentation of 'focusOnToFront'
   */
  override public native function get focusOnToFront():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set focusOnToFront(value:Boolean):void;

  [ExtConfig]
  /**
   * Specifies the class to be assigned to each element in the view when used in conjunction
   * with the →<code>itemTpl</code> configuration.
   * @default Ext.baseCSSPrefix + 'boundlist-item'
   * @see #itemTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-itemCls Original Ext JS documentation of 'itemCls'
   */
  override public native function get itemCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set itemCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The →<code>ext.view.NavigationModelView</code> [default] alias to use.
   * @default 'boundlist'
   * @see ext.view.NavigationModelView
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-navigationModel Original Ext JS documentation of 'navigationModel'
   * @see #getNavigationModel()
   * @see #setNavigationModel()
   */
  public native function get navigationModel():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set navigationModel(value:*):void;

  [ExtConfig]
  /**
   * If greater than <code>0</code>, a →<code>ext.toolbar.PagingToolbar</code> is displayed at the bottom of the list
   * and store queries will execute with page →<code>ext.data.operation.ReadOperation.start</code> and
   * →<code>ext.data.operation.ReadOperation.limit</code> parameters.
   * @default 0
   * @see ext.toolbar.PagingToolbar
   * @see ext.data.operation.ReadOperation#start
   * @see ext.data.operation.ReadOperation#limit
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-pageSize Original Ext JS documentation of 'pageSize'
   */
  public native function get pageSize():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pageSize(value:Number):void;

  /**
   * A reference to the PagingToolbar instance in this view. Only populated if →<code>pageSize</code>
   * is greater than zero and the BoundList has been rendered.
   * @see #pageSize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#property-pagingToolbar Original Ext JS documentation of 'pagingToolbar'
   */
  public native function get pagingToolbar():PagingToolbar;

  /**
   * @private
   */
  public native function set pagingToolbar(value:PagingToolbar):void;

  [ExtConfig]
  /**
   * True to preserve scroll position across refresh operations.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-preserveScrollOnRefresh Original Ext JS documentation of 'preserveScrollOnRefresh'
   */
  override public native function get preserveScrollOnRefresh():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set preserveScrollOnRefresh(value:Boolean):void;

  [ExtConfig]
  /**
   * An →<code>ext.XTemplate</code> used to create the internal structure inside
   * this Component's encapsulating <i>Element</i> (→<code>getEl()</code>).
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b><code>null</code></b> which means that they will be
   * initially rendered with no internal structure; they render their <i>Element</i> (→<code>getEl()</code>)
   * empty. The more specialized classes with complex DOM structures provide their own template
   * definitions.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * with customized internal structure.</p>
   * <p>Upon rendering, any created child elements may be automatically imported into object
   * properties using the →<code>renderSelectors</code> and →<code>childEls</code> options.</p>
   * @default [
   *     '<div id="{id}-listWrap" data-ref="listWrap"',
   *     ' class="{baseCls}-list-ct ',
   *     Ext.dom.Element.unselectableCls,
   *     '">',
   *     '<ul id="{id}-listEl" data-ref="listEl" class="',
   *     Ext.baseCSSPrefix,
   *     'list-plain"',
   *     '<tpl foreach="ariaAttributes"> {$}="{.}"</tpl>',
   *     '>',
   *     '</ul>',
   *     '</div>',
   *     '{%',
   *     'var pagingToolbar=values.$comp.pagingToolbar;',
   *     'if (pagingToolbar) {',
   *     'Ext.DomHelper.generateMarkup(pagingToolbar.getRenderTree(), out);',
   *     '}',
   *     '%}',
   *     {
   *         disableFormats: true
   *     }
   * ]
   * @see ext.XTemplate
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-renderTpl Original Ext JS documentation of 'renderTpl'
   */
  override public native function get renderTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set renderTpl(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Configuration options to make this Component scrollable. Acceptable values are:
   * <ul>
   * <li><code>true</code> to enable auto scrolling.</li>
   * <li><code>false</code> (or <code>null</code>) to disable scrolling - this is the default.</li>
   * <li><code>x</code> or <code>horizontal</code> to enable horizontal scrolling only</li>
   * <li><code>y</code> or <code>vertical</code> to enable vertical scrolling only</li>
   * </ul>
   * <p>Also accepts a configuration object for a <code>→ext.scroll.Scroller</code> if
   * if advanced configuration is needed.</p>
   * <p>The getter for this config returns the →<code>ext.scroll.Scroller</code>
   * instance. You can use the Scroller API to read or manipulate the scroll position:</p>
   * <pre>
   * // scrolls the component to 5 on the x axis and 10 on the y axis
   * component.getScrollable().scrollTo(5, 10);
   * </pre>
   * @default true
   * @see ext.scroll.Scroller
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-scrollable Original Ext JS documentation of 'scrollable'
   * @see #getScrollable()
   * @see #setScrollable()
   */
  override public native function get scrollable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set scrollable(value:*):void;

  [ExtConfig]
  /**
   * Specifies whether the floating component should be given a shadow. Set to true
   * to automatically create an →<code>ext.dom.Shadow</code>, or a string indicating the shadow's display
   * →<code>ext.dom.Shadow.mode</code>. Set to false to disable the shadow.
   * @default false
   * @see ext.dom.Shadow
   * @see ext.dom.Shadow#mode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-shadow Original Ext JS documentation of 'shadow'
   */
  override public native function get shadow():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set shadow(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * DOM tabIndex attribute for this component's →<code>focusEl</code>.
   * @default -1
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-tabIndex Original Ext JS documentation of 'tabIndex'
   * @see #getTabIndex()
   * @see #setTabIndex()
   */
  override public native function get tabIndex():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set tabIndex(value:Number):void;

  [ExtConfig]
  /**
   * A String or Ext.XTemplate instance to apply to inner template.
   * <p>→<code>ext.view.BoundListView</code> is used for the dropdown list of
   * →<code>ext.form.field.ComboBox</code>. To customize the template you can set the tpl on
   * the combobox config object:</p>
   * <pre>
   * Ext.create('Ext.form.field.ComboBox', {
   *     fieldLabel   : 'State',
   *     queryMode    : 'local',
   *     displayField : 'text',
   *     valueField   : 'abbr',
   *     store        : Ext.create('StateStore', {
   *         fields : ['abbr', 'text'],
   *         data   : [
   *             {"abbr":"AL", "name":"Alabama"},
   *             {"abbr":"AK", "name":"Alaska"},
   *             {"abbr":"AZ", "name":"Arizona"}
   *             //...
   *         ]
   *     }),
   *     // Template for the dropdown menu.
   *     // Note the use of the "x-list-plain" and "x-boundlist-item" class,
   *     // this is required to make the items selectable.
   *     tpl: Ext.create('Ext.XTemplate',
   *         '&lt;ul class="x-list-plain"&gt;&lt;tpl for="."&gt;',
   *             '&lt;li role="option" class="x-boundlist-item"&gt;{abbr} - {name}&lt;/li&gt;',
   *         '&lt;/tpl&gt;&lt;/ul&gt;'
   *     ),
   * });
   * </pre>
   * <p>Defaults to:</p>
   * <pre>
   * Ext.create('Ext.XTemplate',
   *     '&lt;ul&gt;&lt;tpl for="."&gt;',
   *         '&lt;li role="option" class="' + itemCls + '"&gt;' + me.getInnerTpl(me.displayField) +
   *         '&lt;/li&gt;',
   *     '&lt;/tpl&gt;&lt;/ul&gt;'
   * );
   * </pre>
   * @see ext.view.BoundListView
   * @see ext.form.field.ComboBox
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-tpl Original Ext JS documentation of 'tpl'
   */
  override public native function get tpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set tpl(value:*):void;

  [ExtConfig]
  /**
   * When <code>true</code> the →<code>overItemCls</code> will be applied to items when hovered over.
   * This in return will also cause →<code>ext.view.DataView.event:onHighlightItem</code> and
   * →<code>ext.view.DataView.event:onUnhighlightItem</code> events to be fired.
   * <p>Enabled automatically when the →<code>overItemCls</code> config is set.</p>
   * @default true
   * @see #overItemCls
   * @see ext.view.DataView#event:onHighlightItem
   * @see ext.view.DataView#event:onUnhighlightItem
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#cfg-trackOver Original Ext JS documentation of 'trackOver'
   */
  override public native function get trackOver():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set trackOver(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function child(selector:* = undefined):Component;

  /**
   * @inheritDoc
   */
  public native function down(selector:* = undefined):Component;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  override public native function getChildEls():*;

  /**
   * A method that returns the inner template for displaying items in the list.
   * This method is useful to override when using a more complex display value, for example
   * inserting an icon along with the text.
   * <p>The XTemplate is created with a reference to the owning form field in the <code>field</code> property
   * to provide access to context. For example to highlight the currently typed value,
   * the getInnerTpl may be configured into a ComboBox as part of the
   * →<code>ext.form.field.ComboBox.listConfig</code>:</p>
   * <pre>
   * listConfig: {
   *     getInnerTpl: function() {
   *         return '{[values.name.replace(this.field.getRawValue(), "&lt;b&gt;" +
   *                this.field.getRawValue() + "&lt;/b&gt;")]}';
   *     }
   * }
   * </pre>
   * @param displayField The →<code>displayField</code> for the BoundList.
   * @return The inner template
   * @see ext.form.field.ComboBox#listConfig
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#method-getInnerTpl Original Ext JS documentation of 'getInnerTpl'
   * @see #displayField
   */
  public native function getInnerTpl(displayField:String):String;

  /**
   * Returns the value of <code>navigationModel</code>.
   * @see #navigationModel
   */
  public native function getNavigationModel():*;

  /**
   * Returns the value of <code>scrollable</code>.
   * @see #scrollable
   */
  override public native function getScrollable():*;

  /**
   * @inheritDoc
   */
  public native function query(selector:String = null):Array;

  /**
   * @inheritDoc
   */
  public native function queryBy(fn:Function, scope:Object = null):Array;

  /**
   * @inheritDoc
   */
  public native function queryById(id:String):Component;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  /**
   * Updates the display field for this view. This will automatically trigger
   * an regeneration of the tpl so that the updated displayField can be used
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.BoundList.html#method-setDisplayField Original Ext JS documentation of 'setDisplayField'
   */
  public native function setDisplayField(displayField:String):void;

  /**
   * Sets the value of <code>navigationModel</code>.
   * @param navigationModel The new value.
   * @see #navigationModel
   */
  public native function setNavigationModel(navigationModel:*):void;

  /**
   * Sets the value of <code>scrollable</code>.
   * @param scrollable The new value.
   * @see #scrollable
   */
  override public native function setScrollable(scrollable:*):void;

  /**
   * @inheritDoc
   */
  public native function visitPostOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;

  /**
   * @inheritDoc
   */
  public native function visitPreOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;
}
}