package ext.view {
import ext.data.Model;

import js.HTMLElement;

[Native("Ext.view.View", require)]
/**
 * @see ext.view.events.DataView_eEvent.BEFORE_CONTAINER_CLICK
 * @eventType ext.view.events.DataView_eEvent.BEFORE_CONTAINER_CLICK
 */
[Event(name='onBeforeContainerClick', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.BEFORE_CONTAINER_CONTEXT_MENU
 * @eventType ext.view.events.DataView_eEvent.BEFORE_CONTAINER_CONTEXT_MENU
 */
[Event(name='onBeforeContainerContextMenu', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.BEFORE_CONTAINER_DBLCLICK
 * @eventType ext.view.events.DataView_eEvent.BEFORE_CONTAINER_DBLCLICK
 */
[Event(name='onBeforeContainerDblclick', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.BEFORE_CONTAINER_KEY_DOWN
 * @eventType ext.view.events.DataView_eEvent.BEFORE_CONTAINER_KEY_DOWN
 */
[Event(name='onBeforeContainerKeyDown', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.BEFORE_CONTAINER_KEYPRESS
 * @eventType ext.view.events.DataView_eEvent.BEFORE_CONTAINER_KEYPRESS
 */
[Event(name='onBeforeContainerKeypress', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.BEFORE_CONTAINER_KEY_UP
 * @eventType ext.view.events.DataView_eEvent.BEFORE_CONTAINER_KEY_UP
 */
[Event(name='onBeforeContainerKeyUp', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.BEFORE_CONTAINER_MOUSE_DOWN
 * @eventType ext.view.events.DataView_eEvent.BEFORE_CONTAINER_MOUSE_DOWN
 */
[Event(name='onBeforeContainerMouseDown', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.BEFORE_CONTAINER_MOUSE_OUT
 * @eventType ext.view.events.DataView_eEvent.BEFORE_CONTAINER_MOUSE_OUT
 */
[Event(name='onBeforeContainerMouseOut', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.BEFORE_CONTAINER_MOUSE_OVER
 * @eventType ext.view.events.DataView_eEvent.BEFORE_CONTAINER_MOUSE_OVER
 */
[Event(name='onBeforeContainerMouseOver', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.BEFORE_CONTAINER_MOUSE_UP
 * @eventType ext.view.events.DataView_eEvent.BEFORE_CONTAINER_MOUSE_UP
 */
[Event(name='onBeforeContainerMouseUp', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_record_indexEvent.BEFORE_DESELECT
 * @eventType ext.view.events.DataView_record_indexEvent.BEFORE_DESELECT
 */
[Event(name='onBeforeDeselect', type='ext.view.events.DataView_record_indexEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_CLICK
 * @eventType ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_CLICK
 */
[Event(name='onBeforeItemClick', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_CONTEXT_MENU
 * @eventType ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_CONTEXT_MENU
 */
[Event(name='onBeforeItemContextMenu', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_DBLCLICK
 * @eventType ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_DBLCLICK
 */
[Event(name='onBeforeItemDblclick', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_KEY_DOWN
 * @eventType ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_KEY_DOWN
 */
[Event(name='onBeforeItemKeyDown', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_KEYPRESS
 * @eventType ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_KEYPRESS
 */
[Event(name='onBeforeItemKeypress', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_KEY_UP
 * @eventType ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_KEY_UP
 */
[Event(name='onBeforeItemKeyUp', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_LONG_PRESS
 * @eventType ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_LONG_PRESS
 */
[Event(name='onBeforeItemLongPress', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_MOUSE_DOWN
 * @eventType ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_MOUSE_DOWN
 */
[Event(name='onBeforeItemMouseDown', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_MOUSE_ENTER
 * @eventType ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_MOUSE_ENTER
 */
[Event(name='onBeforeItemMouseEnter', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_MOUSE_LEAVE
 * @eventType ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_MOUSE_LEAVE
 */
[Event(name='onBeforeItemMouseLeave', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_MOUSE_UP
 * @eventType ext.view.events.DataView_record_item_index_eEvent.BEFORE_ITEM_MOUSE_UP
 */
[Event(name='onBeforeItemMouseUp', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_indexEvent.BEFORE_SELECT
 * @eventType ext.view.events.DataView_record_indexEvent.BEFORE_SELECT
 */
[Event(name='onBeforeSelect', type='ext.view.events.DataView_record_indexEvent')]
/**
 * @see ext.view.events.DataView_eEvent.CONTAINER_CLICK
 * @eventType ext.view.events.DataView_eEvent.CONTAINER_CLICK
 */
[Event(name='onContainerClick', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.CONTAINER_CONTEXT_MENU
 * @eventType ext.view.events.DataView_eEvent.CONTAINER_CONTEXT_MENU
 */
[Event(name='onContainerContextMenu', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.CONTAINER_DBLCLICK
 * @eventType ext.view.events.DataView_eEvent.CONTAINER_DBLCLICK
 */
[Event(name='onContainerDblclick', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.CONTAINER_KEY_DOWN
 * @eventType ext.view.events.DataView_eEvent.CONTAINER_KEY_DOWN
 */
[Event(name='onContainerKeyDown', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.CONTAINER_KEYPRESS
 * @eventType ext.view.events.DataView_eEvent.CONTAINER_KEYPRESS
 */
[Event(name='onContainerKeypress', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.CONTAINER_KEY_UP
 * @eventType ext.view.events.DataView_eEvent.CONTAINER_KEY_UP
 */
[Event(name='onContainerKeyUp', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.CONTAINER_MOUSE_DOWN
 * @eventType ext.view.events.DataView_eEvent.CONTAINER_MOUSE_DOWN
 */
[Event(name='onContainerMouseDown', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.CONTAINER_MOUSE_OUT
 * @eventType ext.view.events.DataView_eEvent.CONTAINER_MOUSE_OUT
 */
[Event(name='onContainerMouseOut', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.CONTAINER_MOUSE_OVER
 * @eventType ext.view.events.DataView_eEvent.CONTAINER_MOUSE_OVER
 */
[Event(name='onContainerMouseOver', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_eEvent.CONTAINER_MOUSE_UP
 * @eventType ext.view.events.DataView_eEvent.CONTAINER_MOUSE_UP
 */
[Event(name='onContainerMouseUp', type='ext.view.events.DataView_eEvent')]
/**
 * @see ext.view.events.DataView_recordEvent.DESELECT
 * @eventType ext.view.events.DataView_recordEvent.DESELECT
 */
[Event(name='onDeselect', type='ext.view.events.DataView_recordEvent')]
/**
 * @see ext.view.events.DataView_oldFocused_newFocusedEvent.FOCUS_CHANGE
 * @eventType ext.view.events.DataView_oldFocused_newFocusedEvent.FOCUS_CHANGE
 */
[Event(name='onFocusChange', type='ext.view.events.DataView_oldFocused_newFocusedEvent')]
/**
 * @see ext.view.events.DataView_nodeEvent.HIGHLIGHT_ITEM
 * @eventType ext.view.events.DataView_nodeEvent.HIGHLIGHT_ITEM
 */
[Event(name='onHighlightItem', type='ext.view.events.DataView_nodeEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.ITEM_CLICK
 * @eventType ext.view.events.DataView_record_item_index_eEvent.ITEM_CLICK
 */
[Event(name='onItemClick', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.ITEM_CONTEXT_MENU
 * @eventType ext.view.events.DataView_record_item_index_eEvent.ITEM_CONTEXT_MENU
 */
[Event(name='onItemContextMenu', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.ITEM_DBLCLICK
 * @eventType ext.view.events.DataView_record_item_index_eEvent.ITEM_DBLCLICK
 */
[Event(name='onItemDblclick', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.ITEM_KEY_DOWN
 * @eventType ext.view.events.DataView_record_item_index_eEvent.ITEM_KEY_DOWN
 */
[Event(name='onItemKeyDown', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.ITEM_KEYPRESS
 * @eventType ext.view.events.DataView_record_item_index_eEvent.ITEM_KEYPRESS
 */
[Event(name='onItemKeypress', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.ITEM_KEY_UP
 * @eventType ext.view.events.DataView_record_item_index_eEvent.ITEM_KEY_UP
 */
[Event(name='onItemKeyUp', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.ITEM_LONG_PRESS
 * @eventType ext.view.events.DataView_record_item_index_eEvent.ITEM_LONG_PRESS
 */
[Event(name='onItemLongPress', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.ITEM_MOUSE_DOWN
 * @eventType ext.view.events.DataView_record_item_index_eEvent.ITEM_MOUSE_DOWN
 */
[Event(name='onItemMouseDown', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.ITEM_MOUSE_ENTER
 * @eventType ext.view.events.DataView_record_item_index_eEvent.ITEM_MOUSE_ENTER
 */
[Event(name='onItemMouseEnter', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.ITEM_MOUSE_LEAVE
 * @eventType ext.view.events.DataView_record_item_index_eEvent.ITEM_MOUSE_LEAVE
 */
[Event(name='onItemMouseLeave', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_item_index_eEvent.ITEM_MOUSE_UP
 * @eventType ext.view.events.DataView_record_item_index_eEvent.ITEM_MOUSE_UP
 */
[Event(name='onItemMouseUp', type='ext.view.events.DataView_record_item_index_eEvent')]
/**
 * @see ext.view.events.DataView_record_indexEvent.SELECT
 * @eventType ext.view.events.DataView_record_indexEvent.SELECT
 */
[Event(name='onSelect', type='ext.view.events.DataView_record_indexEvent')]
/**
 * @see ext.view.events.DataView_selectedEvent.SELECTION_CHANGE
 * @eventType ext.view.events.DataView_selectedEvent.SELECTION_CHANGE
 */
[Event(name='onSelectionChange', type='ext.view.events.DataView_selectedEvent')]
/**
 * @see ext.view.events.DataView_nodeEvent.UNHIGHLIGHT_ITEM
 * @eventType ext.view.events.DataView_nodeEvent.UNHIGHLIGHT_ITEM
 */
[Event(name='onUnhighlightItem', type='ext.view.events.DataView_nodeEvent')]
/**
 * A mechanism for displaying data using custom layout templates and formatting.
 * <p>The View uses an →<code>ext.XTemplate</code> as its internal templating mechanism, and is bound to an
 * →<code>ext.data.Store</code> so that as the data in the store changes the view is automatically updated
 * to reflect the changes. The view also provides built-in behavior for many common events that can
 * occur for its contained items including click, doubleclick, mouseover, mouseout, etc. as well as
 * a built-in selection model. <b>In order to use these features, an →<code>itemSelector</code> config
 * must be provided for the View to determine what nodes it will be working with.</b></p>
 * <p>The example below binds a View to a →<code>ext.data.Store</code> and renders it into an
 * →<code>ext.panel.Panel</code>.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('Image', {
 *     extend: 'Ext.data.Model',
 *     fields: [
 *         { name: 'src', type: 'string' },
 *         { name: 'caption', type: 'string' }
 *     ]
 * });
 *
 * Ext.create('Ext.data.Store', {
 *     id:'imagesStore',
 *     model: 'Image',
 *     data: [
 *         {
 *             src: 'http://www.sencha.com/img/20110215-feat-drawing.png',
 *             caption: 'Drawing &amp; Charts'
 *         },
 *         {
 *             src: 'http://www.sencha.com/img/20110215-feat-data.png',
 *             caption: 'Advanced Data'
 *         },
 *         {
 *             src: 'http://www.sencha.com/img/20110215-feat-html5.png',
 *             caption: 'Overhauled Theme'
 *         },
 *         {
 *             src: 'http://www.sencha.com/img/20110215-feat-perf.png',
 *             caption: 'Performance Tuned'
 *         }
 *     ]
 * });
 *
 * var imageTpl = new Ext.XTemplate(
 *     '&lt;tpl for="."&gt;',
 *         '&lt;div style="margin-bottom: 10px;" class="thumb-wrap"&gt;',
 *           '&lt;img src="{src}" /&gt;',
 *           '&lt;br/&gt;&lt;span&gt;{caption}&lt;/span&gt;',
 *         '&lt;/div&gt;',
 *     '&lt;/tpl&gt;'
 * );
 *
 * Ext.create('Ext.view.View', {
 *     store: Ext.data.StoreManager.lookup('imagesStore'),
 *     tpl: imageTpl,
 *     itemSelector: 'div.thumb-wrap',
 *     emptyText: 'No images available',
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.XTemplate
 * @see ext.data.Store
 * @see #itemSelector
 * @see ext.panel.Panel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.View.html Original Ext JS documentation of 'Ext.view.View'
 */
public class DataView extends AbstractView {
  /**
   * @param config @inheritDoc
   */
  public function DataView(config:DataView = null) {
    super();
  }

  /**
   * Un-highlights the currently highlighted item, if any.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.View.html#method-clearHighlight Original Ext JS documentation of 'clearHighlight'
   */
  public native function clearHighlight():void;

  /**
   * Focuses a node in the view.
   * @param rec The record associated to the node that is to be focused.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.View.html#method-focusNode Original Ext JS documentation of 'focusNode'
   */
  public native function focusNode(rec:Model):void;

  /**
   * Highlights a given item in the View. This is called by the mouseover handler
   * if →<code>overItemCls</code> and →<code>trackOver</code> are configured, but can also be called
   * manually by other code, for instance to handle stepping through the list
   * via keyboard navigation.
   * @param item The item to highlight
   * @see #overItemCls
   * @see #trackOver
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.View.html#method-highlightItem Original Ext JS documentation of 'highlightItem'
   */
  public native function highlightItem(item:HTMLElement):void;
}
}