package ext.view {
import ext.data.Store;
import ext.panel.Panel;

[Native("Ext.view.MultiSelectorSearch", require)]
/**
 * This component provides a grid holding selected items from a second store of potential
 * members. The <code>→store</code> of this component represents the selected items. The <code>searchStore</code>
 * represents the potentially selected items.
 * <p>The default view defined by this class is intended to be easily replaced by deriving a
 * new class and overriding the appropriate methods. For example, the following is a very
 * different view that uses a date range and a data view:</p>
 * <pre>
 *  Ext.define('App.view.DateBoundSearch', {
 *      extend: 'Ext.view.MultiSelectorSearch',
 *
 *      makeDockedItems: function () {
 *          return {
 *              xtype: 'toolbar',
 *              items: [{
 *                  xtype: 'datefield',
 *                  emptyText: 'Start date...',
 *                  flex: 1
 *              },{
 *                  xtype: 'datefield',
 *                  emptyText: 'End date...',
 *                  flex: 1
 *              }]
 *          };
 *      },
 *
 *      makeItems: function () {
 *          return [{
 *              xtype: 'dataview',
 *              itemSelector: '.search-item',
 *              selModel: 'rowselection',
 *              store: this.store,
 *              scrollable: true,
 *              tpl:
 *                  '&lt;tpl for="."&gt;' +
 *                      '&lt;div class="search-item"&gt;' +
 *                          '&lt;img src="{icon}"&gt;' +
 *                          '&lt;div&gt;{name}&lt;/div&gt;' +
 *                      '&lt;/div&gt;' +
 *                  '&lt;/tpl&gt;'
 *          }];
 *      },
 *
 *      getSearchStore: function () {
 *          return this.items.getAt(0).getStore();
 *      },
 *
 *      selectRecords: function (records) {
 *          var view = this.items.getAt(0);
 *          return view.getSelectionModel().select(records);
 *      }
 *  });
 * </pre>
 * <p><b>Important</b>: This class assumes there are two components with specific <code>→reference</code>
 * names assigned to them. These are <code>"searchField"</code> and <code>"searchGrid"</code>. These components
 * are produced by the <code>makeDockedItems</code> and <code>makeItems</code> method, respectively. When
 * overriding these it is important to remember to place these <code>→reference</code> values on the
 * appropriate components.</p>
 * @see #store
 * @see #reference
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html Original Ext JS documentation of 'Ext.view.MultiSelectorSearch'
 */
public class MultiSelectorSearchView extends Panel {
  /**
   * @param config @inheritDoc
   */
  public function MultiSelectorSearchView(config:MultiSelectorSearchView = null) {
    super();
  }

  [ExtConfig]
  /**
   * By default, when the →<code>ext.Component.alignTo()</code> method is called, a floating
   * component will scroll to keep aligned with the anchoring element if the anchoring element
   * is part of the scroll.
   * <p>If this is not necessary, and the <code>→alignTo()</code> is a one-off operation then set this config
   * to <code>false</code>.</p>
   * @default false
   * @see ext.Component#alignTo()
   * @see #alignTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-alignOnScroll Original Ext JS documentation of 'alignOnScroll'
   */
  override public native function get alignOnScroll():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set alignOnScroll(value:Boolean):void;

  [ExtConfig]
  /**
   * Specify as <code>false</code> to render the Panel with zero width borders.
   * <p>Leaving the value as <code>true</code> uses the selected theme's
   * →<code>ext.panel.Panel.style:$panel-border-width</code></p>
   * <p>Defaults to <code>false</code> when using or extending Neptune.</p>
   * <p><b>Note:</b> is ignored when →<code>frame</code> is set to <b>true</b>.</p>
   * @default true
   * @see ext.panel.Panel#style:$panel-border-width
   * @see #frame
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-border Original Ext JS documentation of 'border'
   * @see #setBorder()
   */
  override public native function get border():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set border(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * If <code>true</code>, this component will be the default scope (this pointer) for events
   * specified with string names so that the scope can be dynamically resolved. The
   * component will automatically become the defaultListenerScope if a
   * →<code>controller</code> is specified.
   * <p>See the introductory docs for →<code>ext.container.Container</code> for some sample
   * usages.</p>
   * <p><b>NOTE</b>: This value can only be reliably set at construction time. Setting it
   * after that time may not correctly rewire all of the potentially effected
   * listeners.</p>
   * @default true
   * @see #controller
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-defaultListenerScope Original Ext JS documentation of 'defaultListenerScope'
   * @see #getDefaultListenerScope()
   * @see #setDefaultListenerScope()
   */
  override public native function get defaultListenerScope():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set defaultListenerScope(value:Boolean):void;

  [ExtConfig]
  /**
   * A field from your grid's store that will be used for filtering your search results.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-field Original Ext JS documentation of 'field'
   */
  public native function get field():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set field(value:String):void;

  [ExtConfig]
  /**
   * Specify as true to float the Component outside of the document flow using CSS absolute
   * positioning.
   * <p>Components such as →<code>ext.window.Window</code>s and →<code>ext.menu.Menu</code>s are
   * floating by default.</p>
   * <p>Floating Components that are programmatically <i>rendered</i> (→<code>ext.Component.render()</code>)
   * will register themselves with the global <i>ZIndexManager</i> (→<code>ext.WindowManager</code>)</p>
   * <p><i>Floating Components as child items of a Container</i></p>
   * <p>A floating Component may be used as a child item of a Container. This just allows
   * the floating Component to seek a ZIndexManager by examining the ownerCt chain.</p>
   * <p>When configured as floating, Components acquire, at render time, a
   * →<code>ext.ZIndexManager</code> which manages a stack of related floating Components.
   * The ZIndexManager sorts its stack according to an incrementing access counter and the
   * →<code>ext.util.Floating.alwaysOnTop</code> config when the Component's
   * →<code>toFront()</code> method is called.</p>
   * <p>The ZIndexManager is found by traversing up the →<code>ownerCt</code> chain to find an ancestor
   * which itself is floating. This is so that descendant floating Components of floating
   * <i>Containers</i> (Such as a ComboBox dropdown within a Window) can have its zIndex managed
   * relative to any siblings, but always <b>above</b> that floating ancestor Container.</p>
   * <p>If no floating ancestor is found, a floating Component registers itself with the default
   * <i>ZIndexManager</i> (→<code>ext.WindowManager</code>).</p>
   * <p>Floating components <i>do not participate in the Container's layout</i>. Because of this,
   * they are not rendered until you explicitly →<code>show()</code> them.</p>
   * <p>After rendering, the ownerCt reference is deleted, and the →<code>floatParent</code> property
   * is set to the found floating ancestor Container. If no floating ancestor Container was found
   * the →<code>floatParent</code> property will not be set.</p>
   * @default true
   * @see ext.window.Window
   * @see ext.menu.Menu
   * @see ext.Component#render()
   * @see ext.#WindowManager ext.WindowManager
   * @see ext.ZIndexManager
   * @see ext.util.Floating#alwaysOnTop
   * @see #toFront()
   * @see #ownerCt
   * @see #show()
   * @see #floatParent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-floating Original Ext JS documentation of 'floating'
   */
  override public native function get floating():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set floating(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object containing handlers for keyboard events. The property names of this
   * object are the key name and any modifiers. The values of the properties are the
   * descriptors of how to handle each event.
   * <p>The handler descriptor can be simply the handler function(either the
   * literal function or the method name), or it can be an object with these
   * properties:</p>
   * <ul>
   * <li><code>handler</code>: The function or its name to call to handle the event.</li>
   * <li><code>scope</code>: The this pointer context (can be "this" or "controller").</li>
   * <li><code>event</code>: An optional override of the key event to which to listen.</li>
   * </ul>
   * <p><b>Important:</b> Calls to <code>setKeyMap</code> do not replace the entire <code>→keyMap</code> but
   * instead update the provided mappings. That is, unless <code>null</code> is passed as the
   * value of the <code>→keyMap</code> which will clear the <code>→keyMap</code> of all entries.</p>
   * @default {
   *     scope: 'this',
   *     ESC: 'hide'
   * }
   * @see #keyMap
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-keyMap Original Ext JS documentation of 'keyMap'
   * @see #getKeyMap()
   * @see #setKeyMap()
   */
  override public native function get keyMap():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set keyMap(value:Object):void;

  [ExtConfig]
  /**
   * <b>Important</b>: In order for child items to be correctly sized and
   * positioned, typically a layout manager <b>must</b> be specified through
   * the <code>→layout</code> configuration option.
   * <p>The sizing and positioning of child →<code>items</code> is the responsibility of
   * the Container's layout manager which creates and manages the type of layout
   * you have in mind. For example:</p>
   * <p>If the layout configuration is not explicitly specified for
   * a general purpose container (e.g. Container or Panel) the
   * <i>default layout manager</i> (→<code>ext.layout.container.AutoLayout</code>) will be used
   * which does nothing but render child components sequentially into the
   * Container (no sizing or positioning will be performed in this situation).</p>
   * <p><b>layout</b> may be specified as either as an Object or as a String:</p>
   * <p><b><i>Specify as an Object</i></b></p>
   * <p>Example usage:</p>
   * <pre>
   * layout: {
   *     type: 'vbox',
   *     align: 'left'
   * }
   * </pre>
   * <ul>
   * <li>
   * <p><b>type</b></p>
   * <p>The layout type to be used for this container. If not specified,
   * a default →<code>ext.layout.container.AutoLayout</code> will be created and used.</p>
   * <p>Valid layout <code>type</code> values are listed in →<code>null</code>.</p>
   * </li>
   * <li>
   * <p>Layout specific configuration properties</p>
   * <p>Additional layout specific configuration properties may also be
   * specified. For complete details regarding the valid config options for
   * each layout type, see the layout class corresponding to the <code>type</code>
   * specified.</p>
   * </li>
   * </ul>
   * <p><b><i>Specify as a String</i></b></p>
   * <p>Example usage:</p>
   * <pre>
   * layout: 'vbox'
   * </pre>
   * <ul>
   * <li>
   * <p><b>layout</b></p>
   * <p>The layout <code>type</code> to be used for this container (see →<code>null</code>
   * for list of valid values).</p>
   * <p>Additional layout specific configuration properties. For complete
   * details regarding the valid config options for each layout type, see the
   * layout class corresponding to the <code>→layout</code> specified.</p>
   * </li>
   * </ul>
   * <p><b><i>Configuring the default layout type</i></b></p>
   * <p>If a certain Container class has a default layout (For example a
   * →<code>ext.toolbar.Toolbar</code> with a default <code>Box</code> layout), then to simply configure
   * the default layout, use an object, but without the <code>type</code> property:</p>
   * <pre>
   * xtype: 'toolbar',
   * layout: {
   *     pack: 'center'
   * }
   * </pre>
   * @default 'fit'
   * @see #layout
   * @see #items
   * @see ext.layout.container.AutoLayout
   * @see null
   * @see ext.toolbar.Toolbar
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-layout Original Ext JS documentation of 'layout'
   * @see #setLayout()
   */
  override public native function get layout():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set layout(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value in pixels which this Component will set its height to.
   * <p><b>Warning:</b> This will override any size management applied by layout managers.</p>
   * @default 200
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-minHeight Original Ext JS documentation of 'minHeight'
   * @see #getMinHeight()
   * @see #setMinHeight()
   */
  override public native function get minHeight():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set minHeight(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value in pixels which this Component will set its width to.
   * <p><b>Warning:</b> This will override any size management applied by layout managers.</p>
   * @default 200
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-minWidth Original Ext JS documentation of 'minWidth'
   * @see #getMinWidth()
   * @see #setMinWidth()
   */
  override public native function get minWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set minWidth(value:Number):void;

  [ExtConfig]
  /**
   * If <code>true</code>, this container will be marked as being a point in the hierarchy where
   * references to items with a specified <code>→reference</code> config will be held. The container
   * will automatically become a referenceHolder if a →<code>controller</code> is specified.
   * <p>See the introductory docs for →<code>ext.container.Container</code> for more information
   * about references &amp; reference holders.</p>
   * @default true
   * @see #reference
   * @see #controller
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-referenceHolder Original Ext JS documentation of 'referenceHolder'
   */
  override public native function get referenceHolder():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set referenceHolder(value:Boolean):void;

  [ExtConfig]
  /**
   * This text is displayed as the "emptyText" of the search <code>textfield</code>.
   * @default 'Search...'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-searchText Original Ext JS documentation of 'searchText'
   */
  public native function get searchText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set searchText(value:String):void;

  [ExtConfig]
  /**
   * The data source to which the grid / tree is bound. Acceptable values for this
   * property are:
   * <ul>
   * <li><b>any →<code>ext.data.Store</code> class / subclass</b></li>
   * <li><b>an <i>ID of a store</i> (→<code>ext.data.Store.storeId</code>)</b></li>
   * <li><b>a →<code>ext.data.Store</code> config object</b>. When passing a config you can
   * specify the store type by alias. Passing a config object with a store type will
   * dynamically create a new store of that type when the grid / tree is instantiated.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   * Ext.define('MyApp.store.Customers', {
   *     extend: 'Ext.data.Store',
   *     alias: 'store.customerstore',
   *     fields: ['name']
   * });
   *
   * Ext.create({
   *     xtype: 'gridpanel',
   *     renderTo: document.body,
   *     store: {
   *         type: 'customerstore',
   *         data: [{
   *             name: 'Foo'
   *         }]
   *     },
   *     columns: [{
   *         text: 'Name',
   *         dataIndex: 'name'
   *     }]
   * });
   * </pre>
   * @see ext.data.Store
   * @see ext.data.Store#storeId
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#cfg-store Original Ext JS documentation of 'store'
   */
  public native function get store():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set store(value:*):void;

  /**
   * Returns the value of <code>defaultListenerScope</code>.
   * @see #defaultListenerScope
   */
  override public native function getDefaultListenerScope():Boolean;

  /**
   * Returns the value of <code>keyMap</code>.
   * @see #keyMap
   */
  override public native function getKeyMap():Object;

  /**
   * Returns the value of <code>minHeight</code>.
   * @see #minHeight
   */
  override public native function getMinHeight():Number;

  /**
   * Returns the value of <code>minWidth</code>.
   * @see #minWidth
   */
  override public native function getMinWidth():Number;

  /**
   * Returns the store that holds search results. By default this comes from the
   * "search grid". If this aspect of the view is changed sufficiently so that the
   * search grid cannot be found, this method should be overridden to return the proper
   * store.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelectorSearch.html#method-getSearchStore Original Ext JS documentation of 'getSearchStore'
   */
  public native function getSearchStore():Store;

  /**
   * Sets the value of <code>defaultListenerScope</code>.
   * @param defaultListenerScope The new value.
   * @see #defaultListenerScope
   */
  override public native function setDefaultListenerScope(defaultListenerScope:Boolean):void;

  /**
   * Sets the value of <code>keyMap</code>.
   * @param keyMap The new value.
   * @see #keyMap
   */
  override public native function setKeyMap(keyMap:Object):void;

  /**
   * Sets the value of <code>minHeight</code>.
   * @param minHeight The new value.
   * @see #minHeight
   */
  override public native function setMinHeight(minHeight:Number):void;

  /**
   * Sets the value of <code>minWidth</code>.
   * @param minWidth The new value.
   * @see #minWidth
   */
  override public native function setMinWidth(minWidth:Number):void;
}
}