package ext.view {
import ext.grid.GridPanel;

[Native("Ext.view.MultiSelector", require)]
/**
 * This component provides a grid holding selected items from a second store of potential
 * members. The <code>→store</code> of this component represents the selected items. The "search store"
 * represents the potentially selected items.
 * <p>While this component is a grid and so you can configure <code>→columns</code>, it is best to leave
 * that to this class in its <code>→initComponent()</code> method. That allows this class to create the
 * extra column that allows the user to remove rows. Instead use <code>→fieldName</code> and
 * <code>→fieldTitle</code> to configure the primary column's <code>dataIndex</code> and column <code>text</code>,
 * respectively.</p>
 * @see #store
 * @see #columns
 * @see #initComponent()
 * @see #fieldName
 * @see #fieldTitle
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelector.html Original Ext JS documentation of 'Ext.view.MultiSelector'
 */
public class MultiSelectorView extends GridPanel {
  /**
   * @param config @inheritDoc
   */
  public function MultiSelectorView(config:MultiSelectorView = null) {
    super();
  }

  [ExtConfig]
  /**
   * The tooltip to display when the user hovers over the "+" tool in the panel header.
   * @default 'Search for items to add'
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelector.html#cfg-addToolText Original Ext JS documentation of 'addToolText'
   */
  public native function get addToolText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set addToolText(value:String):void;

  [ExtConfig]
  /**
   * The name of the data field to display in the primary column of the grid.
   * @default "name"
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelector.html#cfg-fieldName Original Ext JS documentation of 'fieldName'
   */
  public native function get fieldName():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldName(value:String):void;

  [ExtConfig]
  /**
   * The text to display in the column header for the primary column of the grid.
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelector.html#cfg-fieldTitle Original Ext JS documentation of 'fieldTitle'
   */
  public native function get fieldTitle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldTitle(value:String):void;

  [ExtConfig]
  /**
   * The text to display in the "remove this row" column. By default this is a Unicode
   * "X" looking glyph.
   * @default '✖'
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelector.html#cfg-removeRowText Original Ext JS documentation of 'removeRowText'
   */
  public native function get removeRowText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set removeRowText(value:String):void;

  [ExtConfig]
  /**
   * The tooltip to display when the user hovers over the remove cell.
   * @default 'Remove this item'
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelector.html#cfg-removeRowTip Original Ext JS documentation of 'removeRowTip'
   */
  public native function get removeRowTip():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set removeRowTip(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object configures the search popup component. By default this contains the
   * <code>→xtype</code> for a <code>→ext.view.MultiSelectorSearchView</code> component and specifies <code>→autoLoad</code>
   * for its <code>→store</code>.
   * @default {
   *     xtype: 'multiselector-search',
   *     width: 200,
   *     height: 200,
   *     store: {
   *         autoLoad: true
   *     }
   * }
   * @see #xtype
   * @see ext.view.MultiSelectorSearchView
   * @see #autoLoad
   * @see #store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.MultiSelector.html#cfg-search Original Ext JS documentation of 'search'
   * @see #getSearch()
   * @see #setSearch()
   */
  public native function get search():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set search(value:Object):void;

  /**
   * Returns the value of <code>search</code>.
   * @see #search
   */
  public native function getSearch():Object;

  /**
   * Sets the value of <code>search</code>.
   * @param search The new value.
   * @see #search
   */
  public native function setSearch(search:Object):void;
}
}