package ext.view {
import ext.data.AbstractStore;
import ext.data.Store;
import ext.dom.Element;
import ext.mixin.IFactoryable;
import ext.mixin.Observable;
import ext.util.IStoreHolder;

[Native("Ext.view.NavigationModel", require)]
/**
 * @see ext.view.events.NavigationModelView_event_keyEventEvent.NAVIGATE
 * @eventType ext.view.events.NavigationModelView_event_keyEventEvent.NAVIGATE
 */
[Event(name='onNavigate', type='ext.view.events.NavigationModelView_event_keyEventEvent')]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>This class listens for key events fired from a →<code>ext.view.DataView</code>, and moves
 * the currently focused item by adding the class →<code>focusCls</code>.</p>
 * @see ext.view.DataView
 * @see #focusCls
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.NavigationModel.html Original Ext JS documentation of 'Ext.view.NavigationModel'
 */
public class NavigationModelView extends Observable implements IFactoryable, IStoreHolder {
  /**
   * @param config @inheritDoc
   */
  public function NavigationModelView(config:NavigationModelView = null) {
    super();
  }

  /**
   * @inheritDoc
   */
  public native function get autoDestroyBoundStore():Boolean;

  /**
   * @inheritDoc
   */
  public native function set autoDestroyBoundStore(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  /**
   * @inheritDoc
   */
  public native function bindStore(store:Store = undefined, initial:Boolean = undefined, propertyName:* = undefined):void;

  /**
   * Binds listeners for this component to the store. By default it will add
   * anything bound by the getStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to bind to
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-bindStoreListeners Original Ext JS documentation of 'bindStoreListeners'
   */
  protected native function bindStoreListeners(store:AbstractStore):void;

  /**
   * Called to focus an item in the client →<code>ext.view.DataView</code>.
   * The default implementation adds the →<code>focusCls</code> to the passed item focuses it.
   * Subclasses may choose to keep focus in another target.
   * <p>For example →<code>ext.view.BoundListKeyNavView</code> maintains focus in the input field.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see ext.view.DataView
   * @see #focusCls
   * @see ext.view.BoundListKeyNavView
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.NavigationModel.html#method-focusItem Original Ext JS documentation of 'focusItem'
   */
  protected native function focusItem(item:Element):void;

  /**
   * @inheritDoc
   */
  public native function getStore():AbstractStore;

  /**
   * Gets the listeners to bind to a new store.
   * @param store The Store which is being bound to for which a listeners object
   * should be returned.
   * @return The listeners to be bound to the store in object literal form. The scope
   * may be omitted, it is assumed to be the current instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-getStoreListeners Original Ext JS documentation of 'getStoreListeners'
   */
  protected native function getStoreListeners(store:Store):Object;

  /**
   * Template method, it is called when a new store is bound
   * to the current instance.
   * @param store The store being bound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onBindStore Original Ext JS documentation of 'onBindStore'
   */
  protected native function onBindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * Template method, it is called when an existing store is unbound
   * from the current instance.
   * @param store The store being unbound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onUnbindStore Original Ext JS documentation of 'onUnbindStore'
   */
  protected native function onUnbindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function setStore(store:Object):void;

  /**
   * Unbinds listeners from this component to the store. By default it will remove
   * anything bound by the bindStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to unbind from
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-unbindStoreListeners Original Ext JS documentation of 'unbindStoreListeners'
   */
  protected native function unbindStoreListeners(store:AbstractStore):void;
}
}